.\"$Header: /home/vikas/netmgt/nocol/src/doc/RCS/portmon.8,v 1.4 1994/11/29 20:12:56 vikas Exp $
.\"
.TH PORTMON 8 "October 1, 1993"
.SH NAME
portmon \- NOCOL monitor for TCP ports.
.SH SYNOPSIS
.B portmon
[
.B \-d
.I (debug)
] [
.B \-f
.I <config-file>
]
.\"
.SH DESCRIPTION
.LP
.B portmon
connects to a list of specified TCP ports on specified systems and
checks to see if connections are accepted on the port. It can send
a string and then parse the output against a list of responses. Each
response can be assigned a severity level.

.SH CONFIG FILE
The configuration file format is:
.RS
.sp .5
.nf
# Config file for portmon nocol monitor
#
# Order is important... the first substring match will return and NOT
# test the remaining strings.
# To check just connectivity to a port, just put the HOST line.
#
# Format:
#	POLLINTERVAL  600
#	HOST <name> <addr>  <variable>  <port#> <default severity> [send-string]
#	[maxseverity	response]
#	[maxseverity	response]
#	HOST ....
# Severity levels are: critical | error | warning | info
##
POLLINTERVAL  3600
#
# for innd. Checking for 'no space'  'expire running' 'bad article file'
HOST	c3po	192.41.171.5	NEWSport  119	Critical
crit	space
info	expire
crit	Bad file number writing history file -- throttling
crit	Cannot write active
info	posting ok
info	no posting
#
HOST	nisc	128.121.50.7	SMTPport  25	Critical  helo
info	250
#
HOST	gopher	128.121.50.2	GOPHERport  70	Critical
#
.fi
.RE
.LP
The program checks for sub-strings in the responses, and is case sensitive.
The first match returns, and the remaining list of responses is not tested.
The
.I send-string 
is optional, and the initial connect response is discarded if this is
present.
The 
.I default-severity
is the severity if none of the responses match or if a connect fails.
The severity is escalated in each pass until they reach the levels
specified in the config file.
.LP
To check just connectivity to a port, use a HOST line without any
lines for checking responses (useful for gopher, WWW, wais).
.\"------------------------------------
.SH CAVEATS
The response strings and match tests are case sensitive (done using
.I strstr()
library call).
.SH AUTHOR
Vikas Aggarwal, vikas@navya.com.
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

