/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.scanner.SampleResponse;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpStatusCode;

public class Analyser {
    private static final String p_REMOVE_HEADER = "(?m)(?i)(?s)<HEAD>.*?</HEAD>";
    private static final Pattern patternNotFound = Pattern.compile("(\\bnot\\b(found|exist))|(\\b404\\berror\\b)|(\\berror\\b404\\b)", 10);
    private static Random staticRandomGenerator = new Random();
    private static final String[] staticSuffixList = new String[]{".cfm", ".jsp", ".php", ".asp", ".aspx", ".dll", ".exe", ".pl"};
    private HttpSender httpSender = null;
    private TreeMap mapVisited = new TreeMap();
    private boolean isStop = false;

    public Analyser() {
    }

    public Analyser(HttpSender httpSender) {
        this.httpSender = httpSender;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void stop() {
        this.isStop = true;
    }

    public void start(SiteNode siteNode) {
        this.inOrderAnalyse(siteNode);
    }

    private void addAnalysedHost(URI uRI, HttpMessage httpMessage, int n) {
        this.mapVisited.put(uRI.toString(), new SampleResponse(httpMessage, n));
    }

    private void analyse(SiteNode siteNode) throws Exception {
        if (siteNode.getHistoryReference() == null) {
            return;
        }
        HttpMessage httpMessage = siteNode.getHistoryReference().getHttpMessage();
        URI uRI = (URI)httpMessage.getRequestHeader().getURI().clone();
        uRI.setQuery(null);
        if (this.mapVisited.get(uRI.toString()) != null) {
            return;
        }
        String string = this.getRandomPathSuffix(siteNode, uRI);
        HttpMessage httpMessage2 = httpMessage.cloneRequest();
        URI uRI2 = (URI)uRI.clone();
        uRI2.setPath(string);
        httpMessage2.getRequestHeader().setURI(uRI2);
        this.sendAndReceive(httpMessage2);
        if (httpMessage2.getResponseHeader().getStatusCode() == 404) {
            this.addAnalysedHost(uRI, httpMessage2, 0);
            return;
        }
        if (HttpStatusCode.isRedirection(httpMessage2.getResponseHeader().getStatusCode())) {
            this.addAnalysedHost(uRI, httpMessage2, 2);
            return;
        }
        if (httpMessage2.getResponseHeader().getStatusCode() != 200) {
            this.addAnalysedHost(uRI, httpMessage2, 1);
            return;
        }
        HttpMessage httpMessage3 = httpMessage.cloneRequest();
        URI uRI3 = httpMessage3.getRequestHeader().getURI();
        String string2 = this.getRandomPathSuffix(siteNode, uRI3);
        uRI3 = (URI)uRI.clone();
        uRI3.setPath(string2);
        httpMessage3.getRequestHeader().setURI(uRI3);
        this.sendAndReceive(httpMessage3);
        String string3 = httpMessage2.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        String string4 = httpMessage3.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        if (string3.equals(string4)) {
            httpMessage2.getResponseBody().setBody(string3);
            this.addAnalysedHost(uRI, httpMessage2, 3);
            return;
        }
        if ((string3 = string3.replaceAll(this.getPathRegex(uRI2), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", "")).equals(string4 = string4.replaceAll(this.getPathRegex(uRI3), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", ""))) {
            httpMessage2.getResponseBody().setBody(string3);
            this.addAnalysedHost(uRI, httpMessage2, 4);
            return;
        }
        this.addAnalysedHost(uRI, httpMessage2, 5);
    }

    private String getChildSuffix(SiteNode siteNode, boolean bl) {
        String string = "";
        String string2 = null;
        SiteNode siteNode2 = null;
        HistoryReference historyReference = null;
        HttpMessage httpMessage = null;
        try {
            int n;
            for (n = 0; n < staticSuffixList.length; ++n) {
                string2 = staticSuffixList[n];
                for (int i = 0; i < siteNode.getChildCount(); ++i) {
                    siteNode2 = (SiteNode)siteNode.getChildAt(i);
                    historyReference = siteNode2.getHistoryReference();
                    try {
                        httpMessage = historyReference.getHttpMessage();
                        if (!httpMessage.getRequestHeader().getURI().getPath().endsWith(string2)) continue;
                        return string2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (bl) {
                for (n = 0; n < siteNode.getChildCount(); ++n) {
                    string = this.getChildSuffix((SiteNode)siteNode.getChildAt(n), bl);
                    if (string.equals("")) continue;
                    return string;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getPathRegex(URI uRI) throws URIException {
        URI uRI2 = (URI)uRI.clone();
        String string = uRI2.getQuery();
        StringBuffer stringBuffer = new StringBuffer(100);
        uRI2.setQuery(null);
        stringBuffer.append(uRI2.toString().replaceAll("\\.", "\\."));
        if (string != null) {
            String string2 = "(\\?" + string + ")?";
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String getRandomPathSuffix(SiteNode siteNode, URI uRI) throws URIException {
        String string = this.getChildSuffix(siteNode, true);
        String string2 = "";
        string2 = uRI.getPath() == null ? "" : uRI.getPath();
        string2 = string2 + (string2.endsWith("/") ? "" : "/") + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
        string2 = string2 + string;
        return string2;
    }

    private void inOrderAnalyse(SiteNode siteNode) {
        SiteNode siteNode2 = null;
        if (this.isStop) {
            return;
        }
        if (siteNode == null) {
            return;
        }
        try {
            if (!siteNode.isRoot() && (!siteNode.isLeaf() || siteNode.isLeaf() && ((SiteNode)siteNode.getParent()).isRoot())) {
                this.analyse(siteNode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < siteNode.getChildCount() && !this.isStop(); ++i) {
            try {
                siteNode2 = (SiteNode)siteNode.getChildAt(i);
                this.inOrderAnalyse(siteNode2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isFileExist(HttpMessage httpMessage) {
        Object object;
        String string;
        if (httpMessage.getResponseHeader().isEmpty()) {
            return false;
        }
        if (httpMessage.getResponseHeader().getStatusCode() == 404) {
            return false;
        }
        URI uRI = (URI)httpMessage.getRequestHeader().getURI().clone();
        try {
            uRI.setQuery(null);
            string = uRI.getPath();
            string = string.replaceAll("/[^/]*$", "");
            uRI.setPath(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = uRI.toString();
        SampleResponse sampleResponse = (SampleResponse)this.mapVisited.get(string);
        if (sampleResponse == null) {
            try {
                uRI.setPath(null);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            object = uRI.toString();
            sampleResponse = (SampleResponse)this.mapVisited.get(object);
        }
        if (sampleResponse == null) {
            return httpMessage.getResponseHeader().getStatusCode() == 200;
        }
        if (HttpStatusCode.isRedirection(httpMessage.getResponseHeader().getStatusCode())) {
            try {
                if (sampleResponse.getMessage().getResponseHeader().getStatusCode() == httpMessage.getResponseHeader().getStatusCode() && (object = httpMessage.getResponseHeader().getHeader("Location")) != null && ((String)object).equals(sampleResponse.getMessage().getResponseHeader().getHeader("Location"))) {
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        if (httpMessage.getResponseHeader().getStatusCode() != 200) {
            return false;
        }
        object = patternNotFound.matcher(httpMessage.getResponseBody().toString());
        if (((Matcher)object).find()) {
            return false;
        }
        String string2 = httpMessage.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        if (sampleResponse.getErrorPageType() == 3) {
            return !sampleResponse.getMessage().getResponseBody().toString().equals(string2);
        }
        uRI = httpMessage.getRequestHeader().getURI();
        try {
            if (sampleResponse.getErrorPageType() == 4) {
                string2 = httpMessage.getResponseBody().toString().replaceAll(this.getPathRegex(uRI), "").replaceAll("\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s", "");
                return !sampleResponse.getMessage().getResponseBody().equals(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private void sendAndReceive(HttpMessage httpMessage) throws HttpException, IOException {
        this.httpSender.sendAndReceive(httpMessage, true);
    }
}

