/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.spider.A;
import org.parosproxy.paros.core.spider.Form;
import org.parosproxy.paros.core.spider.Frame;
import org.parosproxy.paros.core.spider.Html;
import org.parosproxy.paros.core.spider.Hyperlink;
import org.parosproxy.paros.core.spider.Input;
import org.parosproxy.paros.core.spider.Meta;
import org.parosproxy.paros.core.spider.Select;
import org.parosproxy.paros.core.spider.SpiderThread;
import org.parosproxy.paros.core.spider.Tag;
import org.parosproxy.paros.core.spider.TextArea;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class Collector {
    private SpiderThread parent = null;
    private static final String EQUAL = "=";
    private static final String AMPERSAND = "&";
    private static final String QUESTION = "?";

    Collector(SpiderThread spiderThread) {
        this.parent = spiderThread;
    }

    private HttpMessage buildMsg(URI uRI, String string) throws URIException, HttpMalformedHeaderException {
        URI uRI2 = null;
        uRI2 = new URI(uRI, string, true);
        HttpMessage httpMessage = new HttpMessage(new HttpRequestHeader("GET", uRI2, "HTTP/1.1"));
        return httpMessage;
    }

    private boolean isDuplicateInSameHtml(Vector vector, HttpMessage httpMessage) {
        if (vector.contains(httpMessage)) {
            return true;
        }
        vector.add(httpMessage);
        return false;
    }

    void collect(Html html, int n) {
        String string;
        int n2;
        String string2;
        int n3;
        Vector vector = new Vector();
        Object var4_4 = null;
        A[] aArray = html.getAs();
        Frame[] frameArray = html.getFrames();
        Hyperlink[] hyperlinkArray = html.getHyperlinks();
        Meta[] metaArray = html.getMetas();
        HttpMessage httpMessage = null;
        for (n3 = 0; n3 < aArray.length; ++n3) {
            string2 = aArray[n3].getHref().replaceAll("&amp;", AMPERSAND);
            try {
                httpMessage = this.buildMsg(html.getURI(), string2);
                if (this.isDuplicateInSameHtml(vector, httpMessage)) continue;
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n3 = 0; n3 < frameArray.length; ++n3) {
            string2 = frameArray[n3].getSrc();
            try {
                httpMessage = this.buildMsg(html.getURI(), string2);
                if (this.isDuplicateInSameHtml(vector, httpMessage)) continue;
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Vector vector2 = this.getFormsQuery(html);
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            httpMessage = (HttpMessage)vector2.get(n2);
            try {
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < hyperlinkArray.length; ++n2) {
            string = hyperlinkArray[n2].getLink().replaceAll("&amp;", AMPERSAND);
            try {
                httpMessage = this.buildMsg(html.getURI(), string);
                if (this.isDuplicateInSameHtml(vector, httpMessage)) continue;
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < metaArray.length; ++n2) {
            string = metaArray[n2].getURL();
            try {
                httpMessage = this.buildMsg(html.getURI(), string);
                if (this.isDuplicateInSameHtml(vector, httpMessage)) continue;
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Vector getFormsQuery(Html html) {
        Vector vector = new Vector();
        Form[] formArray = html.getForms();
        for (int i = 0; i < formArray.length; ++i) {
            Form form = formArray[i];
            Vector vector2 = this.getFormQuery(form, html.getURI());
            vector.addAll(vector2);
        }
        return vector;
    }

    private Vector getFormQuery(Form form, URI uRI) {
        int n;
        Vector vector = new Vector();
        Vector<Object> vector2 = new Vector<Object>();
        String string = "";
        HttpRequestHeader httpRequestHeader = null;
        HttpBody httpBody = null;
        if (form.getAction() == null) {
            return vector2;
        }
        int n2 = 1;
        for (n = 0; n < form.getSelect().length; ++n) {
            n2 *= form.getSelect()[n].getOption().length > 2 ? 2 : form.getSelect()[n].getOption().length;
        }
        if (n2 > 512) {
            return vector2;
        }
        try {
            Object object;
            Object object2;
            for (n = 0; n < form.getInput().length; ++n) {
                object2 = form.getInput()[n];
                if (((Tag)object2).getName() == null || ((Tag)object2).getName().length() == 0 || ((Input)object2).getType() != null && (((Input)object2).getType().equalsIgnoreCase("PASSWORD") || ((Input)object2).getType().equalsIgnoreCase("CHECKBOX") || ((Input)object2).getType().equalsIgnoreCase("RESET"))) continue;
                object = ((Input)object2).getValue();
                if (((Input)object2).getType().equalsIgnoreCase("TEXT") && ((String)object).equals("")) {
                    object = "1";
                }
                string = this.buildPostQueryString(string, ((Tag)object2).getName(), (String)object);
            }
            for (n = 0; n < form.getTextArea().length; ++n) {
                object2 = form.getTextArea()[n];
                if (((Tag)object2).getName() == null || ((Tag)object2).getName().length() == 0) continue;
                object = ((TextArea)object2).getValue();
                string = this.buildPostQueryString(string, ((Tag)object2).getName(), (String)object);
            }
            vector.addElement(string);
            for (n = 0; n < form.getSelect().length; ++n) {
                object2 = form.getSelect()[n];
                if (((Tag)object2).getName() == null || ((Tag)object2).getName().length() == 0) continue;
                vector = this.addSelectField(vector, (Select)object2);
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = null;
                object = null;
                String string2 = (String)vector.elementAt(n);
                if (form.getMethod().equalsIgnoreCase("GET")) {
                    String string3 = form.getAction().indexOf(QUESTION) < 0 ? form.getAction() + QUESTION + string2 : form.getAction() + AMPERSAND + string2;
                    object = new URI(uRI, string3, true);
                    httpRequestHeader = new HttpRequestHeader(form.getMethod().trim().toUpperCase(), (URI)object, "HTTP/1.1");
                    object2 = new HttpMessage(httpRequestHeader);
                } else {
                    if (!form.getMethod().equalsIgnoreCase("POST") || !this.parent.getParent().getSpiderParam().isPostForm()) continue;
                    object = new URI(uRI, form.getAction(), true);
                    httpRequestHeader = new HttpRequestHeader(form.getMethod().trim().toUpperCase(), (URI)object, "HTTP/1.1");
                    httpBody = new HttpBody(string2);
                    httpRequestHeader.setContentLength(httpBody.length());
                    object2 = new HttpMessage(httpRequestHeader, httpBody);
                }
                ((HttpMessage)object2).getRequestHeader().setContentLength(((HttpMessage)object2).getRequestBody().length());
                vector2.add(object2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector2;
    }

    private Vector addSelectField(Vector vector, Select select) {
        Vector<String> vector2 = new Vector<String>();
        String string = null;
        if (select.getOption() == null) {
            return vector2;
        }
        for (int i = 0; i < select.getOption().length && i < 2; ++i) {
            if (i == 0 && select.getOption().length > 1) continue;
            String string2 = select.getOption()[i].getValue();
            try {
                if (vector.isEmpty()) {
                    string = this.buildPostQueryString("", select.getName(), string2);
                    vector2.addElement(string);
                    continue;
                }
                for (int j = 0; j < vector.size(); ++j) {
                    string = (String)vector.elementAt(j);
                    string = this.buildPostQueryString(string, select.getName(), string2);
                    vector2.addElement(string);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector2;
    }

    private String buildPostQueryString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0) {
            stringBuffer.append(AMPERSAND);
        }
        stringBuffer.append(string2);
        stringBuffer.append(EQUAL);
        try {
            stringBuffer.append(URLEncoder.encode(string3, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

