/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.HttpPanel;

public class ManualRequestEditorDialog
extends AbstractDialog {
    private HttpPanel requestPanel = null;
    private JPanel panelCommand = null;
    private JButton btnSend = null;
    private JLabel jLabel = null;
    private JTabbedPane panelTab = null;
    private HttpPanel responsePanel = null;
    private Extension extension = null;
    private HttpSender httpSender = null;
    private boolean isSendEnabled = true;
    private JPanel jPanel = null;
    private JCheckBox chkFollowRedirect = null;
    private JCheckBox chkUseTrackingSessionState = null;

    public ManualRequestEditorDialog() throws HeadlessException {
        this.initialize();
    }

    public ManualRequestEditorDialog(Frame frame, boolean bl, boolean bl2, Extension extension) throws HeadlessException {
        super(frame, bl);
        this.isSendEnabled = bl2;
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.getRequestPanel().getPanelOption().add((Component)this.getPanelCommand(), "");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManualRequestEditorDialog.this.getHttpSender().shutdown();
                ManualRequestEditorDialog.this.getResponsePanel().setMessage("", "", false);
            }
        });
        this.setContentPane(this.getJPanel());
    }

    public HttpPanel getRequestPanel() {
        if (this.requestPanel == null) {
            this.requestPanel = new HttpPanel(true);
        }
        return this.requestPanel;
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jLabel = new JLabel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.jLabel.setText("");
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.panelCommand.add((Component)this.jLabel, gridBagConstraints3);
            this.panelCommand.add((Component)this.getChkUseTrackingSessionState(), gridBagConstraints);
            this.panelCommand.add((Component)this.getChkFollowRedirect(), gridBagConstraints2);
            this.panelCommand.add((Component)this.getBtnSend(), gridBagConstraints4);
        }
        return this.panelCommand;
    }

    private JButton getBtnSend() {
        if (this.btnSend == null) {
            this.btnSend = new JButton();
            this.btnSend.setText("Send");
            this.btnSend.setEnabled(this.isSendEnabled);
            this.btnSend.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ManualRequestEditorDialog.this.btnSend.setEnabled(false);
                    HttpMessage httpMessage = new HttpMessage();
                    ManualRequestEditorDialog.this.getRequestPanel().getMessage(httpMessage, true);
                    httpMessage.getRequestHeader().setContentLength(httpMessage.getRequestBody().length());
                    ManualRequestEditorDialog.this.send(httpMessage);
                }
            });
        }
        return this.btnSend;
    }

    private JTabbedPane getPanelTab() {
        if (this.panelTab == null) {
            this.panelTab = new JTabbedPane();
            this.panelTab.setDoubleBuffered(true);
            this.panelTab.addTab("Request", null, this.getRequestPanel(), null);
            this.panelTab.addTab("Response", null, this.getResponsePanel(), null);
        }
        return this.panelTab;
    }

    public HttpPanel getResponsePanel() {
        if (this.responsePanel == null) {
            this.responsePanel = new HttpPanel(false);
        }
        return this.responsePanel;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    private Extension getExtention() {
        return this.extension;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            try {
                if (this.httpSender != null) {
                    this.httpSender.shutdown();
                    this.httpSender = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getPanelTab().setSelectedIndex(0);
        }
        boolean bl2 = Model.getSingleton().getOptionsParam().getConnectionParam().isHttpStateEnabled();
        this.getChkUseTrackingSessionState().setEnabled(bl2);
        super.setVisible(bl);
    }

    private HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), this.getChkUseTrackingSessionState().isSelected());
        }
        return this.httpSender;
    }

    public void setMessage(HttpMessage httpMessage) {
        this.getPanelTab().setSelectedIndex(0);
        this.getRequestPanel().setMessage(httpMessage, true);
        this.getResponsePanel().setMessage("", "", false);
        this.getBtnSend().setEnabled(true);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            this.jPanel.add((Component)this.getPanelTab(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JCheckBox getChkFollowRedirect() {
        if (this.chkFollowRedirect == null) {
            this.chkFollowRedirect = new JCheckBox();
            this.chkFollowRedirect.setText("Follow redirect");
            this.chkFollowRedirect.setSelected(true);
        }
        return this.chkFollowRedirect;
    }

    private JCheckBox getChkUseTrackingSessionState() {
        if (this.chkUseTrackingSessionState == null) {
            this.chkUseTrackingSessionState = new JCheckBox();
            this.chkUseTrackingSessionState.setText("Use current tracking session");
        }
        return this.chkUseTrackingSessionState;
    }

    private void send(final HttpMessage httpMessage) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ManualRequestEditorDialog.this.getHttpSender().sendAndReceive(httpMessage, ManualRequestEditorDialog.this.getChkFollowRedirect().isSelected());
                    EventQueue.invokeAndWait(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (!3.access$400(this.this$1).getResponseHeader().isEmpty()) {
                                3.access$500(this.this$1).getResponsePanel().setMessage(3.access$400(this.this$1), false);
                            }
                            ManualRequestEditorDialog.access$600(3.access$500(this.this$1)).setSelectedIndex(1);
                        }
                    });
                }
                catch (NullPointerException nullPointerException) {
                    ManualRequestEditorDialog.this.getExtention().getView().showWarningDialog("Malformed header error.");
                }
                catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                    ManualRequestEditorDialog.this.getExtention().getView().showWarningDialog("Malformed header error.");
                }
                catch (IOException iOException) {
                    ManualRequestEditorDialog.this.getExtention().getView().showWarningDialog("IO error in sending request.");
                }
                catch (Exception exception) {
                }
                finally {
                    ManualRequestEditorDialog.this.btnSend.setEnabled(true);
                }
            }

            static /* synthetic */ HttpMessage access$400(3 var0) {
                return var0.httpMessage;
            }

            static /* synthetic */ ManualRequestEditorDialog access$500(3 var0) {
                return var0.ManualRequestEditorDialog.this;
            }
        });
        thread.setPriority(5);
        thread.start();
    }

    static /* synthetic */ JTabbedPane access$600(ManualRequestEditorDialog manualRequestEditorDialog) {
        return manualRequestEditorDialog.getPanelTab();
    }
}

