/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.view.View;

public class OutputPanel
extends AbstractPanel {
    private JScrollPane jScrollPane = null;
    private JTextArea txtOutput = null;

    public OutputPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName("Output");
        this.setSize(243, 119);
        this.add((Component)this.getJScrollPane(), this.getJScrollPane().getName());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtOutput());
            this.jScrollPane.setName("jScrollPane");
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setFont(new Font("Dialog", 0, 11));
        }
        return this.jScrollPane;
    }

    private JTextArea getTxtOutput() {
        if (this.txtOutput == null) {
            this.txtOutput = new JTextArea();
            this.txtOutput.setEditable(false);
            this.txtOutput.setLineWrap(true);
            this.txtOutput.setFont(new Font("Dialog", 0, 12));
            this.txtOutput.setName("");
            this.txtOutput.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.txtOutput;
    }

    public void append(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.getTxtOutput().append(string);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    OutputPanel.this.getTxtOutput().append(string);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        this.getTxtOutput().setText("");
    }
}

