<?php

/**
 * BaseSystemUser
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                          $id                                                Type: integer, primary key
 * @property int                                          $user_role_id                                      Type: integer
 * @property int                                          $emp_number                                        Type: integer
 * @property string                                       $user_name                                         Type: string(40)
 * @property string                                       $user_password                                     Type: string(255)
 * @property int                                          $deleted                                           Type: integer(1), default "0"
 * @property int                                          $status                                            Type: integer(1), default "1"
 * @property string                                       $date_entered                                      Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                                       $date_modified                                     Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property int                                          $modified_user_id                                  Type: integer
 * @property int                                          $created_by                                        Type: integer
 * @property Employee                                     $Employee                                          
 * @property UserRole                                     $UserRole                                          
 * @property Doctrine_Collection|Login[]                  $Login                                             
 * @property Doctrine_Collection|LeaveEntitlement[]       $LeaveEntitlement                                  
 * @property Doctrine_Collection|LeaveAdjustment[]        $LeaveAdjustment                                   
 * @property Doctrine_Collection|LeaveRequestComment[]    $LeaveRequestComment                               
 * @property Doctrine_Collection|LeaveComment[]           $LeaveComment                                      
 * @property Doctrine_Collection|UserIdentitiy[]          $UserIdentitiy                                     
 * @property Doctrine_Collection|PerformanceTrackerLog[]  $PerformanceTrackerLog                             
 * @property Doctrine_Collection|TimesheetActionLog[]     $TimesheetActionLog                                
 *  
 * @method int                                            getId()                                            Type: integer, primary key
 * @method int                                            getUserRoleId()                                    Type: integer
 * @method int                                            getEmpNumber()                                     Type: integer
 * @method string                                         getUserName()                                      Type: string(40)
 * @method string                                         getUserPassword()                                  Type: string(255)
 * @method int                                            getDeleted()                                       Type: integer(1), default "0"
 * @method int                                            getStatus()                                        Type: integer(1), default "1"
 * @method string                                         getDateEntered()                                   Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                                         getDateModified()                                  Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method int                                            getModifiedUserId()                                Type: integer
 * @method int                                            getCreatedBy()                                     Type: integer
 * @method Employee                                       getEmployee()                                      
 * @method UserRole                                       getUserRole()                                      
 * @method Doctrine_Collection|Login[]                    getLogin()                                         
 * @method Doctrine_Collection|LeaveEntitlement[]         getLeaveEntitlement()                              
 * @method Doctrine_Collection|LeaveAdjustment[]          getLeaveAdjustment()                               
 * @method Doctrine_Collection|LeaveRequestComment[]      getLeaveRequestComment()                           
 * @method Doctrine_Collection|LeaveComment[]             getLeaveComment()                                  
 * @method Doctrine_Collection|UserIdentitiy[]            getUserIdentitiy()                                 
 * @method Doctrine_Collection|PerformanceTrackerLog[]    getPerformanceTrackerLog()                         
 * @method Doctrine_Collection|TimesheetActionLog[]       getTimesheetActionLog()                            
 *  
 * @method SystemUser                                     setId(int $val)                                    Type: integer, primary key
 * @method SystemUser                                     setUserRoleId(int $val)                            Type: integer
 * @method SystemUser                                     setEmpNumber(int $val)                             Type: integer
 * @method SystemUser                                     setUserName(string $val)                           Type: string(40)
 * @method SystemUser                                     setUserPassword(string $val)                       Type: string(255)
 * @method SystemUser                                     setDeleted(int $val)                               Type: integer(1), default "0"
 * @method SystemUser                                     setStatus(int $val)                                Type: integer(1), default "1"
 * @method SystemUser                                     setDateEntered(string $val)                        Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method SystemUser                                     setDateModified(string $val)                       Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method SystemUser                                     setModifiedUserId(int $val)                        Type: integer
 * @method SystemUser                                     setCreatedBy(int $val)                             Type: integer
 * @method SystemUser                                     setEmployee(Employee $val)                         
 * @method SystemUser                                     setUserRole(UserRole $val)                         
 * @method SystemUser                                     setLogin(Doctrine_Collection $val)                 
 * @method SystemUser                                     setLeaveEntitlement(Doctrine_Collection $val)      
 * @method SystemUser                                     setLeaveAdjustment(Doctrine_Collection $val)       
 * @method SystemUser                                     setLeaveRequestComment(Doctrine_Collection $val)   
 * @method SystemUser                                     setLeaveComment(Doctrine_Collection $val)          
 * @method SystemUser                                     setUserIdentitiy(Doctrine_Collection $val)         
 * @method SystemUser                                     setPerformanceTrackerLog(Doctrine_Collection $val) 
 * @method SystemUser                                     setTimesheetActionLog(Doctrine_Collection $val)    
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseSystemUser extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_user');
        $this->hasColumn('id', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('user_role_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('emp_number', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('user_name', 'string', 40, array(
             'type' => 'string',
             'length' => 40,
             ));
        $this->hasColumn('user_password', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
        $this->hasColumn('deleted', 'integer', 1, array(
             'type' => 'integer',
             'default' => '0',
             'length' => 1,
             ));
        $this->hasColumn('status', 'integer', 1, array(
             'type' => 'integer',
             'default' => '1',
             'length' => 1,
             ));
        $this->hasColumn('date_entered', 'timestamp', 25, array(
             'type' => 'timestamp',
             'length' => 25,
             ));
        $this->hasColumn('date_modified', 'timestamp', 25, array(
             'type' => 'timestamp',
             'length' => 25,
             ));
        $this->hasColumn('modified_user_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('created_by', 'integer', null, array(
             'type' => 'integer',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasOne('UserRole', array(
             'local' => 'user_role_id',
             'foreign' => 'id'));

        $this->hasMany('Login', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('LeaveEntitlement', array(
             'local' => 'id',
             'foreign' => 'created_by_id'));

        $this->hasMany('LeaveAdjustment', array(
             'local' => 'id',
             'foreign' => 'created_by_id'));

        $this->hasMany('LeaveRequestComment', array(
             'local' => 'id',
             'foreign' => 'created_by_id'));

        $this->hasMany('LeaveComment', array(
             'local' => 'id',
             'foreign' => 'created_by_id'));

        $this->hasMany('UserIdentitiy', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('PerformanceTrackerLog', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('TimesheetActionLog', array(
             'local' => 'id',
             'foreign' => 'performed_by'));
    }
}