require 'test/unit'

module Borges; end
require 'Borges/HTML/HtmlAttributes'

class HtmlAttributesTest < Test::Unit::TestCase

  def setup
    @attributes = Borges::HtmlAttributes.new
  end

  def test_set_attribute
    @attributes["checked"]
    assert_equal " checked=\"checked\"", @attributes.to_s
  end

  def test_set_attribute_value
    @attributes["rel"] = "start"
    assert_equal " rel=\"start\"", @attributes.to_s
  end

  def test_method_missing
    @attributes.checked
    assert_equal " checked=\"checked\"", @attributes.to_s
  end

  def test_method_missing_value
    @attributes.rel "start"
    assert_equal " rel=\"start\"", @attributes.to_s
  end

  def test_method_missing=
    @attributes.rel = "start"
    assert_equal " rel=\"start\"", @attributes.to_s
  end

end # class HtmlAttributesTest

