require_relative 'instance_setting_list'

Plugin.create :mastodon_setting do
  # 設定の初期化
  defaults = {
    mastodon_enable_streaming: true,
    mastodon_rest_interval: 1,
    mastodon_show_subparts_visibility: true,
    mastodon_show_subparts_bot: true,
    mastodon_show_subparts_pin: true,
    mastodon_instances: {}
  }
  defaults.each do |key, value|
    UserConfig[key] ||= value
  end

  # 追加
  on_mastodon_instances_open_create_dialog do
    dialog _('サーバー設定の追加') do
      error_msg = nil
      while true
        if error_msg
          label error_msg
        end
        input _('サーバーのドメイン'), :domain
        result = await_input
        if result[:domain].empty?
          error_msg = _('ドメイン名を入力してください。')
          next
        end
        if UserConfig[:mastodon_instances].has_key?(result[:domain])
          error_msg = _('既に登録済みのドメインです。入力し直してください。')
          next
        end
        instance = await(Plugin::Mastodon::Instance.add(result[:domain]).trap { nil })
        unless instance
          error_msg = _('接続に失敗しました。もう一度確認してください。')
          next
        end

        break
      end
      domain = result[:domain]
      label _('%{domain} サーバーを追加しました') % { domain: domain }
      Plugin.call(:mastodon_instance_created, domain)
    end
  end

  # 編集
  on_mastodon_instances_open_edit_dialog do |domain|
    dialog _('サーバー設定の編集') {
      label _('サーバーのドメイン： %{domain}') % { domain: domain }
    }.next do |result|
      Plugin.call(:mastodon_update_instance, result.domain)
    end
  end

  # 削除
  on_mastodon_instances_delete_with_confirm do |domain|
    next unless UserConfig[:mastodon_instances][domain]
    dialog _('サーバー設定の削除') {
      label _('サーバー %{domain} を削除しますか？') % { domain: domain }
    }.next do
      Plugin.call(:mastodon_delete_instance, domain)
    end
  end

  # 設定
  settings _('Mastodon') do
    settings _('表示') do
      boolean _('botアカウントにアイコンを表示する'), :mastodon_show_subparts_bot
      boolean _('ピン留めトゥートにアイコンを表示する'), :mastodon_show_subparts_pin
      boolean _('トゥートに公開範囲を表示する'), :mastodon_show_subparts_visibility
    end

    settings _('接続') do
      boolean _('ストリーミング接続する'), :mastodon_enable_streaming
      adjustment _('接続間隔（分）'), :mastodon_rest_interval, 1, 60 * 24
    end

    settings _('公開タイムライン') do
      treeview = Plugin::MastodonSetting::InstanceSettingList.new
      treeview.hexpand = true
      add_tab_observer = on_mastodon_instance_created(&treeview.method(:add_record))
      delete_tab_observer = on_mastodon_delete_instance(&treeview.method(:remove_record))
      treeview.ssc(:destroy) do
        detach add_tab_observer
        detach delete_tab_observer
      end

      btn_add = Gtk::Button.new stock_id: Gtk::Stock::ADD
      btn_delete = Gtk::Button.new stock_id: Gtk::Stock::DELETE
      btn_add.ssc(:clicked) do
        Plugin.call(:mastodon_instances_open_create_dialog)
        true
      end
      btn_delete.ssc(:clicked) do
        domain = treeview.selected_domain
        if domain
          Plugin.call(:mastodon_instances_delete_with_confirm, domain) end
        true
      end

      box = Gtk::ButtonBox.new :vertical
      box.layout_style = :start
      box.spacing = 6
      box << btn_add << btn_delete

      grid = Gtk::Grid.new
      grid.column_spacing = 6
      grid << treeview << box

      attach_next_to grid, nil, :bottom, 2, 1
    end
  end
end
