#ifndef _DO_MYSQL_ERROR_H_
#define _DO_MYSQL_ERROR_H_

#include "do_common.h"

static struct errcodes do_mysql_errors[] = {
#ifdef ER_ABORTING_CONNECTION
  ERRCODE(ER_ABORTING_CONNECTION, "ConnectionError"),
#endif
#ifdef ER_NET_PACKET_TOO_LARGE
  ERRCODE(ER_NET_PACKET_TOO_LARGE, "ConnectionError"),
#endif
#ifdef ER_NET_READ_ERROR_FROM_PIPE
  ERRCODE(ER_NET_READ_ERROR_FROM_PIPE, "ConnectionError"),
#endif
#ifdef ER_NET_FCNTL_ERROR
  ERRCODE(ER_NET_FCNTL_ERROR, "ConnectionError"),
#endif
#ifdef ER_NET_PACKETS_OUT_OF_ORDER
  ERRCODE(ER_NET_PACKETS_OUT_OF_ORDER, "ConnectionError"),
#endif
#ifdef ER_NET_UNCOMPRESS_ERROR
  ERRCODE(ER_NET_UNCOMPRESS_ERROR, "ConnectionError"),
#endif
#ifdef ER_NET_READ_ERROR
  ERRCODE(ER_NET_READ_ERROR, "ConnectionError"),
#endif
#ifdef ER_NET_READ_INTERRUPTED
  ERRCODE(ER_NET_READ_INTERRUPTED, "ConnectionError"),
#endif
#ifdef ER_NET_WRITE_INTERRUPTED
  ERRCODE(ER_NET_WRITE_INTERRUPTED, "ConnectionError"),
#endif
#ifdef ER_CON_COUNT_ERROR
  ERRCODE(ER_CON_COUNT_ERROR, "ConnectionError"),
#endif
#ifdef ER_BAD_HOST_ERROR
  ERRCODE(ER_BAD_HOST_ERROR, "ConnectionError"),
#endif
#ifdef ER_HANDSHAKE_ERROR
  ERRCODE(ER_HANDSHAKE_ERROR, "ConnectionError"),
#endif
#ifdef ER_DBACCESS_DENIED_ERROR
  ERRCODE(ER_DBACCESS_DENIED_ERROR, "ConnectionError"),
#endif
#ifdef ER_ACCESS_DENIED_ERROR
  ERRCODE(ER_ACCESS_DENIED_ERROR, "ConnectionError"),
#endif
#ifdef ER_UNKNOWN_COM_ERROR
  ERRCODE(ER_UNKNOWN_COM_ERROR, "ConnectionError"),
#endif
#ifdef ER_SERVER_SHUTDOWN
  ERRCODE(ER_SERVER_SHUTDOWN, "ConnectionError"),
#endif
#ifdef ER_FORCING_CLOSE
  ERRCODE(ER_FORCING_CLOSE, "ConnectionError"),
#endif
#ifdef ER_IPSOCK_ERROR
  ERRCODE(ER_IPSOCK_ERROR, "ConnectionError"),
#endif

#ifdef ER_INVALID_USE_OF_NULL
  ERRCODE(ER_INVALID_USE_OF_NULL, "DataError"),
#endif
#ifdef ER_DIVISION_BY_ZERO
  ERRCODE(ER_DIVISION_BY_ZERO, "DataError"),
#endif
#ifdef ER_ILLEGAL_VALUE_FOR_TYPE
  ERRCODE(ER_ILLEGAL_VALUE_FOR_TYPE, "DataError"),
#endif
#ifdef ER_WARN_NULL_TO_NOTNULL
  ERRCODE(ER_WARN_NULL_TO_NOTNULL, "DataError"),
#endif
#ifdef ER_WARN_DATA_OUT_OF_RANGE
  ERRCODE(ER_WARN_DATA_OUT_OF_RANGE, "DataError"),
#endif
#ifdef ER_WARN_TOO_MANY_RECORDS
  ERRCODE(ER_WARN_TOO_MANY_RECORDS, "DataError"),
#endif
#ifdef ER_WARN_TOO_FEW_RECORDS
  ERRCODE(ER_WARN_TOO_FEW_RECORDS, "DataError"),
#endif
#ifdef ER_TRUNCATED_WRONG_VALUE
  ERRCODE(ER_TRUNCATED_WRONG_VALUE, "DataError"),
#endif
#ifdef ER_DATETIME_FUNCTION_OVERFLOW
  ERRCODE(ER_DATETIME_FUNCTION_OVERFLOW, "DataError"),
#endif
#ifdef ER_DATA_TOO_LONG
  ERRCODE(ER_DATA_TOO_LONG, "DataError"),
#endif
#ifdef ER_UNKNOWN_TIME_ZONE
  ERRCODE(ER_UNKNOWN_TIME_ZONE, "DataError"),
#endif
#ifdef ER_INVALID_CHARACTER_STRING
  ERRCODE(ER_INVALID_CHARACTER_STRING, "DataError"),
#endif
#ifdef ER_WARN_INVALID_TIMESTAMP
  ERRCODE(ER_WARN_INVALID_TIMESTAMP, "DataError"),
#endif
#ifdef ER_CANT_CREATE_GEOMETRY_OBJECT
  ERRCODE(ER_CANT_CREATE_GEOMETRY_OBJECT, "DataError"),
#endif

#ifdef ER_BAD_NULL_ERROR
  ERRCODE(ER_BAD_NULL_ERROR, "IntegrityError"),
#endif
#ifdef ER_NON_UNIQ_ERROR
  ERRCODE(ER_NON_UNIQ_ERROR, "IntegrityError"),
#endif
#ifdef ER_DUP_KEY
  ERRCODE(ER_DUP_KEY, "IntegrityError"),
#endif
#ifdef ER_DUP_ENTRY
  ERRCODE(ER_DUP_ENTRY, "IntegrityError"),
#endif
#ifdef ER_DUP_UNIQUE
  ERRCODE(ER_DUP_UNIQUE, "IntegrityError"),
#endif
#ifdef ER_NO_REFERENCED_ROW
  ERRCODE(ER_NO_REFERENCED_ROW, "IntegrityError"),
#endif
#ifdef ER_NO_REFERENCED_ROW_2
  ERRCODE(ER_NO_REFERENCED_ROW_2, "IntegrityError"),
#endif
#ifdef ER_ROW_IS_REFERENCED
  ERRCODE(ER_ROW_IS_REFERENCED, "IntegrityError"),
#endif
#ifdef ER_ROW_IS_REFERENCED_2
  ERRCODE(ER_ROW_IS_REFERENCED_2, "IntegrityError"),
#endif

#ifdef ER_BLOB_KEY_WITHOUT_LENGTH
  ERRCODE(ER_BLOB_KEY_WITHOUT_LENGTH, "SyntaxError"),
#endif
#ifdef ER_PRIMARY_CANT_HAVE_NULL
  ERRCODE(ER_PRIMARY_CANT_HAVE_NULL, "SyntaxError"),
#endif
#ifdef ER_TOO_MANY_ROWS
  ERRCODE(ER_TOO_MANY_ROWS, "SyntaxError"),
#endif
#ifdef ER_REQUIRES_PRIMARY_KEY
  ERRCODE(ER_REQUIRES_PRIMARY_KEY, "SyntaxError"),
#endif
#ifdef ER_CHECK_NO_SUCH_TABLE
  ERRCODE(ER_CHECK_NO_SUCH_TABLE, "SyntaxError"),
#endif
#ifdef ER_CHECK_NOT_IMPLEMENTED
  ERRCODE(ER_CHECK_NOT_IMPLEMENTED, "SyntaxError"),
#endif
#ifdef ER_TOO_MANY_USER_CONNECTIONS
  ERRCODE(ER_TOO_MANY_USER_CONNECTIONS, "SyntaxError"),
#endif
#ifdef ER_NO_PERMISSION_TO_CREATE_USER
  ERRCODE(ER_NO_PERMISSION_TO_CREATE_USER, "SyntaxError"),
#endif
#ifdef ER_USER_LIMIT_REACHED
  ERRCODE(ER_USER_LIMIT_REACHED, "SyntaxError"),
#endif
#ifdef ER_SPECIFIC_ACCESS_DENIED_ERROR
  ERRCODE(ER_SPECIFIC_ACCESS_DENIED_ERROR, "SyntaxError"),
#endif
#ifdef ER_NO_DEFAULT
  ERRCODE(ER_NO_DEFAULT, "SyntaxError"),
#endif
#ifdef ER_WRONG_VALUE_FOR_VAR
  ERRCODE(ER_WRONG_VALUE_FOR_VAR, "SyntaxError"),
#endif
#ifdef ER_WRONG_TYPE_FOR_VAR
  ERRCODE(ER_WRONG_TYPE_FOR_VAR, "SyntaxError"),
#endif
#ifdef ER_CANT_USE_OPTION_HERE
  ERRCODE(ER_CANT_USE_OPTION_HERE, "SyntaxError"),
#endif
#ifdef ER_NOT_SUPPORTED_YET
  ERRCODE(ER_NOT_SUPPORTED_YET, "SyntaxError"),
#endif
#ifdef ER_WRONG_FK_DEF
  ERRCODE(ER_WRONG_FK_DEF, "SyntaxError"),
#endif
#ifdef ER_ILLEGAL_REFERENCE
  ERRCODE(ER_ILLEGAL_REFERENCE, "SyntaxError"),
#endif
#ifdef ER_DERIVED_MUST_HAVE_ALIAS
  ERRCODE(ER_DERIVED_MUST_HAVE_ALIAS, "SyntaxError"),
#endif
#ifdef ER_TABLENAME_NOT_ALLOWED_HERE
  ERRCODE(ER_TABLENAME_NOT_ALLOWED_HERE, "SyntaxError"),
#endif
#ifdef ER_SPATIAL_CANT_HAVE_NULL
  ERRCODE(ER_SPATIAL_CANT_HAVE_NULL, "SyntaxError"),
#endif
#ifdef ER_COLLATION_CHARSET_MISMATCH
  ERRCODE(ER_COLLATION_CHARSET_MISMATCH, "SyntaxError"),
#endif
#ifdef ER_WRONG_NAME_FOR_INDEX
  ERRCODE(ER_WRONG_NAME_FOR_INDEX, "SyntaxError"),
#endif
#ifdef ER_WRONG_NAME_FOR_CATALOG
  ERRCODE(ER_WRONG_NAME_FOR_CATALOG, "SyntaxError"),
#endif
#ifdef ER_UNKNOWN_STORAGE_ENGINE
  ERRCODE(ER_UNKNOWN_STORAGE_ENGINE, "SyntaxError"),
#endif
#ifdef ER_SP_ALREADY_EXISTS
  ERRCODE(ER_SP_ALREADY_EXISTS, "SyntaxError"),
#endif
#ifdef ER_SP_DOES_NOT_EXIST
  ERRCODE(ER_SP_DOES_NOT_EXIST, "SyntaxError"),
#endif
#ifdef ER_SP_LILABEL_MISMATCH
  ERRCODE(ER_SP_LILABEL_MISMATCH, "SyntaxError"),
#endif
#ifdef ER_SP_LABEL_REDEFINE
  ERRCODE(ER_SP_LABEL_REDEFINE, "SyntaxError"),
#endif
#ifdef ER_SP_LABEL_MISMATCH
  ERRCODE(ER_SP_LABEL_MISMATCH, "SyntaxError"),
#endif
#ifdef ER_SP_BADRETURN
  ERRCODE(ER_SP_BADRETURN, "SyntaxError"),
#endif
#ifdef ER_SP_WRONG_NO_OF_ARGS
  ERRCODE(ER_SP_WRONG_NO_OF_ARGS, "SyntaxError"),
#endif
#ifdef ER_SP_COND_MISMATCH
  ERRCODE(ER_SP_COND_MISMATCH, "SyntaxError"),
#endif
#ifdef ER_SP_NORETURN
  ERRCODE(ER_SP_NORETURN, "SyntaxError"),
#endif
#ifdef ER_SP_BAD_CURSOR_QUERY
  ERRCODE(ER_SP_BAD_CURSOR_QUERY, "SyntaxError"),
#endif
#ifdef ER_SP_BAD_CURSOR_SELECT
  ERRCODE(ER_SP_BAD_CURSOR_SELECT, "SyntaxError"),
#endif
#ifdef ER_SP_CURSOR_MISMATCH
  ERRCODE(ER_SP_CURSOR_MISMATCH, "SyntaxError"),
#endif
#ifdef ER_SP_UNDECLARED_VAR
  ERRCODE(ER_SP_UNDECLARED_VAR, "SyntaxError"),
#endif
#ifdef ER_SP_DUP_PARAM
  ERRCODE(ER_SP_DUP_PARAM, "SyntaxError"),
#endif
#ifdef ER_SP_DUP_VAR
  ERRCODE(ER_SP_DUP_VAR, "SyntaxError"),
#endif
#ifdef ER_SP_DUP_COND
  ERRCODE(ER_SP_DUP_COND, "SyntaxError"),
#endif
#ifdef ER_SP_DUP_CURS
  ERRCODE(ER_SP_DUP_CURS, "SyntaxError"),
#endif
#ifdef ER_SP_VARCOND_AFTER_CURSHNDLR
  ERRCODE(ER_SP_VARCOND_AFTER_CURSHNDLR, "SyntaxError"),
#endif
#ifdef ER_SP_CURSOR_AFTER_HANDLER
  ERRCODE(ER_SP_CURSOR_AFTER_HANDLER, "SyntaxError"),
#endif
#ifdef ER_SP_CASE_NOT_FOUND
  ERRCODE(ER_SP_CASE_NOT_FOUND, "SyntaxError"),
#endif
#ifdef ER_PROCACCESS_DENIED_ERROR
  ERRCODE(ER_PROCACCESS_DENIED_ERROR, "SyntaxError"),
#endif
#ifdef ER_NONEXISTING_PROC_GRANT
  ERRCODE(ER_NONEXISTING_PROC_GRANT, "SyntaxError"),
#endif
#ifdef ER_SP_BAD_SQLSTATE
  ERRCODE(ER_SP_BAD_SQLSTATE, "SyntaxError"),
#endif
#ifdef ER_CANT_CREATE_USER_WITH_GRANT
  ERRCODE(ER_CANT_CREATE_USER_WITH_GRANT, "SyntaxError"),
#endif
#ifdef ER_SP_DUP_HANDLER
  ERRCODE(ER_SP_DUP_HANDLER, "SyntaxError"),
#endif
#ifdef ER_SP_NOT_VAR_ARG
  ERRCODE(ER_SP_NOT_VAR_ARG, "SyntaxError"),
#endif
#ifdef ER_TOO_BIG_SCALE
  ERRCODE(ER_TOO_BIG_SCALE, "SyntaxError"),
#endif
#ifdef ER_TOO_BIG_PRECISION
  ERRCODE(ER_TOO_BIG_PRECISION, "SyntaxError"),
#endif
#ifdef ER_M_BIGGER_THAN_D
  ERRCODE(ER_M_BIGGER_THAN_D, "SyntaxError"),
#endif
#ifdef ER_TOO_LONG_BODY
  ERRCODE(ER_TOO_LONG_BODY, "SyntaxError"),
#endif
#ifdef ER_TOO_BIG_DISPLAYWIDTH
  ERRCODE(ER_TOO_BIG_DISPLAYWIDTH, "SyntaxError"),
#endif
#ifdef ER_SP_BAD_VAR_SHADOW
  ERRCODE(ER_SP_BAD_VAR_SHADOW, "SyntaxError"),
#endif
#ifdef ER_SP_WRONG_NAME
  ERRCODE(ER_SP_WRONG_NAME, "SyntaxError"),
#endif
#ifdef ER_SP_NO_AGGREGATE
  ERRCODE(ER_SP_NO_AGGREGATE, "SyntaxError"),
#endif
#ifdef ER_MAX_PREPARED_STMT_COUNT_REACHED
  ERRCODE(ER_MAX_PREPARED_STMT_COUNT_REACHED, "SyntaxError"),
#endif
#ifdef ER_NON_GROUPING_FIELD_USED
  ERRCODE(ER_NON_GROUPING_FIELD_USED, "SyntaxError"),
#endif
#ifdef ER_BAD_DB_ERROR
  ERRCODE(ER_BAD_DB_ERROR, "SyntaxError"),
#endif
#ifdef ER_TABLE_EXISTS_ERROR
  ERRCODE(ER_TABLE_EXISTS_ERROR, "SyntaxError"),
#endif
#ifdef ER_BAD_TABLE_ERROR
  ERRCODE(ER_BAD_TABLE_ERROR, "SyntaxError"),
#endif
#ifdef ER_NO_SUCH_TABLE
  ERRCODE(ER_NO_SUCH_TABLE, "SyntaxError"),
#endif
#ifdef ER_NONEXISTING_TABLE_GRANT
  ERRCODE(ER_NONEXISTING_TABLE_GRANT, "SyntaxError"),
#endif
#ifdef ER_GRANT_WRONG_HOST_OR_USER
  ERRCODE(ER_GRANT_WRONG_HOST_OR_USER, "SyntaxError"),
#endif
#ifdef ER_ILLEGAL_GRANT_FOR_TABLE
  ERRCODE(ER_ILLEGAL_GRANT_FOR_TABLE, "SyntaxError"),
#endif
#ifdef ER_COLUMNACCESS_DENIED_ERROR
  ERRCODE(ER_COLUMNACCESS_DENIED_ERROR, "SyntaxError"),
#endif
#ifdef ER_TABLEACCESS_DENIED_ERROR
  ERRCODE(ER_TABLEACCESS_DENIED_ERROR, "SyntaxError"),
#endif
#ifdef ER_NONEXISTING_GRANT
  ERRCODE(ER_NONEXISTING_GRANT, "SyntaxError"),
#endif
#ifdef ER_MIX_OF_GROUP_FUNC_AND_FIELDS
  ERRCODE(ER_MIX_OF_GROUP_FUNC_AND_FIELDS, "SyntaxError"),
#endif
#ifdef ER_REGEXP_ERROR
  ERRCODE(ER_REGEXP_ERROR, "SyntaxError"),
#endif
#ifdef ER_NOT_ALLOWED_COMMAND
  ERRCODE(ER_NOT_ALLOWED_COMMAND, "SyntaxError"),
#endif
#ifdef ER_SYNTAX_ERROR
  ERRCODE(ER_SYNTAX_ERROR, "SyntaxError"),
#endif
#ifdef ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT
  ERRCODE(ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT, "SyntaxError"),
#endif

#ifdef ER_CANT_DO_THIS_DURING_AN_TRANSACTION
  ERRCODE(ER_CANT_DO_THIS_DURING_AN_TRANSACTION, "TransactionError"),
#endif
#ifdef ER_ERROR_DURING_COMMIT
  ERRCODE(ER_ERROR_DURING_COMMIT, "TransactionError"),
#endif
#ifdef ER_ERROR_DURING_ROLLBACK
  ERRCODE(ER_ERROR_DURING_ROLLBACK, "TransactionError"),
#endif
#ifdef ER_ERROR_DURING_CHECKPOINT
  ERRCODE(ER_ERROR_DURING_CHECKPOINT, "TransactionError"),
#endif
#ifdef ER_LOCK_DEADLOCK
  ERRCODE(ER_LOCK_DEADLOCK, "TransactionError"),
#endif
#ifdef ER_XAER_NOTA
  ERRCODE(ER_XAER_NOTA,
       "TransactionError"),
#endif
#ifdef ER_XAER_INVAL
  ERRCODE(ER_XAER_INVAL,
       "TransactionError"),
#endif
#ifdef ER_XAER_RMFAIL
  ERRCODE(ER_XAER_RMFAIL, "TransactionError"),
#endif
#ifdef ER_XAER_OUTSIDE
  ERRCODE(ER_XAER_OUTSIDE, "TransactionError"),
#endif
#ifdef ER_XAER_RMERR
  ERRCODE(ER_XAER_RMERR, "TransactionError"),
#endif
#ifdef ER_XA_RBROLLBACK
  ERRCODE(ER_XA_RBROLLBACK, "TransactionError"),
#endif
#ifdef ER_XA_RBTIMEOUT
  ERRCODE(ER_XA_RBTIMEOUT, "TransactionError"),
#endif
#ifdef ER_XA_RBDEADLOCK
  ERRCODE(ER_XA_RBDEADLOCK, "TransactionError"),
#endif
  {0, NULL, NULL}
};

#endif
