/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatDHT {
    public static void checkAccuracyDHT_1D(int n, int n2) {
        System.out.println("Checking accuracy of 1D DHT...");
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = (int)Math.pow(2.0, n3);
            FloatDHT_1D floatDHT_1D = new FloatDHT_1D(n4);
            float f = 0.0f;
            float[] fArray = new float[n4];
            IOUtils.fillMatrix_1D(n4, fArray);
            float[] fArray2 = new float[n4];
            IOUtils.fillMatrix_1D(n4, fArray2);
            floatDHT_1D.forward(fArray);
            floatDHT_1D.inverse(fArray, true);
            for (int j = 0; j < n4; ++j) {
                float f2 = Math.abs(fArray2[j] - fArray[j]);
                f = Math.max(f, f2);
            }
            if ((double)f > 1.0E-5) {
                System.err.println("\tsize = 2^" + n3 + ";\terror = " + f);
            } else {
                System.out.println("\tsize = 2^" + n3 + ";\terror = " + f);
            }
            fArray = null;
            fArray2 = null;
            floatDHT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_2D(int n, int n2) {
        float f;
        int n3;
        Object object;
        Object object2;
        float f2;
        FloatDHT_2D floatDHT_2D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 2D DHT (float[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatDHT_2D = new FloatDHT_2D(n4, n4);
            f2 = 0.0f;
            object2 = new float[n4 * n4];
            IOUtils.fillMatrix_2D(n4, n4, object2);
            object = new float[n4 * n4];
            IOUtils.fillMatrix_2D(n4, n4, object);
            floatDHT_2D.forward((float[])object2);
            floatDHT_2D.inverse((float[])object2, true);
            for (n3 = 0; n3 < n4 * n4; ++n3) {
                f = Math.abs(object[n3] - object2[n3]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatDHT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DHT (float[][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatDHT_2D = new FloatDHT_2D(n4, n4);
            f2 = 0.0f;
            object2 = new float[n4][2 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, (float[][])object2);
            object = new float[n4][2 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, (float[][])object);
            floatDHT_2D.forward((float[][])object2);
            floatDHT_2D.inverse((float[][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < 2 * n4; ++i) {
                    f = Math.abs((float)(object[n3][i] - object2[n3][i]));
                    f2 = Math.max(f2, f);
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatDHT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_3D(int n, int n2) {
        float f;
        int n3;
        Object object;
        Object object2;
        float f2;
        FloatDHT_3D floatDHT_3D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 3D DHT (float[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatDHT_3D = new FloatDHT_3D(n4, n4, n4);
            f2 = 0.0f;
            object2 = new float[n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, object2);
            object = new float[n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, object);
            floatDHT_3D.forward((float[])object2);
            floatDHT_3D.inverse((float[])object2, true);
            for (n3 = 0; n3 < n4 * n4 * n4; ++n3) {
                f = Math.abs(object[n3] - object2[n3]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatDHT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DHT (float[][][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatDHT_3D = new FloatDHT_3D(n4, n4, n4);
            f2 = 0.0f;
            object2 = new float[n4][n4][n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, (float[][][])object2);
            object = new float[n4][n4][n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, (float[][][])object);
            floatDHT_3D.forward((float[][][])object2);
            floatDHT_3D.inverse((float[][][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        f = Math.abs((float)(object[n3][i][j] - object2[n3][i][j]));
                        f2 = Math.max(f2, f);
                    }
                }
            }
            if ((double)f2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatDHT_3D = null;
            System.gc();
        }
    }

    public static void main(String[] stringArray) {
        AccuracyCheckFloatDHT.checkAccuracyDHT_1D(0, 21);
        AccuracyCheckFloatDHT.checkAccuracyDHT_2D(1, 11);
        AccuracyCheckFloatDHT.checkAccuracyDHT_3D(1, 7);
        System.exit(0);
    }
}

