/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.PlayerThread;
import net.bluecow.spectro.UndoManager;
import net.bluecow.spectro.Version;
import net.bluecow.spectro.action.PlayPauseAction;
import net.bluecow.spectro.action.RewindAction;
import net.bluecow.spectro.action.SaveAction;
import net.bluecow.spectro.action.UndoRedoAction;
import net.bluecow.spectro.tool.ToolboxPanel;

public class SpectroEditSession {
    private static final Logger logger = Logger.getLogger(SpectroEditSession.class.getName());
    private static final Preferences prefs = Preferences.userNodeForPackage(SpectroEditSession.class);
    private final UndoManager undoManager = new UndoManager();
    private final PlayerThread playerThread;
    private final ClipPanel clipPanel;

    protected SpectroEditSession(Clip c) throws LineUnavailableException {
        this.playerThread = new PlayerThread(c);
        this.playerThread.start();
        this.clipPanel = ClipPanel.newInstance(c, this.playerThread);
        this.clipPanel.addUndoableEditListener(this.undoManager);
        final JFrame f = new JFrame("Spectro-Edit " + Version.VERSION);
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setTopComponent(new ToolboxPanel(this).getPanel());
        splitPane.setBottomComponent(new JScrollPane(this.clipPanel));
        f.add((Component)splitPane, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.add(new SaveAction(c, f));
        toolbar.add(UndoRedoAction.createUndoInstance(this.undoManager));
        toolbar.add(UndoRedoAction.createRedoInstance(this.undoManager));
        toolbar.addSeparator();
        toolbar.add(new PlayPauseAction(this.playerThread));
        toolbar.add(new RewindAction(this.playerThread));
        f.add((Component)toolbar, "North");
        if (prefs.get("frameBounds", null) != null) {
            String[] frameBounds = prefs.get("frameBounds", null).split(",");
            if (frameBounds.length == 4) {
                f.setBounds(Integer.parseInt(frameBounds[0]), Integer.parseInt(frameBounds[1]), Integer.parseInt(frameBounds[2]), Integer.parseInt(frameBounds[3]));
            }
        } else {
            f.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            f.setSize(Math.min(screenSize.width - 50, f.getWidth()), Math.min(screenSize.height - 50, f.getHeight()));
            f.setLocationRelativeTo(null);
        }
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    prefs.put("frameBounds", String.format("%d,%d,%d,%d", f.getX(), f.getY(), f.getWidth(), f.getHeight()));
                    prefs.flush();
                }
                catch (BackingStoreException ex) {
                    logger.log(Level.WARNING, "Failed to flush preferences", ex);
                }
            }
        });
        f.setVisible(true);
    }

    public static SpectroEditSession createSession(File wavFile) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        Clip c = new Clip(wavFile);
        SpectroEditSession session = new SpectroEditSession(c);
        c.addUndoableEditListener(session.undoManager);
        return session;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Spectro-Edit");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        LogManager.getLogManager().readConfiguration(SpectroEditSession.class.getResourceAsStream("LogManager.properties"));
        final JFrame f = new JFrame("Dummy frame for owning dialogs");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    FileDialog fd = new FileDialog((Frame)f, "Choose a 16-bit WAV or AIFF file");
                    fd.setVisible(true);
                    String dir = fd.getDirectory();
                    String file = fd.getFile();
                    if (dir == null || file == null) {
                        JOptionPane.showMessageDialog(f, "Ok, maybe next time");
                        System.exit(0);
                    }
                    File wavFile = new File(dir, file);
                    SpectroEditSession.createSession(wavFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(f, "Sorry, couldn't read your sample:\n" + e.getMessage() + "\nBe sure your file is 16-bit WAV or AIFF!");
                    System.exit(0);
                }
            }
        });
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    public ClipPanel getClipPanel() {
        return this.clipPanel;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }
}

