/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.util;

import com.ibm.bsf.util.ObjInfo;
import com.ibm.bsf.util.ScriptSymbolTable;
import com.ibm.bsf.util.StringUtils;
import com.ibm.bsf.util.cf.CodeFormatter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class CodeBuffer {
    private StringWriter fieldDeclSW = new StringWriter();
    private StringWriter methodDeclSW = new StringWriter();
    private StringWriter initializerSW = new StringWriter();
    private StringWriter constructorSW = new StringWriter();
    private StringWriter serviceMethodSW = new StringWriter();
    private PrintWriter fieldDeclPW = new PrintWriter(this.fieldDeclSW);
    private PrintWriter methodDeclPW = new PrintWriter(this.methodDeclSW);
    private PrintWriter initializerPW = new PrintWriter(this.initializerSW);
    private PrintWriter constructorPW = new PrintWriter(this.constructorSW);
    private PrintWriter serviceMethodPW = new PrintWriter(this.serviceMethodSW);
    private Stack symbolTableStack = new Stack();
    private Hashtable symbolTable = new Hashtable();
    private Hashtable usedSymbolIndices = new Hashtable();
    private ObjInfo finalStatementInfo;
    private CodeBuffer parent;
    private Vector imports;
    private Vector constructorArguments;
    private Vector constructorExceptions;
    private Vector serviceMethodExceptions;
    private Vector implementsVector;
    private String packageName;
    private String className;
    private String serviceMethodName;
    private String extendsName;
    private Class serviceMethodReturnType;

    public CodeBuffer() {
        this.symbolTableStack.push(this.symbolTable);
        this.imports = new Vector();
        this.constructorArguments = new Vector();
        this.constructorExceptions = new Vector();
        this.serviceMethodExceptions = new Vector();
        this.implementsVector = new Vector();
        this.packageName = null;
        this.className = "Test";
        this.serviceMethodName = "exec";
        this.extendsName = null;
        this.serviceMethodReturnType = Void.TYPE;
    }

    public CodeBuffer(CodeBuffer codeBuffer) {
        this.symbolTableStack.push(this.symbolTable);
        this.imports = new Vector();
        this.constructorArguments = new Vector();
        this.constructorExceptions = new Vector();
        this.serviceMethodExceptions = new Vector();
        this.implementsVector = new Vector();
        this.packageName = null;
        this.className = "Test";
        this.serviceMethodName = "exec";
        this.extendsName = null;
        this.serviceMethodReturnType = Void.TYPE;
        this.parent = codeBuffer;
    }

    public void addConstructorArgument(ObjInfo objInfo) {
        this.constructorArguments.addElement(objInfo);
    }

    public void addConstructorException(String string) {
        if (!this.constructorExceptions.contains(string)) {
            this.constructorExceptions.addElement(string);
        }
    }

    public void addConstructorStatement(String string) {
        this.constructorPW.println(string);
    }

    public void addFieldDeclaration(String string) {
        this.fieldDeclPW.println(string);
    }

    public void addImplements(String string) {
        if (!this.implementsVector.contains(string)) {
            this.implementsVector.addElement(string);
        }
    }

    public void addImport(String string) {
        if (!this.imports.contains(string)) {
            this.imports.addElement(string);
        }
    }

    public void addInitializerStatement(String string) {
        this.initializerPW.println(string);
    }

    public void addMethodDeclaration(String string) {
        this.methodDeclPW.println(string);
    }

    public void addServiceMethodException(String string) {
        if (!this.serviceMethodExceptions.contains(string)) {
            this.serviceMethodExceptions.addElement(string);
        }
    }

    public void addServiceMethodStatement(String string) {
        this.serviceMethodPW.println(string);
    }

    private void appendIfNecessary(PrintWriter printWriter, StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            printWriter.print(stringBuffer.toString());
        }
    }

    public String buildNewSymbol(String string) {
        Integer n = this.getSymbolIndex(string);
        if (n == null) {
            n = new Integer(0);
        }
        int n2 = n;
        String string2 = String.valueOf(string) + "_" + n2;
        while (this.getSymbol(string2) != null) {
            string2 = String.valueOf(string) + "_" + ++n2;
        }
        this.putSymbolIndex(string, new Integer(n2 + 1));
        return string2;
    }

    public void clearSymbolTable() {
        this.symbolTable = new Hashtable();
        this.symbolTableStack = new Stack();
        this.symbolTableStack.push(this.symbolTable);
        this.usedSymbolIndices = new Hashtable();
    }

    public String getClassName() {
        return this.className;
    }

    public Vector getConstructorArguments() {
        return this.constructorArguments;
    }

    public StringBuffer getConstructorBuffer() {
        this.constructorPW.flush();
        return this.constructorSW.getBuffer();
    }

    public Vector getConstructorExceptions() {
        return this.constructorExceptions;
    }

    public String getExtends() {
        return this.extendsName;
    }

    public StringBuffer getFieldBuffer() {
        this.fieldDeclPW.flush();
        return this.fieldDeclSW.getBuffer();
    }

    public ObjInfo getFinalServiceMethodStatement() {
        return this.finalStatementInfo;
    }

    public Vector getImplements() {
        return this.implementsVector;
    }

    public Vector getImports() {
        return this.imports;
    }

    public StringBuffer getInitializerBuffer() {
        this.initializerPW.flush();
        return this.initializerSW.getBuffer();
    }

    public StringBuffer getMethodBuffer() {
        this.methodDeclPW.flush();
        return this.methodDeclSW.getBuffer();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public StringBuffer getServiceMethodBuffer() {
        this.serviceMethodPW.flush();
        return this.serviceMethodSW.getBuffer();
    }

    public Vector getServiceMethodExceptions() {
        return this.serviceMethodExceptions;
    }

    public String getServiceMethodName() {
        return this.serviceMethodName;
    }

    public Class getServiceMethodReturnType() {
        if (this.finalStatementInfo != null) {
            return this.finalStatementInfo.objClass;
        }
        if (this.serviceMethodReturnType != null) {
            return this.serviceMethodReturnType;
        }
        return Void.TYPE;
    }

    public ObjInfo getSymbol(String string) {
        ObjInfo objInfo = (ObjInfo)this.symbolTable.get(string);
        if (objInfo == null && this.parent != null) {
            objInfo = this.parent.getSymbol(string);
        }
        return objInfo;
    }

    Integer getSymbolIndex(String string) {
        if (this.parent != null) {
            return this.parent.getSymbolIndex(string);
        }
        return (Integer)this.usedSymbolIndices.get(string);
    }

    public Hashtable getSymbolTable() {
        return this.symbolTable;
    }

    public void merge(CodeBuffer codeBuffer) {
        Vector vector = codeBuffer.getImports();
        int n = 0;
        while (n < vector.size()) {
            this.addImport((String)vector.elementAt(n));
            ++n;
        }
        this.appendIfNecessary(this.fieldDeclPW, codeBuffer.getFieldBuffer());
        this.appendIfNecessary(this.methodDeclPW, codeBuffer.getMethodBuffer());
        this.appendIfNecessary(this.initializerPW, codeBuffer.getInitializerBuffer());
        this.appendIfNecessary(this.constructorPW, codeBuffer.getConstructorBuffer());
        this.appendIfNecessary(this.serviceMethodPW, codeBuffer.getServiceMethodBuffer());
        ObjInfo objInfo = this.getFinalServiceMethodStatement();
        if (objInfo != null && objInfo.isExecutable()) {
            this.addServiceMethodStatement(String.valueOf(objInfo.objName) + ";");
        }
        this.setFinalServiceMethodStatement(codeBuffer.getFinalServiceMethodStatement());
    }

    public void popSymbolTable() {
        this.symbolTableStack.pop();
        this.symbolTable = (Hashtable)this.symbolTableStack.peek();
    }

    public void print(PrintWriter printWriter, boolean bl) {
        if (bl) {
            new CodeFormatter().formatCode(new StringReader(this.toString()), printWriter);
        } else {
            printWriter.print(this.toString());
        }
        printWriter.flush();
    }

    public void pushSymbolTable() {
        this.symbolTable = this.symbolTableStack.push(new ScriptSymbolTable(this.symbolTable));
    }

    public void putSymbol(String string, ObjInfo objInfo) {
        this.symbolTable.put(string, objInfo);
    }

    void putSymbolIndex(String string, Integer n) {
        if (this.parent != null) {
            this.parent.putSymbolIndex(string, n);
        } else {
            this.usedSymbolIndices.put(string, n);
        }
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setExtends(String string) {
        this.extendsName = string;
    }

    public void setFinalServiceMethodStatement(ObjInfo objInfo) {
        this.finalStatementInfo = objInfo;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setServiceMethodName(String string) {
        this.serviceMethodName = string;
    }

    public void setServiceMethodReturnType(Class clazz) {
        this.serviceMethodReturnType = clazz;
    }

    public void setSymbolTable(Hashtable hashtable) {
        this.symbolTable = hashtable;
    }

    public boolean symbolTableIsStacked() {
        return this.symbolTable instanceof ScriptSymbolTable;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ObjInfo objInfo = this.finalStatementInfo;
        if (this.packageName != null && !this.packageName.equals("")) {
            printWriter.println("package " + this.packageName + ";");
            printWriter.println();
        }
        if (this.imports.size() > 0) {
            int n = 0;
            while (n < this.imports.size()) {
                printWriter.println("import " + this.imports.elementAt(n) + ";");
                ++n;
            }
            printWriter.println();
        }
        printWriter.println("public class " + this.className + (this.extendsName != null && !this.extendsName.equals("") ? " extends " + this.extendsName : "") + (this.implementsVector.size() > 0 ? " implements " + StringUtils.getCommaListFromVector(this.implementsVector) : ""));
        printWriter.println("{");
        printWriter.print(this.getFieldBuffer().toString());
        StringBuffer stringBuffer = this.getInitializerBuffer();
        if (stringBuffer.length() > 0) {
            printWriter.println();
            printWriter.println("{");
            printWriter.print(stringBuffer.toString());
            printWriter.println("}");
        }
        if ((stringBuffer = this.getConstructorBuffer()).length() > 0) {
            printWriter.println();
            printWriter.println("public " + this.className + "(" + (this.constructorArguments.size() > 0 ? StringUtils.getCommaListFromVector(this.constructorArguments) : "") + ")" + (this.constructorExceptions.size() > 0 ? " throws " + StringUtils.getCommaListFromVector(this.constructorExceptions) : ""));
            printWriter.println("{");
            printWriter.print(stringBuffer.toString());
            printWriter.println("}");
        }
        if ((stringBuffer = this.getServiceMethodBuffer()).length() > 0 || objInfo != null) {
            printWriter.println();
            printWriter.println("public " + StringUtils.getClassName(this.getServiceMethodReturnType()) + " " + this.serviceMethodName + "()" + (this.serviceMethodExceptions.size() > 0 ? " throws " + StringUtils.getCommaListFromVector(this.serviceMethodExceptions) : ""));
            printWriter.println("{");
            printWriter.print(stringBuffer.toString());
            if (objInfo != null) {
                if (objInfo.isValueReturning()) {
                    printWriter.println();
                    printWriter.println("return " + objInfo.objName + ";");
                } else if (objInfo.isExecutable()) {
                    printWriter.println(String.valueOf(objInfo.objName) + ";");
                }
            }
            printWriter.println("}");
        }
        printWriter.print(this.getMethodBuffer().toString());
        printWriter.println("}");
        printWriter.flush();
        return stringWriter.toString();
    }
}

