/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorLookUpTable;
import gnu.java.awt.color.ColorSpaceConverter;
import gnu.java.awt.color.GrayScaleConverter;
import gnu.java.awt.color.ToneReproductionCurve;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ProfileDataException;

public class GrayProfileConverter
implements ColorSpaceConverter {
    private GrayScaleConverter gc;
    private ToneReproductionCurve trc;
    private ColorLookUpTable toPCS;
    private ColorLookUpTable fromPCS;

    public float[] toCIEXYZ(float[] fArray) {
        if (this.toPCS != null) {
            return this.toPCS.lookup(fArray);
        }
        float[] fArray2 = new float[]{this.trc.lookup(fArray[0])};
        return this.gc.toCIEXYZ(fArray2);
    }

    public float[] toRGB(float[] fArray) {
        float[] fArray2 = new float[]{this.trc.lookup(fArray[0])};
        return this.gc.toRGB(fArray2);
    }

    public float[] fromRGB(float[] fArray) {
        float[] fArray2 = this.gc.fromRGB(fArray);
        fArray2[0] = this.trc.reverseLookup(fArray2[0]);
        return fArray2;
    }

    public float[] fromCIEXYZ(float[] fArray) {
        if (this.fromPCS != null) {
            return this.fromPCS.lookup(fArray);
        }
        float[] fArray2 = this.gc.fromCIEXYZ(fArray);
        fArray2[0] = this.trc.reverseLookup(fArray2[0]);
        return fArray2;
    }

    public GrayProfileConverter(ICC_ProfileGray iCC_ProfileGray) {
        try {
            this.trc = new ToneReproductionCurve(iCC_ProfileGray.getGamma());
        }
        catch (ProfileDataException profileDataException) {
            this.trc = new ToneReproductionCurve(iCC_ProfileGray.getTRC());
        }
        this.gc = new GrayScaleConverter();
        try {
            this.toPCS = new ColorLookUpTable(iCC_ProfileGray, 1093812784);
        }
        catch (Exception exception) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = new ColorLookUpTable(iCC_ProfileGray, 1110589744);
        }
        catch (Exception exception) {
            this.fromPCS = null;
        }
    }
}

