require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_CPU_H_)) {
    eval 'sub _POWERPC_CPU_H_ () {1;}' unless defined(&_POWERPC_CPU_H_);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	if(defined(&_KERNEL_OPT)) {
	    require './powerpc/opt_gprof.ph';
	    require './powerpc/opt_modular.ph';
	    require './powerpc/opt_multiprocessor.ph';
	    require './powerpc/opt_ppcarch.ph';
	    require './powerpc/opt_ppcopts.ph';
	}
	if(defined(&_KERNEL)) {
	    require 'sys/intr.ph';
	    require 'sys/device_if.ph';
	    require 'sys/evcnt.ph';
	    require 'sys/param.ph';
	    require 'sys/kernel.ph';
	}
	require 'sys/cpu_data.ph';
	if(defined(&_KERNEL)) {
	    eval 'sub CI_SAVETEMP () {(0* &CPUSAVE_LEN);}' unless defined(&CI_SAVETEMP);
	    eval 'sub CI_SAVEDDB () {(1* &CPUSAVE_LEN);}' unless defined(&CI_SAVEDDB);
	    eval 'sub CI_SAVEIPKDB () {(2* &CPUSAVE_LEN);}' unless defined(&CI_SAVEIPKDB);
	    eval 'sub CI_SAVEMMU () {(3* &CPUSAVE_LEN);}' unless defined(&CI_SAVEMMU);
	    eval 'sub CI_SAVEMAX () {(4* &CPUSAVE_LEN);}' unless defined(&CI_SAVEMAX);
	    eval 'sub CPUSAVE_LEN () {8;}' unless defined(&CPUSAVE_LEN);
	    if(defined(&PPC_BOOKE)  && !defined(&MODULAR)  && !defined(&_MODULE)) {
		eval 'sub CPUSAVE_SIZE () {128;}' unless defined(&CPUSAVE_SIZE);
	    } else {
		eval 'sub CPUSAVE_SIZE () {( &CI_SAVEMAX* &CPUSAVE_LEN);}' unless defined(&CPUSAVE_SIZE);
	    }
	    eval 'sub CPUSAVE_R28 () {0;}' unless defined(&CPUSAVE_R28);
	    eval 'sub CPUSAVE_R29 () {1;}' unless defined(&CPUSAVE_R29);
	    eval 'sub CPUSAVE_R30 () {2;}' unless defined(&CPUSAVE_R30);
	    eval 'sub CPUSAVE_R31 () {3;}' unless defined(&CPUSAVE_R31);
	    eval 'sub CPUSAVE_DEAR () {4;}' unless defined(&CPUSAVE_DEAR);
	    eval 'sub CPUSAVE_DAR () {4;}' unless defined(&CPUSAVE_DAR);
	    eval 'sub CPUSAVE_ESR () {5;}' unless defined(&CPUSAVE_ESR);
	    eval 'sub CPUSAVE_DSISR () {5;}' unless defined(&CPUSAVE_DSISR);
	    eval 'sub CPUSAVE_SRR0 () {6;}' unless defined(&CPUSAVE_SRR0);
	    eval 'sub CPUSAVE_SRR1 () {7;}' unless defined(&CPUSAVE_SRR1);
	}
	if(defined(&_KERNEL)) {
	    if(defined(&PPC_OEA) || defined(&PPC_OEA601) || defined(&PPC_OEA64) || defined(&PPC_OEA64_BRIDGE) || defined(&MODULAR) || defined(&_MODULE)) {
	    }
	    if(!defined(&PPC_BOOKE)  && !defined(&_MODULE)) {
		eval 'sub ci_ipending () { ($ci_un1->{un1_ipending});}' unless defined(&ci_ipending);
	    }
	    if(defined(&PPC_IBM4XX) || ((defined(&MODULAR) || defined(&_MODULE))  && !defined(&_LP64))) {
	    }
	    if(defined(&PPC_BOOKE) || ((defined(&MODULAR) || defined(&_MODULE))  && !defined(&_LP64))) {
		eval 'sub ci_pmap_kern_segtab () { $ci_pmap_segtabs[0];}' unless defined(&ci_pmap_kern_segtab);
		eval 'sub ci_pmap_user_segtab () { $ci_pmap_segtabs[1];}' unless defined(&ci_pmap_user_segtab);
	    }
	    if(defined(&GPROF)  && defined(&MULTIPROCESSOR)) {
	    }
	}
    }
    if(defined(&_KERNEL)) {
	if(defined(&MULTIPROCESSOR)  && !defined(&_MODULE)) {
	    if(defined(&PPC_OEA64_BRIDGE) || defined (&_ARCH_PPC64)) {
	    } else {
	    }
	    if(defined(&PPC_OEA) || defined(&PPC_OEA64_BRIDGE)) {
	    }
	    if(defined(&PPC_BOOKE)) {
	    }
	}
	if(defined(&MULTIPROCESSOR) || defined(&_MODULE)) {
	    eval 'sub cpu_number () {
	        eval q(( &curcpu()-> &ci_index + 0));
	    }' unless defined(&cpu_number);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_cpuid == 0));
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q($cii = 0, $ci =  $cpu_info[0]; $cii < ( &ncpu ?  &ncpu : 1); $cii++, $ci++);
	    }' unless defined(&CPU_INFO_FOREACH);
	} else {
	    eval 'sub cpu_number () {
	        eval q(0);
	    }' unless defined(&cpu_number);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q( &true);
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q(( &void)$cii, $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL);
	    }' unless defined(&CPU_INFO_FOREACH);
	}
	eval 'sub curcpu {
	    my($void) = @_;
    	    eval q({ \'struct cpu_info\' * &ci;  &__asm  &volatile (\\"mfsprg0 %0\\" : \\"=r\\"( &ci));  &ci; });
	}' unless defined(&curcpu);
	eval 'sub curlwp () { &powerpc_curlwp;}' unless defined(&curlwp);
	eval 'sub curpcb () {( &curcpu()-> &ci_curpcb);}' unless defined(&curpcb);
	eval 'sub curpm () {( &curcpu()-> &ci_curpm);}' unless defined(&curpm);
	eval 'sub mfmsr {
	    my($void) = @_;
    	    eval q({  &register_t  &msr;  &__asm  &volatile (\\"mfmsr %0\\" : \\"=r\\"( &msr));  &msr; });
	}' unless defined(&mfmsr);
	eval 'sub mtmsr {
	    my($msr) = @_;
    	    eval q({  &__asm  &volatile (\\"mtmsr %0\\" : : \\"r\\"($msr)); });
	}' unless defined(&mtmsr);
	if(!defined(&_MODULE)) {
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mftbl {
	        my($void) = @_;
    		eval q({  &uint32_t  &tbl;  &__asm  &volatile ( : [ &tbl] \\"=r\\" ( &tbl));  &tbl; });
	    }' unless defined(&mftbl);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mftb {
	        my($void) = @_;
    		eval q({  &uint64_t  &tb; \\"	cmplw %[tb],%[tmp]\\" \\"\\\\n\\" \\"	bne- 1b\\" \\"\\\\n\\" : [ &tb] \\"=r\\" ( &tb), [ &tmp] \\"=r\\"( &tmp) :: \\"cr0\\");  &endif  &tb; });
	    }' unless defined(&mftb);
	    eval 'sub mfrtcl {
	        my($void) = @_;
    		eval q({  &uint32_t  &rtcl;  &__asm  &volatile (\\"mfrtcl %0\\" : \\"=r\\"( &rtcl));  &rtcl; });
	    }' unless defined(&mfrtcl);
	    eval 'sub mfrtc {
	        my($rtcp) = @_;
    		eval q({  &uint32_t  &tmp;  &__asm  &volatile ( \\"1:	mfrtcu	%[rtcu]\\" \\"\\\\n\\" \\"	mfrtcl	%[rtcl]\\" \\"\\\\n\\" \\"	mfrtcu	%[tmp]\\" \\"\\\\n\\" \\"	cmplw	%[rtcu],%[tmp]\\" \\"\\\\n\\" \\"	bne-	1b\\" : [ &rtcu] \\"=r\\"($rtcp->[0]), [ &rtcl] \\"=r\\"($rtcp->[1]), [ &tmp] \\"=r\\"( &tmp) :: \\"cr0\\"); });
	    }' unless defined(&mfrtc);
	    eval 'sub rtc_nanosecs {
	        my($void) = @_;
    		eval q({  &uint64_t  &cycles;  &uint32_t  $tmp[2];  &mfrtc( &tmp);  &cycles =  $tmp[0] * 1000000000;  &cycles += ( $tmp[1] >> 7);  &cycles; });
	    }' unless defined(&rtc_nanosecs);
	}
	eval 'sub mfpvr {
	    my($void) = @_;
    	    eval q({  &uint32_t  &pvr;  &__asm  &volatile (\\"mfpvr %0\\" : \\"=r\\"( &pvr)); ( &pvr); });
	}' unless defined(&mfpvr);
	if(defined(&_MODULE)) {
	    eval 'sub CPU_MAXNUM () {((( &uintptr_t)& &__CPU_MAXNUM)&0xffff);}' unless defined(&CPU_MAXNUM);
	}
	if(!defined(&_MODULE)) {
	    if(defined(&MULTIPROCESSOR)) {
	    }
	}
	eval 'sub cpu_proc_fork {
	    my($p1, $p2) = @_;
    	    eval q();
	}' unless defined(&cpu_proc_fork);
	unless(defined(&__HIDE_DELAY)) {
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	}
	eval 'sub CLKF_USERMODE {
	    my($cf) = @_;
    	    eval q( &cpu_clkf_usermode($cf));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($cf) = @_;
    	    eval q( &cpu_clkf_pc($cf));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($cf) = @_;
    	    eval q( &cpu_clkf_intr($cf));
	}' unless defined(&CLKF_INTR);
	eval 'sub LWP_PC {
	    my($l) = @_;
    	    eval q( &cpu_lwp_pc($l));
	}' unless defined(&LWP_PC);
	if(!defined(&PPC_IBM4XX)  && !defined(&PPC_BOOKE)  && !defined(&_MODULE)) {
	}
	if(defined(&PPC_NO_UNALIGNED)) {
	}
    }
    if(!defined(&CACHELINESIZE)  && !defined(&_MODULE)  && (defined(&_KERNEL) || defined(&_STANDALONE))) {
	if(defined(&PPC_IBM403)) {
	    eval 'sub CACHELINESIZE () {16;}' unless defined(&CACHELINESIZE);
	    eval 'sub MAXCACHELINESIZE () {16;}' unless defined(&MAXCACHELINESIZE);
	}
 elsif(defined (&PPC_OEA64_BRIDGE)) {
	    eval 'sub CACHELINESIZE () {128;}' unless defined(&CACHELINESIZE);
	    eval 'sub MAXCACHELINESIZE () {128;}' unless defined(&MAXCACHELINESIZE);
	} else {
	    eval 'sub CACHELINESIZE () {32;}' unless defined(&CACHELINESIZE);
	    eval 'sub MAXCACHELINESIZE () {32;}' unless defined(&MAXCACHELINESIZE);
	}
    }
    eval 'sub CPU_CACHELINE () {1;}' unless defined(&CPU_CACHELINE);
    eval 'sub CPU_TIMEBASE () {2;}' unless defined(&CPU_TIMEBASE);
    eval 'sub CPU_CPUTEMP () {3;}' unless defined(&CPU_CPUTEMP);
    eval 'sub CPU_PRINTFATALTRAPS () {4;}' unless defined(&CPU_PRINTFATALTRAPS);
    eval 'sub CPU_CACHEINFO () {5;}' unless defined(&CPU_CACHEINFO);
    eval 'sub CPU_ALTIVEC () {6;}' unless defined(&CPU_ALTIVEC);
    eval 'sub CPU_MODEL () {7;}' unless defined(&CPU_MODEL);
    eval 'sub CPU_POWERSAVE () {8;}' unless defined(&CPU_POWERSAVE);
    eval 'sub CPU_BOOTED_DEVICE () {9;}' unless defined(&CPU_BOOTED_DEVICE);
    eval 'sub CPU_BOOTED_KERNEL () {10;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_EXECPROT () {11;}' unless defined(&CPU_EXECPROT);
    eval 'sub CPU_FPU () {12;}' unless defined(&CPU_FPU);
    eval 'sub CPU_NO_UNALIGNED () {13;}' unless defined(&CPU_NO_UNALIGNED);
}
1;
