/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    static final int RED = -1;
    static final int BLACK = 1;
    static final Node nil;
    private transient Node root;
    transient int size;
    private transient Set entries;
    transient int modCount;
    final Comparator comparator;

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.root = nil;
            this.size = 0;
        }
    }

    public Object clone() {
        TreeMap copy = null;
        try {
            copy = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException x) {
            // empty catch block
        }
        copy.entries = null;
        copy.fabricateTree(this.size);
        Node node2 = this.firstNode();
        Node cnode = copy.firstNode();
        while (node2 != nil) {
            cnode.key = node2.key;
            cnode.value = node2.value;
            node2 = this.successor(node2);
            cnode = copy.successor(cnode);
        }
        return copy;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object key) {
        boolean bl = false;
        if (this.getNode(key) != nil) {
            bl = true;
        }
        return bl;
    }

    public boolean containsValue(Object value) {
        Node node2 = this.firstNode();
        while (node2 != nil) {
            if (TreeMap.equals(value, node2.value)) {
                return true;
            }
            node2 = this.successor(node2);
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public final int size() {
                    return TreeMap.this.size;
                }

                public final Iterator iterator() {
                    return new TreeIterator(2);
                }

                public final void clear() {
                    TreeMap.this.clear();
                }

                public final boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    Node n = TreeMap.this.getNode(me.getKey());
                    boolean bl = false;
                    if (n != nil && AbstractSet.equals(me.getValue(), n.value)) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    Node n = TreeMap.this.getNode(me.getKey());
                    if (n != nil && AbstractSet.equals(me.getValue(), n.value)) {
                        TreeMap.this.removeNode(n);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public Object firstKey() {
        if (this.root == nil) {
            throw new NoSuchElementException();
        }
        return this.firstNode().key;
    }

    public Object get(Object key) {
        return this.getNode((Object)key).value;
    }

    public SortedMap headMap(Object toKey) {
        return new SubMap(nil, toKey);
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public final int size() {
                    return TreeMap.this.size;
                }

                public final Iterator iterator() {
                    return new TreeIterator(0);
                }

                public final void clear() {
                    TreeMap.this.clear();
                }

                public final boolean contains(Object o) {
                    return TreeMap.this.containsKey(o);
                }

                public final boolean remove(Object key) {
                    Node n = TreeMap.this.getNode(key);
                    if (n == nil) {
                        return false;
                    }
                    TreeMap.this.removeNode(n);
                    return true;
                }
            };
        }
        return this.keys;
    }

    public Object lastKey() {
        if (this.root == nil) {
            throw new NoSuchElementException("empty");
        }
        return this.lastNode().key;
    }

    public Object put(Object key, Object value) {
        Node current = this.root;
        Node parent = nil;
        int comparison = 0;
        while (current != nil) {
            parent = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current.setValue(value);
        }
        Node n = new Node(key, value, -1);
        n.parent = parent;
        ++this.modCount;
        ++this.size;
        if (parent == nil) {
            this.root = n;
            return null;
        }
        if (comparison > 0) {
            parent.right = n;
        } else {
            parent.left = n;
        }
        this.insertFixup(n);
        return null;
    }

    public void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            Map.Entry e = (Map.Entry)itr.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Node n = this.getNode(key);
        if (n == nil) {
            return null;
        }
        Object result = n.value;
        this.removeNode(n);
        return result;
    }

    public int size() {
        return this.size;
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return new SubMap(fromKey, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        return new SubMap(fromKey, nil);
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public final int size() {
                    return TreeMap.this.size;
                }

                public final Iterator iterator() {
                    return new TreeIterator(1);
                }

                public final void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    final int compare(Object o1, Object o2) {
        return this.comparator == null ? ((Comparable)o1).compareTo(o2) : this.comparator.compare(o1, o2);
    }

    private final void deleteFixup(Node node2, Node parent) {
        while (node2 != this.root && node2.color == 1) {
            Node sibling;
            if (node2 == parent.left) {
                sibling = parent.right;
                if (sibling.color == -1) {
                    sibling.color = 1;
                    parent.color = -1;
                    this.rotateLeft(parent);
                    sibling = parent.right;
                }
                if (sibling.left.color == 1 && sibling.right.color == 1) {
                    sibling.color = -1;
                    node2 = parent;
                    parent = parent.parent;
                    continue;
                }
                if (sibling.right.color == 1) {
                    sibling.left.color = 1;
                    sibling.color = -1;
                    this.rotateRight(sibling);
                    sibling = parent.right;
                }
                sibling.color = parent.color;
                parent.color = 1;
                sibling.right.color = 1;
                this.rotateLeft(parent);
                node2 = this.root;
                continue;
            }
            sibling = parent.left;
            if (sibling.color == -1) {
                sibling.color = 1;
                parent.color = -1;
                this.rotateRight(parent);
                sibling = parent.left;
            }
            if (sibling.right.color == 1 && sibling.left.color == 1) {
                sibling.color = -1;
                node2 = parent;
                parent = parent.parent;
                continue;
            }
            if (sibling.left.color == 1) {
                sibling.right.color = 1;
                sibling.color = -1;
                this.rotateLeft(sibling);
                sibling = parent.left;
            }
            sibling.color = parent.color;
            parent.color = 1;
            sibling.left.color = 1;
            this.rotateRight(parent);
            node2 = this.root;
        }
        node2.color = 1;
    }

    private final void fabricateTree(int count) {
        Node next;
        Node right;
        Node left;
        int i;
        if (count == 0) {
            this.root = nil;
            this.size = 0;
            return;
        }
        this.root = new Node(null, null, 1);
        this.size = count;
        Node row = this.root;
        int rowsize = 2;
        while (rowsize + rowsize <= count) {
            Node parent = row;
            Node last = null;
            i = 0;
            while (i < rowsize) {
                left = new Node(null, null, 1);
                right = new Node(null, null, 1);
                left.parent = parent;
                left.right = right;
                right.parent = parent;
                parent.left = left;
                next = parent.right;
                parent.right = right;
                parent = next;
                if (last != null) {
                    last.right = left;
                }
                last = right;
                i += 2;
            }
            row = row.left;
            rowsize <<= 1;
        }
        int overflow = count - rowsize;
        Node parent = row;
        i = 0;
        while (i < overflow) {
            left = new Node(null, null, -1);
            right = new Node(null, null, -1);
            left.parent = parent;
            right.parent = parent;
            parent.left = left;
            next = parent.right;
            parent.right = right;
            parent = next;
            i += 2;
        }
        if (i - overflow == 0) {
            left = new Node(null, null, -1);
            left.parent = parent;
            parent.left = left;
            parent = parent.right;
            left.parent.right = nil;
        }
        while (parent != nil) {
            Node next2 = parent.right;
            parent.right = nil;
            parent = next2;
        }
    }

    final Node firstNode() {
        Node node2 = this.root;
        while (node2.left != nil) {
            node2 = node2.left;
        }
        return node2;
    }

    final Node getNode(Object key) {
        Node current = this.root;
        while (current != nil) {
            int comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current;
        }
        return current;
    }

    final Node highestLessThan(Object key) {
        if (key == nil) {
            return this.lastNode();
        }
        Node last = nil;
        Node current = this.root;
        int comparison = 0;
        while (current != nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return this.predecessor(last);
        }
        return comparison <= 0 ? this.predecessor(last) : last;
    }

    private final void insertFixup(Node n) {
        while (n.parent.color == -1 && n.parent.parent != nil) {
            Node uncle;
            if (n.parent == n.parent.parent.left) {
                uncle = n.parent.parent.right;
                if (uncle.color == -1) {
                    n.parent.color = 1;
                    uncle.color = 1;
                    uncle.parent.color = -1;
                    n = uncle.parent;
                    continue;
                }
                if (n == n.parent.right) {
                    n = n.parent;
                    this.rotateLeft(n);
                }
                n.parent.color = 1;
                n.parent.parent.color = -1;
                this.rotateRight(n.parent.parent);
                continue;
            }
            uncle = n.parent.parent.left;
            if (uncle.color == -1) {
                n.parent.color = 1;
                uncle.color = 1;
                uncle.parent.color = -1;
                n = uncle.parent;
                continue;
            }
            if (n == n.parent.left) {
                n = n.parent;
                this.rotateRight(n);
            }
            n.parent.color = 1;
            n.parent.parent.color = -1;
            this.rotateLeft(n.parent.parent);
        }
        this.root.color = 1;
    }

    private final Node lastNode() {
        Node node2 = this.root;
        while (node2.right != nil) {
            node2 = node2.right;
        }
        return node2;
    }

    final Node lowestGreaterThan(Object key, boolean first) {
        if (key == nil) {
            return first ? this.firstNode() : nil;
        }
        Node last = nil;
        Node current = this.root;
        int comparison = 0;
        while (current != nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current;
        }
        return comparison > 0 ? this.successor(last) : last;
    }

    private final Node predecessor(Node node2) {
        if (node2.left != nil) {
            node2 = node2.left;
            while (node2.right != nil) {
                node2 = node2.right;
            }
            return node2;
        }
        Node parent = node2.parent;
        while (node2 == parent.left) {
            node2 = parent;
            parent = node2.parent;
        }
        return parent;
    }

    final void putFromObjStream(ObjectInputStream s, int count, boolean readValues) throws IOException, ClassNotFoundException {
        this.fabricateTree(count);
        Node node2 = this.firstNode();
        while (--count >= 0) {
            node2.key = s.readObject();
            node2.value = readValues ? s.readObject() : "";
            node2 = this.successor(node2);
        }
    }

    final void putKeysLinear(Iterator keys, int count) {
        this.fabricateTree(count);
        Node node2 = this.firstNode();
        while (--count >= 0) {
            node2.key = keys.next();
            node2.value = "";
            node2 = this.successor(node2);
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.putFromObjStream(s, size, true);
    }

    final void removeNode(Node node2) {
        Node child;
        Node splice;
        ++this.modCount;
        --this.size;
        if (node2.left == nil) {
            splice = node2;
            child = node2.right;
        } else if (node2.right == nil) {
            splice = node2;
            child = node2.left;
        } else {
            splice = node2.left;
            while (splice.right != nil) {
                splice = splice.right;
            }
            child = splice.left;
            node2.key = splice.key;
            node2.value = splice.value;
        }
        Node parent = splice.parent;
        if (child != nil) {
            child.parent = parent;
        }
        if (parent == nil) {
            this.root = child;
            return;
        }
        if (splice == parent.left) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (splice.color == 1) {
            this.deleteFixup(child, parent);
        }
    }

    private final void rotateLeft(Node node2) {
        Node child = node2.right;
        node2.right = child.left;
        if (child.left != nil) {
            child.left.parent = node2;
        }
        child.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.left) {
                node2.parent.left = child;
            } else {
                node2.parent.right = child;
            }
        } else {
            this.root = child;
        }
        child.left = node2;
        node2.parent = child;
    }

    private final void rotateRight(Node node2) {
        Node child = node2.left;
        node2.left = child.right;
        if (child.right != nil) {
            child.right.parent = node2;
        }
        child.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.right) {
                node2.parent.right = child;
            } else {
                node2.parent.left = child;
            }
        } else {
            this.root = child;
        }
        child.right = node2;
        node2.parent = child;
    }

    final Node successor(Node node2) {
        if (node2.right != nil) {
            node2 = node2.right;
            while (node2.left != nil) {
                node2 = node2.left;
            }
            return node2;
        }
        Node parent = node2.parent;
        while (node2 == parent.right) {
            node2 = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node node2 = this.firstNode();
        s.writeInt(this.size);
        while (node2 != nil) {
            s.writeObject(node2.key);
            s.writeObject(node2.value);
            node2 = this.successor(node2);
        }
    }

    public TreeMap() {
        this((Comparator)null);
    }

    public TreeMap(Comparator c) {
        this.comparator = c;
        this.fabricateTree(0);
    }

    public TreeMap(Map map) {
        this((Comparator)null);
        this.putAll(map);
    }

    public TreeMap(SortedMap sm) {
        this(sm.comparator());
        int pos = sm.size();
        Iterator itr = sm.entrySet().iterator();
        this.fabricateTree(pos);
        Node node2 = this.firstNode();
        while (--pos >= 0) {
            Map.Entry me = (Map.Entry)itr.next();
            node2.key = me.getKey();
            node2.value = me.getValue();
            node2 = this.successor(node2);
        }
    }

    static {
        TreeMap.nil.parent = nil = new Node(null, null, 1);
        TreeMap.nil.left = nil;
        TreeMap.nil.right = nil;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class Node
    extends AbstractMap.BasicMapEntry {
        int color;
        Node left;
        Node right;
        Node parent;

        private final /* synthetic */ void this() {
            this.left = nil;
            this.right = nil;
            this.parent = nil;
        }

        Node(Object key, Object value, int color) {
            super(key, value);
            this.this();
            this.color = color;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class SubMap
    extends AbstractMap
    implements SortedMap {
        final Object minKey;
        final Object maxKey;
        private Set entries;

        final boolean keyInRange(Object key) {
            boolean bl = false;
            if (!(this.minKey != nil && TreeMap.this.compare(key, this.minKey) < 0 || this.maxKey != nil && TreeMap.this.compare(key, this.maxKey) >= 0)) {
                bl = true;
            }
            return bl;
        }

        public final void clear() {
            Node next = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node max = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (next != max) {
                Node current = next;
                next = TreeMap.this.successor(current);
                TreeMap.this.removeNode(current);
            }
        }

        public final Comparator comparator() {
            return TreeMap.this.comparator;
        }

        public final boolean containsKey(Object key) {
            boolean bl = false;
            if (this.keyInRange(key) && TreeMap.this.containsKey(key)) {
                bl = true;
            }
            return bl;
        }

        public final boolean containsValue(Object value) {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node max = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (node2 != max) {
                if (SubMap.equals(value, node2.getValue())) {
                    return true;
                }
                node2 = TreeMap.this.successor(node2);
            }
            return false;
        }

        public final Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractSet(){

                    public final int size() {
                        return SubMap.this.size();
                    }

                    public final Iterator iterator() {
                        Node first = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node max = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(2, first, max);
                    }

                    public final void clear() {
                        SubMap.this.clear();
                    }

                    public final boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry me = (Map.Entry)o;
                        Object key = me.getKey();
                        if (!SubMap.this.keyInRange(key)) {
                            return false;
                        }
                        Node n = TreeMap.this.getNode(key);
                        boolean bl = false;
                        if (n != nil && AbstractSet.equals(me.getValue(), n.value)) {
                            bl = true;
                        }
                        return bl;
                    }

                    public final boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry me = (Map.Entry)o;
                        Object key = me.getKey();
                        if (!SubMap.this.keyInRange(key)) {
                            return false;
                        }
                        Node n = TreeMap.this.getNode(key);
                        if (n != nil && AbstractSet.equals(me.getValue(), n.value)) {
                            TreeMap.this.removeNode(n);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.entries;
        }

        public final Object firstKey() {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            if (node2 == nil || !this.keyInRange(node2.key)) {
                throw new NoSuchElementException();
            }
            return node2.key;
        }

        public final Object get(Object key) {
            if (this.keyInRange(key)) {
                return TreeMap.this.get(key);
            }
            return null;
        }

        public final SortedMap headMap(Object toKey) {
            if (!this.keyInRange(toKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.minKey, toKey);
        }

        public final Set keySet() {
            if (this.keys == null) {
                this.keys = new AbstractSet(){

                    public final int size() {
                        return SubMap.this.size();
                    }

                    public final Iterator iterator() {
                        Node first = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node max = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(0, first, max);
                    }

                    public final void clear() {
                        SubMap.this.clear();
                    }

                    public final boolean contains(Object o) {
                        if (!SubMap.this.keyInRange(o)) {
                            return false;
                        }
                        boolean bl = false;
                        if (TreeMap.this.getNode(o) != nil) {
                            bl = true;
                        }
                        return bl;
                    }

                    public final boolean remove(Object o) {
                        if (!SubMap.this.keyInRange(o)) {
                            return false;
                        }
                        Node n = TreeMap.this.getNode(o);
                        if (n != nil) {
                            TreeMap.this.removeNode(n);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.keys;
        }

        public final Object lastKey() {
            Node node2 = TreeMap.this.highestLessThan(this.maxKey);
            if (node2 == nil || !this.keyInRange(node2.key)) {
                throw new NoSuchElementException();
            }
            return node2.key;
        }

        public final Object put(Object key, Object value) {
            if (!this.keyInRange(key)) {
                throw new IllegalArgumentException("Key outside range");
            }
            return TreeMap.this.put(key, value);
        }

        public final Object remove(Object key) {
            if (this.keyInRange(key)) {
                return TreeMap.this.remove(key);
            }
            return null;
        }

        public final int size() {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node max = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            int count = 0;
            while (node2 != max) {
                ++count;
                node2 = TreeMap.this.successor(node2);
            }
            return count;
        }

        public final SortedMap subMap(Object fromKey, Object toKey) {
            if (!this.keyInRange(fromKey) || !this.keyInRange(toKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(fromKey, toKey);
        }

        public final SortedMap tailMap(Object fromKey) {
            if (!this.keyInRange(fromKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(fromKey, this.maxKey);
        }

        public final Collection values() {
            if (this.values == null) {
                this.values = new AbstractCollection(){

                    public final int size() {
                        return SubMap.this.size();
                    }

                    public final Iterator iterator() {
                        Node first = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node max = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(1, first, max);
                    }

                    public final void clear() {
                        SubMap.this.clear();
                    }
                };
            }
            return this.values;
        }

        SubMap(Object minKey, Object maxKey) {
            if (minKey != nil && maxKey != nil && TreeMap.this.compare(minKey, maxKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.minKey = minKey;
            this.maxKey = maxKey;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class TreeIterator
    implements Iterator {
        private final int type;
        private int knownMod;
        private Node last;
        private Node next;
        private final Node max;

        public final boolean hasNext() {
            if (this.knownMod != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            boolean bl = false;
            if (this.next != this.max) {
                bl = true;
            }
            return bl;
        }

        public final Object next() {
            if (this.knownMod != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == this.max) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = TreeMap.this.successor(this.last);
            if (this.type == 1) {
                return this.last.value;
            }
            if (this.type == 0) {
                return this.last.key;
            }
            return this.last;
        }

        public final void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.knownMod != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.removeNode(this.last);
            this.last = null;
            ++this.knownMod;
        }

        private final /* synthetic */ void this() {
            this.knownMod = TreeMap.this.modCount;
        }

        TreeIterator(int type) {
            this.this();
            this.type = type;
            this.next = TreeMap.this.firstNode();
            this.max = nil;
        }

        TreeIterator(int type, Node first, Node max) {
            this.this();
            this.type = type;
            this.next = first;
            this.max = max;
        }
    }
}

