<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">
                          <!ENTITY eur "&#128;">
                          <!ENTITY copy "&#169;">]>
<!-- $Id: xtraeme.xsl,v 1.12 2003/06/23 20:01:52 juan Exp $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		version="1.0">
<xsl:output
  output="html"
  encoding="iso-8859-1" 
  doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
  indent="yes"/>
<!--
## Empieza el nodo raiz, en el cual declaramos 
## la siguiente plantilla, la cual llamar a las 
## siguientes ...
-->
<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
  <head>
    <title>Juan RP's webpage</title>
    <link rel="stylesheet" type="text/css" href="{$TOPDIR}/estilo.css" />
    <meta name="description" content="Aqui encontrars paquetes no oficiales para
    NetBSD llamados pkgsrc, algo de historia sobre BSD, informacin sobre el autor,
    tutoriales, etc." />
    <meta name="keywords" content="bsd, hispabsd, unixbsd, forosbsd, userbsd,
    eldemonio, netbsd, pkgsrc, tutoriales NetBSD, pkgsrc no oficiales, xtraeme, Juan
    RP"/>
  </head>
<body bgcolor="white">
<!-- 
## Llamamos a las plantillas que llamaran a todas las 
## demas ...
-->
  <table width="100%" cellpadding="5">
    <tr>
      <td width="145" valign="top" align="center">
        <p>
          <xsl:apply-templates select="indice/enlix"/>
        </p>
      </td>
      <td align="center">
	  <xsl:apply-templates select="indice" />
      </td>
    </tr>
    <tr>
      <td colspan="2" valign="top"
      align="center">
	  <xsl:apply-templates select="indice/firma"/>
      </td>
    </tr>
  </table>
</body>
</html>
</xsl:template>

  <xsl:template match="indice">
	  <xsl:apply-templates select="imagen" />
	  <xsl:apply-templates select="titulo[@clase='main']" />
	  <xsl:apply-templates select="noticia" />
	  <xsl:apply-templates select="news" />
	  <xsl:apply-templates select="cv" />
	  <xsl:apply-templates select="link" />
  </xsl:template>

  <xsl:template match="imagen">
	  <img src="{$TOPDIR}/{@src}" border="0" alt="{@alt}"/><xsl:apply-templates />
  </xsl:template>

  <xsl:template match="enlix">
	      <xsl:apply-templates />
  </xsl:template>
  
  <xsl:template match="link">
	      <a href="{@href}" title="{@title}" target="{@target}"><xsl:apply-templates /></a>
  </xsl:template>
  
  <xsl:template match="link[@clase='small']">
	      <a href="{@href}" title="{@title}" target="{@target}"><xsl:apply-templates /></a>
  </xsl:template>
  
  <!-- Para que los logos de abajo queden centrados -->
  <xsl:template match="logos">
	    <center>	
	      <xsl:apply-templates/>
	    </center>	
  </xsl:template>
  <xsl:template match="item">
	      <xsl:apply-templates/>
  </xsl:template>
  <!--  Fin de logos -->

  <!-- Seccin Documentos, trozos representados como cdigo -->
  <xsl:template match="codigo">
	    <pre><xsl:apply-templates /></pre>
  </xsl:template>
  <xsl:template match="salto">
	    <xsl:apply-templates />
	  <br/>  
  </xsl:template>
  <!-- Fin de la seccin Documentos -->
  
  <xsl:template match="nombre">
	    <b>
	      <xsl:apply-templates />
	    </b>
  </xsl:template>  
  
  <xsl:template match="marca">
	    <font color="darkblue"><em>
	      <xsl:apply-templates />
	    </em></font>
  </xsl:template>
  
  <xsl:template match="cv">
	    <p left="left" class="titulo">
	      <xsl:apply-templates select="entry" />
	      <xsl:apply-templates select="seccion" />
	    </p>
  </xsl:template>

  <xsl:template match="entry">
	      <xsl:apply-templates /><br />
  </xsl:template>
  
  <xsl:template match="seccion">
	      <xsl:apply-templates select="titulo" />
	      <xsl:apply-templates select="lista" />
  </xsl:template>

  <xsl:template match="titulo">
	    <h2 align="left">
	      <xsl:apply-templates />
	    </h2>
  </xsl:template>
  
  <xsl:template match="lista">
	    <li class="{@tipo}">
	      <xsl:apply-templates />
	    </li>
  </xsl:template>
 
  <!-- Procesa la etiqueta mail -->
  <xsl:template match="mail">
	    <a href="mailto:{@url}">
	      <xsl:apply-templates />
	    </a>
  </xsl:template>
  <!-- Final -->
  
 <xsl:template match="noticia">
              <xsl:apply-templates select="ancla" />
              <xsl:apply-templates select="titulo" />
              <xsl:apply-templates select="logo" />
              <xsl:apply-templates select="pa" />
              <xsl:apply-templates select="codigo" />
              <xsl:apply-templates select="salto" />
 </xsl:template>

 <xsl:template match="news">
      <xsl:choose>
      <xsl:when test="@numero">
	      <xsl:apply-templates select="notice[position() &lt;= ../@numero]"/>
	      <br /><a href="noticias.html">En anteriores noticias...</a><br /><br />
	      <br />
      </xsl:when>
      <xsl:otherwise>
	  <xsl:apply-templates select="notice" />
      </xsl:otherwise>
      </xsl:choose>
  </xsl:template>

 <xsl:template match="notice">
              <xsl:apply-templates select="ancla" />
	      <xsl:apply-templates select="titulo[@*]" />
              <xsl:apply-templates select="pa" />
              <xsl:apply-templates select="salto" />
 </xsl:template>
 
 <!-- Final -->

  <!-- Cabeceras de los titulos -->
  <xsl:template match="titulo[@clase='main']">
	    	<p align="center" class="titulomain">
	      <xsl:apply-templates />
		</p>
  </xsl:template>
  <xsl:template match="titulo[@clase='noticia']">
		<p align="left" class="titulonoticia">
	      <xsl:apply-templates />
		</p>
  </xsl:template>
  <!-- Final -->
  <xsl:template match="ancla">
	    <a name="{@name}">
	      <xsl:apply-templates />
	    </a>
  </xsl:template>	    
  <!-- Para el logo de NetBSD -->
  <xsl:template match="logo">
	  <img src="{$TOPDIR}/{@src}" align="left" alt="{@alt}"/>
	      <xsl:apply-templates />
  </xsl:template>
  <!-- Final -->
  <xsl:template match="pa">
	    <p align="left" class="noticia">
	      <xsl:apply-templates />
	    </p>
  </xsl:template>
  
  <xsl:template match="firma">
	      <xsl:apply-templates select="autor" />
	      <xsl:apply-templates select="logos" />
  </xsl:template>

  <!-- Letra pequeita -->
  <xsl:template match="autor">
	    <font class="autor">
	      <xsl:apply-templates />
	    </font>
  </xsl:template>
  <!-- Final -->
  <!-- Eso es todo amigos ... -->
</xsl:stylesheet>
