/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class RegexpTest
extends RegexpMatcherTest {
    private static final String test = "abcdefg-abcdefg";
    private static final String pattern = "ab([^d]*)d([^f]*)f";

    public final RegexpMatcher getImplementation() {
        return this.getRegexpImplementation();
    }

    public abstract Regexp getRegexpImplementation();

    @Test
    public void testSubstitution() {
        Regexp reg = (Regexp)this.getReg();
        reg.setPattern(pattern);
        Assert.assertTrue((boolean)reg.matches(test));
        Assert.assertEquals((Object)"abedcfg-abcdefg", (Object)reg.substitute(test, "ab\\2d\\1f", 0));
    }

    @Test
    public void testReplaceFirstSubstitution() {
        Regexp reg = (Regexp)this.getReg();
        reg.setPattern(pattern);
        Assert.assertTrue((boolean)reg.matches(test));
        Assert.assertEquals((Object)"abedcfg-abcdefg", (Object)reg.substitute(test, "ab\\2d\\1f", 1));
    }

    @Test
    public void testReplaceAllSubstitution() {
        Regexp reg = (Regexp)this.getReg();
        reg.setPattern(pattern);
        Assert.assertTrue((boolean)reg.matches(test));
        Assert.assertEquals((Object)"abedcfg-abedcfg", (Object)reg.substitute(test, "ab\\2d\\1f", 16));
    }
}

