/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.test;

import com.thaiopensource.datatype.xsd.regex.Regex;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import com.thaiopensource.util.Utf16;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;

public class CategoryTest {
    private static final String categories = "LMNPZSC";
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private final Regex[] categoryPosRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] categoryNegRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] subCategoryPosRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private final Regex[] subCategoryNegRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    int nFail = 0;

    public static void main(String[] args) throws IOException, RegexSyntaxException {
        RegexEngine engine;
        if (args.length != 2) {
            System.err.println("usage: " + CategoryTest.class.getName() + " engineClass UnicodeData");
            System.exit(2);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(args[1])));
        Enumeration e = new Service(RegexEngine.class).getProviders();
        do {
            if (e.hasMoreElements()) continue;
            System.err.println("couldn't find regex engine");
            System.exit(2);
        } while (!(engine = (RegexEngine)e.nextElement()).getClass().getName().equals(args[0]));
        int nFail = new CategoryTest(engine).testAll(r);
        System.err.println(nFail + " tests failed");
        System.exit(nFail > 0 ? 1 : 0);
    }

    CategoryTest(RegexEngine engine) throws RegexSyntaxException {
        int i;
        int len = categories.length();
        for (i = 0; i < len; ++i) {
            String ch = categories.substring(i, i + 1);
            this.categoryPosRegexes[i] = engine.compile("\\p{" + ch + "}");
            this.categoryNegRegexes[i] = engine.compile("\\P{" + ch + "}");
        }
        len = subCategories.length();
        for (i = 0; i < len; i += 2) {
            String name = subCategories.substring(i, i + 2);
            this.subCategoryPosRegexes[i / 2] = engine.compile("\\p{" + name + "}");
            this.subCategoryNegRegexes[i / 2] = engine.compile("\\P{" + name + "}");
        }
    }

    int testAll(BufferedReader r) throws IOException {
        String line;
        int lastCode = -1;
        while ((line = r.readLine()) != null) {
            int semi = line.indexOf(59);
            if (semi < 0) continue;
            int code = Integer.parseInt(line.substring(0, semi), 16);
            int semi2 = line.indexOf(59, semi + 1);
            String name = line.substring(semi, semi2);
            String category = line.substring(semi2 + 1, semi2 + 3);
            if (lastCode + 1 != code) {
                String missingCategory = name.endsWith(", Last>") ? category : "Cn";
                for (int i = lastCode + 1; i < code; ++i) {
                    this.test(i, missingCategory);
                }
            }
            this.test(code, category);
            lastCode = code;
        }
        ++lastCode;
        while (lastCode < 0x110000) {
            this.test(lastCode, "Cn");
            ++lastCode;
        }
        return this.nFail;
    }

    void test(int ch, String category) {
        int i;
        if (!CategoryTest.isXmlChar(ch)) {
            return;
        }
        if (subCategories.indexOf(category) < 0) {
            System.err.println("Missing category: " + category);
            System.exit(2);
        }
        int len = categories.length();
        for (i = 0; i < len; ++i) {
            this.check(ch, this.categoryPosRegexes[i], this.categoryNegRegexes[i], category.charAt(0) == categories.charAt(i), categories.substring(i, i + 1));
        }
        len = subCategories.length();
        for (i = 0; i < len; i += 2) {
            this.check(ch, this.subCategoryPosRegexes[i / 2], this.subCategoryNegRegexes[i / 2], category.equals(subCategories.substring(i, i + 2)), subCategories.substring(i, i + 2));
        }
    }

    void check(int ch, Regex pos, Regex neg, boolean inPos, String cat) {
        String str = ch > 65535 ? new String(new char[]{Utf16.surrogate1(ch), Utf16.surrogate2(ch)}) : new String(new char[]{(char)ch});
        if (pos.matches(str) != inPos) {
            this.fail(ch, cat);
        }
        if (neg.matches(str) != !inPos) {
            this.fail(ch, "-" + cat);
        }
    }

    void fail(int ch, String cat) {
        ++this.nFail;
        System.err.println("Failed: " + Integer.toHexString(ch) + "/" + cat);
    }

    static boolean isXmlChar(int code) {
        switch (code) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
            case 65534: 
            case 65535: {
                return false;
            }
        }
        if (code < 32) {
            return false;
        }
        return code < 55296 || code >= 57344;
    }
}

