/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2024 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
import SearchTokenizer from"./SearchTokenizer.js";export default class SearchInput{constructor(t,e){this.original_input=$(t);this.options=Object.assign({backspace_action:"edit",tokenizer_options:{},filter_on_type:true,input_options:{classes:[],attributes:{},data:{}}},e||{});this.tokenizer=new SearchTokenizer(this.options.allowed_tags||{},this.options.drop_unallowed_tags||false,this.options.tokenizer_options);this.displayed_input=$(`\n         <div class="form-control search-input d-flex overflow-auto" tabindex="0"></div>\n      `).insertBefore(t);this.displayed_input.append(`<span class="search-input-tag-input flex-grow-1" contenteditable="true"></span>`);this.applyInputOptions();this.original_input.hide();this.last_result=null;this.registerListeners()}applyInputOptions(){let t={};if(typeof this.options.input_options.attributes==="object"){t=this.options.input_options.attributes}else if(this.options.input_options.attributes==="copy"){const e=this.original_input.get(0).attributes;for(let s=0;s<e.length;s++){if(!e[s].name.startsWith("data-")&&e[s].name!=="class"){t[e[s].name]=e[s].value}}}let e={};let s={};if(typeof this.options.input_options.data==="object"){e=this.options.input_options.data}else if(this.options.input_options.data==="copy"){e=this.original_input.data();const t=this.original_input.get(0).attributes;for(let e=0;e<t.length;e++){if(t[e].name.startsWith("data-")){s[t[e].name]=t[e].value}}}t=Object.assign(s,Object.keys(e).reduce(((t,s)=>{t["data-"+s]=e[s];return t}),t));this.displayed_input.attr(t);if(Array.isArray(this.options.input_options.classes)){this.displayed_input.addClass(this.options.input_options.classes.join(" "))}else if(this.options.input_options.classes==="copy"){this.displayed_input.addClass(this.original_input.attr("class"))}}registerListeners(){const t=this.displayed_input;t.on("input change",(()=>{if(this.isSelectionUntagged()){this.refreshPopover()}}));t.popover(Object.assign({trigger:"manual",html:true,container:this.displayed_input.parent(),customClass:"search-input-popover shadow",placement:"bottom",popperConfig:{placement:"bottom-start"},delay:{hide:300},sanitize:false,content:()=>this.getPopoverContent()},this.options.popover||{}));t.parent().on("mousedown",".search-input-popover",(t=>{t.preventDefault()}));t.parent().on("click",".search-input-popover .tags-list li",(t=>{t.preventDefault();t.stopPropagation();const e=$(t.target).closest("li").attr("data-tag");const s=$('<span class="search-input-tag-input">'+e.trim()+":</span>").insertBefore($(".search-input-tag-input:last-of-type"));const i=this.getSelectedNode();$(i).text("");const n=this.tagifyInputNode(s);this.makeTagEditable(n);n.focus()}));t.parent().on("click",".search-input-popover .tags-list li button.tag-prefix",(t=>{t.preventDefault();t.stopPropagation();const e=$(t.target).closest("button.tag-prefix").attr("data-prefix");const s=$(t.target).closest("li").attr("data-tag");const i=$('<span class="search-input-tag-input">'+(e||"")+s.trim()+":</span>").insertBefore($(".search-input-tag-input:last-of-type"));const n=this.getSelectedNode();$(n).text("");const o=this.tagifyInputNode(i);this.makeTagEditable(o);o.focus()}));t.parent().on("click",".search-input-popover .term-suggestions-list li",(e=>{e.preventDefault();const s=$(e.target).closest("li");const i=s.closest("ul").attr("data-tag");const n=s.text().trim();const o=t.find('.search-input-tag-input[data-tag="'+i+'"]');o.text(`${i}:${n}`);this.tagifyInputNode(o);this.placeCaretInDefaultInput()}));t.on("input click focus",(()=>{this.refreshPopover();t.popover("show")}));$(document.body).on("click",(e=>{if($(e.target).closest(t,this.original_input,t.parent().find(".search-input-popover")).length===0){t.popover("hide")}}));t.on("blur",".search-input-tag-input",(t=>{const e=$(t.target).closest(".search-input-tag-input");if(e.length>0&&e.text().trim().length>0){this.tagifyInputNode(e)}}));t.on("keydown",".search-input-tag-input",(e=>{if(e.keyCode===9){e.preventDefault()}else if(e.keyCode===8){const t=this.getSelectedNode();if(!t||t.classList.contains("search-input-tag-input")){const s=document.getSelection();if(!s.anchorNode.isSameNode(s.focusNode)){e.preventDefault()}if(s.anchorOffset===0){if(this.options.backspace_action==="remove"){const e=t.previousSibling;if(e){e.remove();this.displayed_input.trigger("result_change")}}else if(this.options.backspace_action==="edit"){const s=$(t.previousSibling);if(s){this.makeTagEditable(s);e.preventDefault()}}}}}else if(e.keyCode===13){e.preventDefault();const s=t.parent().find(".search-input-popover ul");if(s.length>0){const t=s.find("li.active");if(t.length>0){const e=t.find("button.tag-prefix.active");if(e.length>0){e.click()}else{t.click()}}else{this.tagifySelectedNode()}}else{this.tagifySelectedNode()}}else if(e.keyCode===40){const e=t.parent().find(".search-input-popover ul");if(e.length>0){const t=e.find("li.active");if(t.length===0){e.find("li:first-of-type").addClass("active")}else{const e=t.next();if(e.length>0){t.removeClass("active");e.addClass("active")}}e.find("button.tag-prefix").removeClass("active")}}else if(e.keyCode===38){const e=t.parent().find(".search-input-popover ul");if(e.length>0){const t=e.find("li.active");if(t.length===0){e.find("li:last-of-type").addClass("active")}else{const e=t.prev();if(e.length>0){t.removeClass("active");e.addClass("active")}}e.find("button.tag-prefix").removeClass("active")}}else if(e.keyCode===37){const e=t.parent().find(".search-input-popover ul");if(e.length>0){const t=e.find("li.active");if(t.length>0){const e=t.find("button.tag-prefix.active");if(e.length===0){t.find("button.tag-prefix:last-of-type").addClass("active")}else{const t=e.prev();e.removeClass("active");if(t.length>0){t.addClass("active")}}}}}else if(e.keyCode===39){const e=t.parent().find(".search-input-popover ul");if(e.length>0){const t=e.find("li.active");if(t.length>0){const e=t.find("button.tag-prefix.active");if(e.length===0){t.find("button.tag-prefix:first-of-type").addClass("active")}else{const t=e.next();e.removeClass("active");if(t.length>0){t.addClass("active")}}}}}}));t.on("keypress",".search-input-tag-input",(t=>{if(t.keyCode===13){t.preventDefault()}}));t.on("keyup","search-input-tag-input",(t=>{if(t.keyCode===9){t.preventDefault();this.tagifySelectedNode()}}));t.on("click",".search-input-tag",(t=>{const e=$(t.target).closest(".search-input-tag");this.makeTagEditable(e)}));t.on("click",".search-input-tag i",(t=>{$(t.target).closest(".search-input-tag").remove();this.displayed_input.trigger("result_change")}));t.on("result_change",(t=>{let e=this.getRawInput();const s=this.tokenizer.tokenize(e);const i=JSON.stringify(s)!==JSON.stringify(this.last_result);if(this.options.on_result_change&&i){this.options.on_result_change(t,s)}this.last_result=s}))}tagifySelectedNode(){const t=$(this.getSelectedNode());if(t&&this.isSelectionUntagged()){return this.tagifyInputNode(t)}return null}tokenToTagHtml(t){const e=t.tag?`<b>${t.exclusion?this.tokenizer.EXCLUSION_PREFIX:""}${t.prefix?t.prefix:""}${t.tag}</b>:`:"";let s=null;if(this.tokenizer.options.custom_prefixes[t.prefix]){s=this.tokenizer.options.custom_prefixes[t.prefix].token_color||null}else if(t.exclusion){s="#80000080"}const i=$("html").css("--is-dark").trim()==="true";const n=$(document.body).css("color");let o="";if(!t.tag){s=n}if(i){s=s||"#b3b3b3";if(s.indexOf("#")===0){s=s.replace(/[^#]*#([0-9a-f]{6})([0-9a-f]{2})?/i,"#$1")}o=s?`style="border-color: ${s} !important; background-color: unset !important;"`:""}else{o=s?`style="background-color: ${s} !important"`:""}return`<span class="search-input-tag badge bg-secondary me-1" contenteditable="false" data-tag="${t.tag}" ${o}>\n                  <span class="search-input-tag-value" contenteditable="false">${e}${escapeMarkupText(t.term)||""}</span>\n                  <i class="ti ti-x cursor-pointer ms-1" title="${__("Delete")}" contenteditable="false"></i>\n               </span>`}tagifyInputNode(t){const e=this.tokenizer.tokenize(t.text());const s=e.getTaggedTerms();const i=e.getUntaggedTerms();let n=null;for(let e=0;e<s.length;e++){const i=s[e];n=$(this.tokenToTagHtml(i)).insertBefore(t);n.data("token",i);this.transformTagTermFromAutocomplete(n)}if(t.data("token")!==undefined&&t.data("token").tag){const s=e.getFullPhrase();t.text(s)}else{for(let e=0;e<i.length;e++){const s=i[e];n=$(this.tokenToTagHtml(s)).insertBefore(t);n.data("token",s)}t.text("")}if(t.text().length===0){if(t.is(":last-child")){t.empty()}else{try{t.remove()}catch(t){}}if(n){this.displayed_input.find(".search-input-tag-input:last-of-type").focus();this.refreshPopover()}}else{this.placeCaretAtEndOfNode(t.get(0))}this.displayed_input.trigger("result_change");return n}transformTagTermFromAutocomplete(t){const e=this.tokenizer.tokenize(t.text());const s=e.getTaggedTerms();const i=s[s.length-1];const n=this.tokenizer.getAutocomplete(i.tag);if(n){n.forEach((e=>{const s=$(`<span>${e}</span>`).text();const n=$(`<span>${i.term}</span>`).text();if(s.localeCompare(n,undefined,{sensitivity:"accent"})===0){i.term=e;const s=$(this.tokenToTagHtml(i));s.data("token",i);t.replaceWith(s)}}))}}makeTagEditable(t){if(t&&t.hasClass("search-input-tag")){t.removeClass("search-input-tag");t.addClass("search-input-tag-input");t.attr("contenteditable","true");const e=t.data("token");t.empty();t.text(e.raw);t.focus();this.placeCaretAtEndOfNode(t.get(0));this.refreshPopover();this.displayed_input.trigger("result_change")}}getSelectedNode(){const t=document.getSelection();let e=null;if(t){e=t.anchorNode;if(e&&e.nodeType===Node.TEXT_NODE){e=e.parentNode}}return e||null}isSelectionUntagged(){const t=this.getSelectedNode();return t!==null&&t.classList.contains("search-input-tag-input")}placeCaretAfterNode(t){if(!t||!t.parentNode){return}const e=t.nextSibling;const s=document.getSelection();const i=s.getRangeAt(0);if(s.rangeCount){i.setStartAfter(e||t);i.collapse(true);s.removeAllRanges();s.addRange(i);this.refreshPopover()}}placeCaretAtStartOfNode(t){if(!t||!t.parentNode){return}const e=document.getSelection();const s=e.getRangeAt(0);if(e.rangeCount){s.setStart(t,0);s.collapse(true);e.removeAllRanges();e.addRange(s);this.refreshPopover()}}placeCaretAtEndOfNode(t){const e=document.getSelection();const s=document.createRange();if(t.lastChild&&t.lastChild.nodeType===Node.TEXT_NODE){s.setStart(t.lastChild,t.lastChild.length)}else{s.setStart(t,t.childNodes.length)}e.removeAllRanges();e.addRange(s);this.refreshPopover()}placeCaretInDefaultInput(){const t=this.displayed_input.find(".search-input-tag-input:last-of-type");if(t.length>0){this.placeCaretAtStartOfNode(t.get(0))}}getRawInput(){let t="";this.displayed_input.find(".search-input-tag").each(((e,s)=>{const i=$(s);if(i.data("token")!==undefined){t+=i.data("token").raw+" "}}));return t.trim()}refreshPopover(){const t=this.getPopoverContent();this.displayed_input.parent().find(".popover-body").html(t)}getPopoverContent(){const t=this.displayed_input;const e=$(this.getSelectedNode());let s=null;if(this.isSelectionUntagged()){if(e.closest(t)){const t=e.text();const i=document.getSelection().anchorOffset;const n=t.slice(0,i);if(n.endsWith(" ")){return this.getTagsHelperContent()}const o=this.tokenizer.tokenize(n).tokens;const a=Math.max.apply(Math,o.map((t=>t.position)));s=o.find((t=>t.position===a))}}return s&&s.tag?this.getAutocompleteHelperContent(s.tag):this.getTagsHelperContent()}getTagsHelperContent(){const t=this.tokenizer.allowed_tags;const e=$(this.getSelectedNode());let s=(e?e.text():"").trim();const i=s.match(/(?:[^\s"]+|"[^"]*")+/g);s=i?i[i.length-1]:"";let n="";if(Object.keys(t).length>0){n+='<ul class="list-group tags-list">'}$.each(t,((t,e)=>{if(this.options.filter_on_type&&s.length>0&&!t.toLowerCase().startsWith(s.toLowerCase())){return}const i=e.description||"";let o="";const a=Object.keys(e.supported_prefixes||{}).length;$.each(e.supported_prefixes,((t,e)=>{const s=this.tokenizer.options.custom_prefixes[e];let i=s?s.label||e:e;if(e===this.tokenizer.EXCLUSION_PREFIX){i=__("Exclude")}o+=`<button type="button" class="btn btn-outline-secondary btn-sm ${a>1?"ms-1":""} tag-prefix" title="${i}" data-prefix="${e}">${e}</button>`}));n+=`\n            <li class="list-group-item list-group-item-action" style="cursor: pointer" data-tag="${t}">\n                <div class="d-flex flex-grow-1 justify-content-between">\n                   <b>${t}</b>\n                   <span>${o}</span>\n                </div>\n                <div class="text-muted fst-italic">${i}</div>\n            </li>\n         `}));if(Object.keys(t).length>0){n+="</ul>"}return n}getAutocompleteHelperContent(t){t=t.toLowerCase();const e=this.tokenizer.allowed_tags[t];if(e===undefined){return null}const s=$(this.getSelectedNode());const i=(s?s.text():"").trim();const n=this.tokenizer.tokenize(i).getTaggedTerms();const o=(n.length>0?n[0].term:"").trim();let a="";const r=this.tokenizer.getAutocomplete(t);if(r.length>0){a+=`<ul class="list-group term-suggestions-list" data-tag="${t}">`}else{a=`${t.toLowerCase()}: ${e.description}`}$.each(r,((t,e)=>{if(this.options.filter_on_type&&i.length>0&&!e.toLowerCase().startsWith(o.toLowerCase())){return}a+=`<li class="list-group-item list-group-item-action" style="cursor: pointer">${e}</li>`}));if(r.length>0){a+="</ul>"}return a}}