/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=25
//  date=$Date: 2014-02-25 23:17:53 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9792 $
//  type=gd

/**
 * Implementation of DateTimeFormatInfo for the "gd" locale.
 */
public class DateTimeFormatInfoImpl_gd extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "m",
        "f"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "dd/MM/y";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "Ro Chrìost",
        "Anno Domini"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "RC",
        "AD"
    };
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "Am Faoilleach",
        "An Gearran",
        "Am Màrt",
        "An Giblean",
        "An Cèitean",
        "An t-Ògmhios",
        "An t-Iuchar",
        "An Lùnastal",
        "An t-Sultain",
        "An Dàmhair",
        "An t-Samhain",
        "An Dùbhlachd"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "FA",
        "GE",
        "MÀ",
        "GI",
        "CÈ",
        "ÒG",
        "IU",
        "LÙ",
        "SU",
        "DÀ",
        "SA",
        "DÙ"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "Faoi",
        "Gearr",
        "Màrt",
        "Gibl",
        "Cèit",
        "Ògmh",
        "Iuch",
        "Lùna",
        "Sult",
        "Dàmh",
        "Samh",
        "Dùbh"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1d ràithe",
        "2na ràithe",
        "3as ràithe",
        "4mh ràithe"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "R1",
        "R2",
        "R3",
        "R4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "DiDòmhnaich",
        "DiLuain",
        "DiMàirt",
        "DiCiadain",
        "Diardaoin",
        "DihAoine",
        "DiSathairne"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "D",
        "L",
        "M",
        "C",
        "A",
        "H",
        "S"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "DiD",
        "DiL",
        "DiM",
        "DiC",
        "Dia",
        "Dih",
        "DiS"
    };
  }
}
