/*
 * Decompiled with CFR 0.152.
 */
package free.util.audio;

import free.util.BlockingQueue;
import free.util.IOUtilities;
import free.util.audio.AudioClip;
import free.util.audio.AudioPlayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalAppAudioPlayer
implements Runnable,
AudioPlayer {
    private Thread playerThread = null;
    private final BlockingQueue clipQueue = new BlockingQueue();

    public boolean isSupported() {
        try {
            Process process = this.createPlayer();
            if (process != null) {
                process.destroy();
                return true;
            }
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized void play(AudioClip audioClip) throws IOException {
        if (this.playerThread == null) {
            this.playerThread = new Thread((Runnable)this, "ExternalAppAudioPlayer");
            this.playerThread.setDaemon(true);
            this.playerThread.start();
        }
        this.clipQueue.push(audioClip);
    }

    private Process createPlayer() throws IOException {
        return Runtime.getRuntime().exec("./play");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object;
            InputStream inputStream = null;
            try {
                AudioClip audioClip;
                Process process = this.createPlayer();
                inputStream = process.getErrorStream();
                object = process.getOutputStream();
                try {
                    audioClip = (AudioClip)this.clipQueue.pop();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
                byte[] byArray = audioClip.getData();
                ((OutputStream)object).write(byArray);
                ((OutputStream)object).flush();
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                try {
                    IOUtilities.pump(inputStream, System.out);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                iOException.printStackTrace();
                object = this;
                synchronized (object) {
                    this.playerThread = null;
                    return;
                }
            }
        }
    }
}

