/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.PropertyPermission;

public final class System {
    public static final InputStream in = VMSystem.makeStandardInputStream();
    public static final PrintStream out = VMSystem.makeStandardOutputStream();
    public static final PrintStream err = VMSystem.makeStandardErrorStream();

    public static final void setIn(InputStream inputStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setIn(inputStream);
    }

    public static final void setOut(PrintStream printStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setOut(printStream);
    }

    public static final void setErr(PrintStream printStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setErr(printStream);
    }

    public static final synchronized void setSecurityManager(SecurityManager securityManager) {
        if (SecurityManager.current != null) {
            SecurityManager.current.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (SecurityManager.current == null) {
            try {
                Class.forName("java.security.Security");
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        SecurityManager.current = securityManager;
    }

    public static final SecurityManager getSecurityManager() {
        return SecurityManager.current;
    }

    public static final long currentTimeMillis() {
        return VMSystem.currentTimeMillis();
    }

    public static final void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        VMSystem.arraycopy(object, n, object2, n2, n3);
    }

    public static final int identityHashCode(Object object) {
        return VMSystem.identityHashCode(object);
    }

    public static final Properties getProperties() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return SystemProperties.getProperties();
    }

    public static final void setProperties(Properties properties) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        SystemProperties.setProperties(properties);
    }

    public static final String getProperty(String string) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.getProperty(string);
    }

    public static final String getProperty(String string, String string2) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.getProperty(string, string2);
    }

    public static final String setProperty(String string, String string2) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.setProperty(string, string2);
    }

    public static final String clearProperty(String string) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.remove(string);
    }

    public static final String getenv(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv." + string));
        }
        return VMSystem.getenv(string);
    }

    public static final void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static final void gc() {
        Runtime.getRuntime().gc();
    }

    public static final void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static final void runFinalizersOnExit(boolean bl) {
        Runtime.runFinalizersOnExit(bl);
    }

    public static final void load(String string) {
        Runtime.getRuntime().load(string, VMStackWalker.getCallingClassLoader());
    }

    public static final void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string, VMStackWalker.getCallingClassLoader());
    }

    public static final String mapLibraryName(String string) {
        return VMRuntime.mapLibraryName(string);
    }

    private System() {
    }
}

