/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class JTextPane
extends JEditorPane {
    public String getUIClassID() {
        return "TextPaneUI";
    }

    public void setDocument(Document document) {
        if (document != null && !(document instanceof StyledDocument)) {
            throw new IllegalArgumentException("JTextPane can only handle StyledDocuments");
        }
        this.setStyledDocument((StyledDocument)document);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)super.getDocument();
    }

    public void setStyledDocument(StyledDocument styledDocument) {
        super.setDocument(styledDocument);
    }

    public void replaceSelection(String string) {
        Caret caret = this.getCaret();
        StyledDocument styledDocument = this.getStyledDocument();
        AttributeSet attributeSet = this.getInputAttributes().copyAttributes();
        if (styledDocument == null) {
            return;
        }
        int n = caret.getDot();
        int n2 = caret.getMark();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        try {
            if (styledDocument instanceof AbstractDocument) {
                ((AbstractDocument)((Object)styledDocument)).replace(n3, n4 - n3, string, attributeSet);
            } else {
                if (n != n2) {
                    styledDocument.remove(n3, n4 - n3);
                }
                if (string != null && string.length() > 0) {
                    styledDocument.insertString(n3, string, attributeSet);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)"No BadLocationException should be thrown here");
        }
    }

    public void insertComponent(Component component) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.ComponentAttribute, component);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, "component");
        try {
            this.getDocument().insertString(this.getCaret().getDot(), " ", simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
    }

    public void insertIcon(Icon icon) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.IconAttribute, icon);
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, "icon");
        try {
            this.getDocument().insertString(this.getCaret().getDot(), " ", simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
    }

    public Style addStyle(String string, Style style) {
        return this.getStyledDocument().addStyle(string, style);
    }

    public void removeStyle(String string) {
        this.getStyledDocument().removeStyle(string);
    }

    public Style getStyle(String string) {
        return this.getStyledDocument().getStyle(string);
    }

    public Style getLogicalStyle() {
        return this.getStyledDocument().getLogicalStyle(this.getCaretPosition());
    }

    public void setLogicalStyle(Style style) {
        this.getStyledDocument().setLogicalStyle(this.getCaretPosition(), style);
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getCharacterElement(this.getCaretPosition());
        return element.getAttributes();
    }

    public void setCharacterAttributes(AttributeSet attributeSet, boolean bl) {
        int n = this.getCaret().getDot();
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        if (n2 == n && n3 == n) {
            MutableAttributeSet mutableAttributeSet = this.getStyledEditorKit().getInputAttributes();
            if (bl) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        } else {
            this.getStyledDocument().setCharacterAttributes(n2, n3 - n2, attributeSet, bl);
        }
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getParagraphElement(this.getCaretPosition());
        return element.getAttributes();
    }

    public void setParagraphAttributes(AttributeSet attributeSet, boolean bl) {
    }

    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    public final void setEditorKit(EditorKit editorKit) {
        if (!(editorKit instanceof StyledEditorKit)) {
            throw new IllegalArgumentException("JTextPanes can only handle StyledEditorKits");
        }
        super.setEditorKit(editorKit);
    }

    protected String paramString() {
        return super.paramString();
    }

    public JTextPane() {
    }

    public JTextPane(StyledDocument styledDocument) {
        this();
        this.setStyledDocument(styledDocument);
    }
}

