<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class SslCert extends \Google\Model
{
  /**
   * @var string
   */
  public $cert;
  /**
   * @var string
   */
  public $certSerialNumber;
  /**
   * @var string
   */
  public $commonName;
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $expirationTime;
  /**
   * @var string
   */
  public $instance;
  /**
   * @var string
   */
  public $kind;
  /**
   * @var string
   */
  public $selfLink;
  /**
   * @var string
   */
  public $sha1Fingerprint;

  /**
   * @param string
   */
  public function setCert($cert)
  {
    $this->cert = $cert;
  }
  /**
   * @return string
   */
  public function getCert()
  {
    return $this->cert;
  }
  /**
   * @param string
   */
  public function setCertSerialNumber($certSerialNumber)
  {
    $this->certSerialNumber = $certSerialNumber;
  }
  /**
   * @return string
   */
  public function getCertSerialNumber()
  {
    return $this->certSerialNumber;
  }
  /**
   * @param string
   */
  public function setCommonName($commonName)
  {
    $this->commonName = $commonName;
  }
  /**
   * @return string
   */
  public function getCommonName()
  {
    return $this->commonName;
  }
  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setExpirationTime($expirationTime)
  {
    $this->expirationTime = $expirationTime;
  }
  /**
   * @return string
   */
  public function getExpirationTime()
  {
    return $this->expirationTime;
  }
  /**
   * @param string
   */
  public function setInstance($instance)
  {
    $this->instance = $instance;
  }
  /**
   * @return string
   */
  public function getInstance()
  {
    return $this->instance;
  }
  /**
   * @param string
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param string
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * @param string
   */
  public function setSha1Fingerprint($sha1Fingerprint)
  {
    $this->sha1Fingerprint = $sha1Fingerprint;
  }
  /**
   * @return string
   */
  public function getSha1Fingerprint()
  {
    return $this->sha1Fingerprint;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SslCert::class, 'Google_Service_SQLAdmin_SslCert');
