/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontPeer;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GdkGraphics
extends Graphics {
    static final int GDK_COPY = 0;
    static final int GDK_XOR = 2;
    private final int native_state;
    Color color;
    Color xorColor;
    GtkComponentPeer component;
    Font font;
    Rectangle clip;
    GtkImage image;
    int xOffset;
    int yOffset;
    GdkGraphics cached;
    GdkGraphics parent;

    static native void initStaticState();

    native void initState(GtkComponentPeer var1);

    native void initStateUnlocked(GtkComponentPeer var1);

    native void initState(int var1, int var2);

    native void initFromImage(GtkImage var1);

    native void nativeCopyState(GdkGraphics var1);

    void initComponentGraphics() {
        this.initState(this.component);
        this.color = this.component.awtComponent.getForeground();
        if (this.color == null) {
            this.color = Color.BLACK;
        }
        Dimension dimension = this.component.awtComponent.getSize();
        this.clip = new Rectangle(0, 0, dimension.width, dimension.height);
    }

    void initComponentGraphicsUnlocked() {
        this.initStateUnlocked(this.component);
        this.color = this.component.awtComponent.getForeground();
        if (this.color == null) {
            this.color = Color.BLACK;
        }
        Dimension dimension = this.component.awtComponent.getSize();
        this.clip = new Rectangle(0, 0, dimension.width, dimension.height);
    }

    native void connectSignals(GtkComponentPeer var1);

    public native void clearRect(int var1, int var2, int var3, int var4);

    public void clipRect(int n, int n2, int n3, int n4) {
        if (this.component != null && !this.component.isRealized()) {
            return;
        }
        this.clip = this.clip.intersection(new Rectangle(n, n2, n3, n4));
        this.setClipRectangle(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public Graphics create() {
        GdkGraphics gdkGraphics = this.cached;
        if (gdkGraphics == null) {
            gdkGraphics = new GdkGraphics(this);
        } else {
            gdkGraphics.copyState(this);
            this.cached = null;
        }
        return gdkGraphics;
    }

    public native void nativeDispose();

    public void dispose() {
        if (this.parent != null) {
            this.parent.cached = this;
            this.parent = null;
        } else {
            this.nativeDispose();
        }
    }

    public void finalize() {
        super.finalize();
        this.nativeDispose();
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(null), image.getHeight(null), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image instanceof GtkImage) {
            return ((GtkImage)image).drawImage(this, n, n2, n3, n4, color, imageObserver);
        }
        return new GtkImage(image.getSource()).drawImage(this, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image instanceof GtkImage) {
            return ((GtkImage)image).drawImage(this, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
        return new GtkImage(image.getSource()).drawImage(this, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public native void drawLine(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawPolyline(int[] var1, int[] var2, int var3);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    GdkFontPeer getFontPeer() {
        return (GdkFontPeer)this.getFont().getPeer();
    }

    native void drawString(GdkFontPeer var1, String var2, int var3, int var4);

    public void drawString(String string, int n, int n2) {
        this.drawString(this.getFontPeer(), string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        throw new Error("not implemented");
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > n3) {
            n5 = n3;
        }
        if (n6 > n4) {
            n6 = n4;
        }
        int n7 = n + n3 - n5;
        int n8 = n2 + n4 - n6;
        this.drawArc(n, n2, n5, n6, 90, 90);
        this.drawArc(n7, n2, n5, n6, 0, 90);
        this.drawArc(n7, n8, n5, n6, 270, 90);
        this.drawArc(n, n8, n5, n6, 180, 90);
        int n9 = n2 + n6 / 2;
        int n10 = n2 + n4 - n6 / 2;
        this.drawLine(n, n9, n, n10);
        this.drawLine(n + n3, n9, n + n3, n10);
        int n11 = n + n5 / 2;
        int n12 = n + n3 - n5 / 2;
        this.drawLine(n11, n2, n12, n2);
        this.drawLine(n11, n2 + n4, n12, n2 + n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > n3) {
            n5 = n3;
        }
        if (n6 > n4) {
            n6 = n4;
        }
        int n7 = n + n3 - n5;
        int n8 = n2 + n4 - n6;
        this.fillArc(n, n2, n5, n6, 90, 90);
        this.fillArc(n7, n2, n5, n6, 0, 90);
        this.fillArc(n7, n8, n5, n6, 270, 90);
        this.fillArc(n, n8, n5, n6, 180, 90);
        this.fillRect(n, n2 + n6 / 2, n3, n4 - n6 + 1);
        this.fillRect(n + n5 / 2, n2, n3 - n5 + 1, n4);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    native void setClipRectangle(int var1, int var2, int var3, int var4);

    public void setClip(int n, int n2, int n3, int n4) {
        if (this.component != null && !this.component.isRealized() || this.clip == null) {
            return;
        }
        this.clip.x = n;
        this.clip.y = n2;
        this.clip.width = n3;
        this.clip.height = n4;
        this.setClipRectangle(n, n2, n3, n4);
    }

    public void setClip(Rectangle rectangle) {
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            Dimension dimension = this.component.awtComponent.getSize();
            this.setClip(new Rectangle(0, 0, dimension.width, dimension.height));
        } else {
            this.setClip(shape.getBounds());
        }
    }

    private final native void setFGColor(int var1, int var2, int var3);

    public void setColor(Color color) {
        this.color = color == null ? Color.BLACK : color;
        if (this.xorColor == null) {
            this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        } else {
            this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    native void setFunction(int var1);

    public void setPaintMode() {
        this.xorColor = null;
        this.setFunction(0);
        this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public void setXORMode(Color color) {
        this.xorColor = color;
        this.setFunction(2);
        this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
    }

    public native void translateNative(int var1, int var2);

    public void translate(int n, int n2) {
        if (this.component != null && !this.component.isRealized()) {
            return;
        }
        this.clip.x -= n;
        this.clip.y -= n2;
        this.translateNative(n, n2);
    }

    private final void copyState(GdkGraphics gdkGraphics) {
        this.color = gdkGraphics.color;
        this.xorColor = gdkGraphics.xorColor;
        this.font = gdkGraphics.font;
        if (this.font == null) {
            this.font = new Font("Dialog", 0, 12);
        }
        this.clip = new Rectangle(gdkGraphics.clip);
        this.component = gdkGraphics.component;
        this.nativeCopyState(gdkGraphics);
    }

    private final /* synthetic */ void this() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.font = new Font("Dialog", 0, 12);
        this.xOffset = 0;
        this.yOffset = 0;
        this.cached = null;
        this.parent = null;
    }

    GdkGraphics(GdkGraphics gdkGraphics) {
        this.this();
        this.parent = gdkGraphics;
        this.copyState(gdkGraphics);
    }

    GdkGraphics(int n, int n2) {
        this.this();
        this.initState(n, n2);
        this.color = Color.black;
        this.clip = new Rectangle(0, 0, n, n2);
        this.font = new Font("Dialog", 0, 12);
    }

    GdkGraphics(GtkImage gtkImage) {
        this.this();
        this.image = gtkImage;
        this.initFromImage(gtkImage);
        this.color = Color.black;
        this.clip = new Rectangle(0, 0, gtkImage.getWidth(null), gtkImage.getHeight(null));
        this.font = new Font("Dialog", 0, 12);
    }

    GdkGraphics(GtkComponentPeer gtkComponentPeer) {
        this.this();
        this.component = gtkComponentPeer;
        this.color = Color.black;
        if (gtkComponentPeer.isRealized()) {
            this.initComponentGraphics();
        } else {
            this.connectSignals(gtkComponentPeer);
        }
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkGraphics.initStaticState();
    }
}

