/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

public class CERTRecord
extends Record {
    public static final int PKIX = 1;
    public static final int SPKI = 2;
    public static final int PGP = 3;
    public static final int URI = 253;
    public static final int OID = 254;
    private int certType;
    private int keyTag;
    private int alg;
    private byte[] cert;

    Record getObject() {
        return new CERTRecord();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.certType = dNSInput.readU16();
        this.keyTag = dNSInput.readU16();
        this.alg = dNSInput.readU8();
        this.cert = dNSInput.readByteArray();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getString();
        this.certType = CertificateType.value(string);
        if (this.certType < 0) {
            throw tokenizer.exception("Invalid certificate type: " + string);
        }
        this.keyTag = tokenizer.getUInt16();
        String string2 = tokenizer.getString();
        this.alg = DNSSEC.Algorithm.value(string2);
        if (this.alg < 0) {
            throw tokenizer.exception("Invalid algorithm: " + string2);
        }
        this.cert = tokenizer.getBase64();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.certType);
        stringBuffer.append(" ");
        stringBuffer.append(this.keyTag);
        stringBuffer.append(" ");
        stringBuffer.append(this.alg);
        if (this.cert != null) {
            if (Options.check("multiline")) {
                stringBuffer.append(" (\n");
                stringBuffer.append(base64.formatString(this.cert, 64, "\t", true));
            } else {
                stringBuffer.append(" ");
                stringBuffer.append(base64.toString(this.cert));
            }
        }
        return stringBuffer.toString();
    }

    public int getCertType() {
        return this.certType;
    }

    public int getKeyTag() {
        return this.keyTag;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.certType);
        dNSOutput.writeU16(this.keyTag);
        dNSOutput.writeU8(this.alg);
        dNSOutput.writeByteArray(this.cert);
    }

    CERTRecord() {
    }

    public CERTRecord(Name name, int n, long l, int n2, int n3, int n4, byte[] byArray) {
        super(name, 37, n, l);
        this.certType = CERTRecord.checkU16("certType", n2);
        this.keyTag = CERTRecord.checkU16("keyTag", n3);
        this.alg = CERTRecord.checkU8("alg", n4);
        this.cert = byArray;
    }

    public static class CertificateType {
        public static final int PKIX = 1;
        public static final int SPKI = 2;
        public static final int PGP = 3;
        public static final int URI = 253;
        public static final int OID = 254;
        private static Mnemonic types = new Mnemonic("Certificate type", 2);

        public static String string(int n) {
            return types.getText(n);
        }

        public static int value(String string) {
            return types.getValue(string);
        }

        private CertificateType() {
        }

        static {
            types.setMaximum((char)-1);
            types.setNumericAllowed(true);
            types.add(1, "PKIX");
            types.add(2, "SPKI");
            types.add(3, "PGP");
            types.add(253, "URI");
            types.add(254, "OID");
        }
    }
}

