#    Jools -- a graphical puzzle game in the Tetris tradition
#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# intro.py
#
# Provide an introductory screen, with options for configuring the
# type of game, starting the game, viewing high scores, etc.
#

import pygame
from initialize import *
from globals import *
import highscore, options


# Display the main menu.
def displayMenu():

   pygame.mouse.set_visible(1)

   # clean up the background
   screen.blit(background, (0,100), (0,100,640,380))

   # draw the buttons
   timeTrialButtonRect.left = 10
   timeTrialButtonRect.top  = 120
   untimedButtonRect.left   = 300
   untimedButtonRect.top    = 160
   scoresButtonRect.left    = 90
   scoresButtonRect.top     = 250
   optionsButtonRect.left   = 380
   optionsButtonRect.top    = 290
   quitButtonRect.left      = 10
   quitButtonRect.top       = 370
   screen.blit(timeTrialButton, timeTrialButtonRect)
   screen.blit(untimedButton, untimedButtonRect)
   screen.blit(scoresButton, scoresButtonRect)
   screen.blit(optionsButton, optionsButtonRect)
   screen.blit(quitButton, quitButtonRect)

   # show the version info and credits
   versionText = authorFont.render("Jools v"+VERSION, 1, (0,232,3), (1,1,1) )
   authorText  = authorFont.render("written by Paul Pelzl", 1, (0,232,3), (1,1,1) )
   vRect = versionText.get_rect()
   aRect = authorText.get_rect()

   screen.blit(versionText, (630-aRect.width, 480-aRect.height-vRect.height) )
   screen.blit(authorText, (630-aRect.width, 480-aRect.height) )

   pygame.display.update()
   pygame.display.flip()



def showIntro():
   displayMenu()

   timeTrialButtonIsOn = 0
   untimedButtonIsOn   = 0
   scoresButtonIsOn    = 0
   optionsButtonIsOn   = 0
   quitButtonIsOn      = 0

   # Process clicks
   oldMousePressed = 0
   while 1:
      mousePressed = pygame.mouse.get_pressed()[0]
      mousePos = pygame.mouse.get_pos()
      if oldMousePressed and not mousePressed:
         if timeTrialButtonRect.collidepoint(mousePos[0],mousePos[1]):
            screen.blit(background, (0,100), (0,100,640,380))
            pygame.display.update()
            pygame.display.flip()
            return 1 # timeTrial == 1
         elif untimedButtonRect.collidepoint(mousePos[0],mousePos[1]):
            screen.blit(background, (0,100), (0,100,640,380))
            pygame.display.update()
            pygame.display.flip()
            return 0 # timeTrial == 0
         elif scoresButtonRect.collidepoint(mousePos[0],mousePos[1]):
            highscore.showScores()
            clickable = 0
            displayMenu()
         elif optionsButtonRect.collidepoint(mousePos[0],mousePos[1]):
            options.showOptions()
            clickable = 0
            displayMenu()
         elif quitButtonRect.collidepoint(mousePos[0],mousePos[1]):
            options.saveOptions()
            pygame.quit()
            sys.exit("Exiting Jools...")

      if mousePressed:
         if timeTrialButtonRect.collidepoint(mousePos[0], mousePos[1]):
            timeTrialButtonIsOn = 1
            screen.blit(timeTrialButtonOn, timeTrialButtonRect)
            pygame.display.update(timeTrialButtonRect)
         elif untimedButtonRect.collidepoint(mousePos[0], mousePos[1]):
            untimedButtonIsOn = 1
            screen.blit(untimedButtonOn, untimedButtonRect)
            pygame.display.flip()
            pygame.display.update(untimedButtonRect)
         elif scoresButtonRect.collidepoint(mousePos[0], mousePos[1]):
            scoresButtonIsOn = 1
            screen.blit(scoresButtonOn, scoresButtonRect)
            pygame.display.update(scoresButtonRect)
         elif optionsButtonRect.collidepoint(mousePos[0], mousePos[1]):
            optionsButtonIsOn = 1
            screen.blit(optionsButtonOn, optionsButtonRect)
            pygame.display.update(optionsButtonRect)
         elif quitButtonRect.collidepoint(mousePos[0], mousePos[1]):
            quitButtonIsOn = 1
            screen.blit(quitButtonOn, quitButtonRect)
            pygame.display.update(quitButtonRect)

      if timeTrialButtonIsOn and (not mousePressed or not 
            timeTrialButtonRect.collidepoint(mousePos[0], mousePos[1])):
         timeTrialButtonIsOn = 0
         screen.blit(timeTrialButton, timeTrialButtonRect)
         pygame.display.update(timeTrialButtonRect)
      if untimedButtonIsOn and (not mousePressed or not 
            untimedButtonRect.collidepoint(mousePos[0], mousePos[1])):
         untimedButtonIsOn = 0
         screen.blit(untimedButton, untimedButtonRect)
         pygame.display.update(untimedButtonRect)
      if scoresButtonIsOn and (not mousePressed or not 
            scoresButtonRect.collidepoint(mousePos[0], mousePos[1])):
         scoresButtonIsOn = 0
         screen.blit(scoresButton, scoresButtonRect)
         pygame.display.update(scoresButtonRect)
      if optionsButtonIsOn and (not mousePressed or not 
            optionsButtonRect.collidepoint(mousePos[0], mousePos[1])):
         optionsButtonIsOn = 0
         screen.blit(optionsButton, optionsButtonRect)
         pygame.display.update(optionsButtonRect)
      if quitButtonIsOn and (not mousePressed or not 
            quitButtonRect.collidepoint(mousePos[0], mousePos[1])):
         quitButtonIsOn = 0
         screen.blit(quitButton, quitButtonRect)
         pygame.display.update(quitButtonRect)


      oldMousePressed = mousePressed

      pygame.event.pump()
      if pygame.event.wait().type == QUIT:
         options.saveOptions()
         pygame.quit()
         sys.exit("Exiting Jools...")


# pjp: leaving this off for the time being... seems unnecessary
#
#      # djk: handle minimization during menu
#      if pygame.event.peek(ACTIVEEVENT):
#         evtList = pygame.event.get(ACTIVEEVENT)
#         for evt in evtList:
#            #print( evt.dict )
#            if( (evt.state == 6) and (evt.gain == 0) ):
#               pygame.mixer.music.pause()
#            elif( evt.state == 6 and evt.gain == 1 ):
#               pygame.mixer.music.unpause()



# arch-tag: main menu
