/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralNames {
    public static final int OTHER_NAME = 0;
    public static final int RFC822_NAME = 1;
    public static final int DNS_NAME = 2;
    public static final int X400_ADDRESS = 3;
    public static final int DIRECTORY_NAME = 4;
    public static final int EDI_PARTY_NAME = 5;
    public static final int URI = 6;
    public static final int IP_ADDRESS = 7;
    public static final int REGISTERED_ID = 8;
    private List names = new LinkedList();
    static /* synthetic */ Class class$gnu$java$security$x509$ext$GeneralNames;

    public List getNames() {
        ArrayList arrayList = new ArrayList(this.names.size());
        Iterator iterator = this.names.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            ArrayList arrayList2 = new ArrayList(2);
            arrayList2.add(list2.get(0));
            if (list2.get(1) instanceof byte[]) {
                arrayList2.add(((byte[])list2.get(1)).clone());
            } else {
                arrayList2.add(list2.get(1));
            }
            arrayList.add(Collections.unmodifiableList(arrayList2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$java$security$x509$ext$GeneralNames;
        if (clazz == null) {
            clazz = class$gnu$java$security$x509$ext$GeneralNames = GeneralNames.class("[Lgnu.java.security.x509.ext.GeneralNames;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ ").append(this.names).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public GeneralNames(byte[] byArray) throws IOException {
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed GeneralNames");
        }
        int n = 0;
        boolean bl = false;
        while (n < dERValue.getLength()) {
            DERValue dERValue2 = dERReader.read();
            ArrayList arrayList = new ArrayList(2);
            int n2 = dERValue2.getTagClass();
            if (n2 != 128) {
                throw new IOException("malformed GeneralName: Tag class is " + n2);
            }
            arrayList.add(new Integer(dERValue2.getTag()));
            Object var9_9 = null;
            switch (dERValue2.getTag()) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    arrayList.add(new String((byte[])dERValue2.getValue()));
                    break;
                }
                case 0: {
                    byte[] byArray2 = dERValue2.getEncoded();
                    byArray2[0] = 48;
                    arrayList.add(byArray2);
                    DERValue dERValue3 = dERReader.read();
                    dERValue3 = dERReader.read();
                    break;
                }
                case 5: {
                    arrayList.add(dERValue2.getValue());
                    break;
                }
                case 4: {
                    byte[] byArray3 = dERValue2.getEncoded();
                    byArray3[0] = 48;
                    DERReader dERReader2 = new DERReader(byArray3);
                    dERReader2.read();
                    arrayList.add(new X500Principal(dERReader2.read().getEncoded()).toString());
                    break;
                }
                case 7: {
                    arrayList.add(InetAddress.getByAddress((byte[])dERValue2.getValue()).getHostAddress());
                    break;
                }
                case 8: {
                    byte[] byArray4 = dERValue2.getEncoded();
                    byArray4[0] = 6;
                    arrayList.add(new OID(byArray4).toString());
                    break;
                }
                default: {
                    throw new IOException("unknown tag " + dERValue2.getTag());
                }
            }
            this.names.add(arrayList);
            n += dERValue2.getEncodedLength();
        }
    }
}

