/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.java.util.prefs.EventDispatcher;
import gnu.java.util.prefs.NodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractPreferences
extends Preferences {
    protected final Object lock;
    protected boolean newNode;
    private final AbstractPreferences parent;
    private final String name;
    private boolean removed;
    private HashMap childCache;
    private ArrayList nodeListeners;
    private ArrayList preferenceListeners;

    public String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        return this.parent.path() + '/' + this.name;
    }

    private final String path() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.path() + '/' + this.name;
    }

    public boolean isUserNode() {
        AbstractPreferences abstractPreferences = this;
        while (abstractPreferences.parent != null) {
            abstractPreferences = abstractPreferences.parent;
        }
        boolean bl = false;
        if (abstractPreferences == Preferences.userRoot()) {
            bl = true;
        }
        return bl;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    protected final AbstractPreferences[] cachedChildren() {
        return (AbstractPreferences[])this.childCache.values().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            TreeSet treeSet = new TreeSet();
            treeSet.addAll(this.childCache.keySet());
            String[] stringArray = this.childrenNamesSpi();
            int n = 0;
            while (n < stringArray.length) {
                treeSet.add(stringArray[n]);
                ++n;
            }
            Object[] objectArray = new String[treeSet.size()];
            treeSet.toArray(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Preferences node(String string) {
        Preferences preferences;
        block9: {
            block7: {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isRemoved()) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (!string.startsWith("/")) {
                        if (string.indexOf("//") == -1 && !string.endsWith("/")) {
                            return this.getNode(string);
                        }
                        throw new IllegalArgumentException(string);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (!this.isUserNode()) break block7;
                }
                preferences = AbstractPreferences.userRoot();
                break block9;
            }
            preferences = AbstractPreferences.systemRoot();
        }
        Preferences preferences2 = preferences;
        return preferences2.node(string.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Preferences getNode(String string) {
        String string2;
        String string3;
        if (string.length() == 0) {
            return this;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        AbstractPreferences abstractPreferences = (AbstractPreferences)this.childCache.get(string3);
        if (abstractPreferences == null) {
            if (string3.length() > 80) {
                throw new IllegalArgumentException(string3);
            }
            abstractPreferences = this.childSpi(string3);
            this.childCache.put(string3, abstractPreferences);
            if (abstractPreferences.newNode && this.nodeListeners != null) {
                this.fire(new NodeChangeEvent(this, abstractPreferences), true);
            }
        }
        Object object = abstractPreferences.lock;
        synchronized (object) {
            return abstractPreferences.getNode(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean nodeExists(String string) throws BackingStoreException {
        Preferences preferences;
        block9: {
            block7: {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isRemoved() && string.length() != 0) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (!string.startsWith("/")) {
                        if (string.indexOf("//") == -1 && !string.endsWith("/")) {
                            return this.existsNode(string);
                        }
                        throw new IllegalArgumentException(string);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (!this.isUserNode()) break block7;
                }
                preferences = AbstractPreferences.userRoot();
                break block9;
            }
            preferences = AbstractPreferences.systemRoot();
        }
        Preferences preferences2 = preferences;
        return preferences2.nodeExists(string.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean existsNode(String string) throws BackingStoreException {
        String string2;
        String string3;
        if (string.length() == 0) {
            return this.isRemoved() ^ true;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        AbstractPreferences abstractPreferences = (AbstractPreferences)this.childCache.get(string3);
        if (abstractPreferences == null) {
            if (string3.length() > 80) {
                throw new IllegalArgumentException(string3);
            }
            abstractPreferences = this.getChild(string3);
            if (abstractPreferences == null) {
                return false;
            }
            this.childCache.put(string3, abstractPreferences);
        }
        Object object = abstractPreferences.lock;
        synchronized (object) {
            return abstractPreferences.existsNode(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractPreferences getChild(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] stringArray = this.childrenNamesSpi();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return this.childSpi(string);
                }
                ++n;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.parent;
        }
    }

    public void exportNode(OutputStream outputStream) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter(this, outputStream);
        nodeWriter.writePrefs();
    }

    public void exportSubtree(OutputStream outputStream) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter(this, outputStream);
        nodeWriter.writePrefsTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.keysSpi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String string, String string2) {
        if (string.length() > 80) {
            throw new IllegalArgumentException(string);
        }
        Object object = this.lock;
        synchronized (object) {
            String string3;
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            try {
                string3 = this.getSpi(string);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                string3 = null;
            }
            if (string3 != null) {
                return string3;
            }
            return string2;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string, null);
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        String string2 = this.get(string, null);
        byte[] byArray2 = null;
        if (string2 != null) {
            byArray2 = AbstractPreferences.decode64(string2);
        }
        if (byArray2 != null) {
            return byArray2;
        }
        return byArray;
    }

    private static final byte[] decode64(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() / 4 * 3);
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = -1;
        int n2 = 0;
        while (n2 < cArray.length && n == -1) {
            if (cArray[n2] >= 'A' && cArray[n2] <= 'Z') {
                int n3 = n2;
                cArray[n3] = (char)(cArray[n3] - 65);
            } else if (cArray[n2] >= 'a' && cArray[n2] <= 'z') {
                cArray[n2] = (char)(cArray[n2] + 26 - 97);
            } else if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                cArray[n2] = (char)(cArray[n2] + 52 - 48);
            } else if (cArray[n2] == '+') {
                cArray[n2] = 62;
            } else if (cArray[n2] == '/') {
                cArray[n2] = 63;
            } else if (cArray[n2] == '=') {
                n = n2;
            } else {
                return null;
            }
            ++n2;
        }
        n2 = n == -1 ? cArray.length : n;
        int n4 = 0;
        while (n2 > 0) {
            byte by;
            byte by2 = (byte)(cArray[n4] << 2);
            if (n2 >= 2) {
                by2 = (byte)(by2 + ((cArray[n4 + 1] & 0x30) >> 4));
            }
            byteArrayOutputStream.write(by2);
            if (n2 >= 3) {
                by = (byte)((cArray[n4 + 1] & 0xF) << 4);
                by = (byte)(by + (byte)((cArray[n4 + 2] & 0x3C) >> 2));
                byteArrayOutputStream.write(by);
            }
            if (n2 >= 4) {
                by = (byte)((cArray[n4 + 2] & 3) << 6);
                by = (byte)(by + cArray[n4 + 3]);
                byteArrayOutputStream.write(by);
            }
            n4 += 4;
            n2 -= 4;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public double getDouble(String string, double d) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d;
    }

    public float getFloat(String string, float f) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f;
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public long getLong(String string, long l) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String string, String string2) {
        if (string.length() > 80 || string2.length() > 8192) {
            throw new IllegalArgumentException("key (" + string.length() + ") or value (" + string2.length() + ") to large");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.putSpi(string, string2);
            if (this.preferenceListeners != null) {
                this.fire(new PreferenceChangeEvent(this, string, string2));
            }
            return;
        }
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, Boolean.toString(bl));
    }

    public void putByteArray(String string, byte[] byArray) {
        this.put(string, AbstractPreferences.encode64(byArray));
    }

    private static final String encode64(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length / 3 * 4);
        int n = 0;
        int n2 = byArray.length;
        char[] cArray = new char[4];
        while (n2 > 0) {
            cArray[0] = (char)((byArray[n] & 0xFC) >> 2);
            cArray[1] = (char)((byArray[n] & 3) << 4);
            if (n2 >= 2) {
                cArray[1] = (char)(cArray[1] + (char)((byArray[n + 1] & 0xF0) >> 4));
                cArray[2] = (char)((byArray[n + 1] & 0xF) << 2);
                if (n2 >= 3) {
                    cArray[2] = (char)(cArray[2] + (char)((byArray[n + 2] & 0xC0) >> 6));
                    cArray[3] = (char)(byArray[n + 2] & 0x3F);
                } else {
                    cArray[3] = 64;
                }
            } else {
                cArray[2] = 64;
                cArray[3] = 64;
            }
            int n3 = 0;
            while (n3 < 4) {
                if (cArray[n3] < '\u001a') {
                    int n4 = n3;
                    cArray[n4] = (char)(cArray[n4] + 65);
                } else {
                    cArray[n3] = cArray[n3] < '4' ? (int)(cArray[n3] - 26 + 97) : (cArray[n3] < '>' ? (int)(cArray[n3] - 52 + 48) : (cArray[n3] == '>' ? 43 : (cArray[n3] == '?' ? 47 : 61)));
                }
                ++n3;
            }
            stringBuffer.append(cArray);
            n += 3;
            n2 -= 3;
        }
        return stringBuffer.toString();
    }

    public void putDouble(String string, double d) {
        this.put(string, Double.toString(d));
    }

    public void putFloat(String string, float f) {
        this.put(string, Float.toString(f));
    }

    public void putInt(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void putLong(String string, long l) {
        this.put(string, Long.toString(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String string) {
        if (string.length() > 80) {
            throw new IllegalArgumentException(string);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.removeSpi(string);
            if (this.preferenceListeners != null) {
                this.fire(new PreferenceChangeEvent(this, string, null));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node Removed");
            }
            String[] stringArray = this.keys();
            int n = 0;
            while (n < stringArray.length) {
                this.removeSpi(stringArray[n]);
                ++n;
            }
            return;
        }
    }

    public void flush() throws BackingStoreException {
        this.flushNode(false);
    }

    public void sync() throws BackingStoreException {
        this.flushNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void flushNode(boolean bl) throws BackingStoreException {
        String[] stringArray;
        block8: {
            block7: {
                stringArray = null;
                Object object = this.lock;
                // MONITORENTER : object
                if (!bl) break block7;
                this.syncSpi();
                break block8;
            }
            this.flushSpi();
        }
        stringArray = (String[])this.childCache.keySet().toArray(new String[0]);
        // MONITOREXIT : object
        if (stringArray == null) return;
        int n = 0;
        while (n < stringArray.length) {
            block9: {
                AbstractPreferences abstractPreferences;
                Object object = this.lock;
                // MONITORENTER : object
                {
                    abstractPreferences = (AbstractPreferences)this.childCache.get(stringArray[n]);
                    // MONITOREXIT : object
                    if (abstractPreferences == null) break block9;
                }
                abstractPreferences.flushNode(bl);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove root node");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node Removed");
                }
                this.purge();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var3_2
                this.parent.childCache.remove(this.name);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void purge() throws BackingStoreException {
        String[] stringArray = this.childrenNamesSpi();
        int n = 0;
        while (n < stringArray.length) {
            if (this.childCache.get(stringArray[n]) == null) {
                this.childCache.put(stringArray[n], this.childSpi(stringArray[n]));
            }
            ++n;
        }
        Iterator iterator = this.childCache.values().iterator();
        while (iterator.hasNext()) {
            AbstractPreferences abstractPreferences = (AbstractPreferences)iterator.next();
            Object object = abstractPreferences.lock;
            synchronized (object) {
                abstractPreferences.purge();
            }
        }
        this.childCache.clear();
        this.removeNodeSpi();
        this.removed = true;
        if (this.nodeListeners != null) {
            this.fire(new NodeChangeEvent(this.parent, this), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (nodeChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.nodeListeners == null) {
                this.nodeListeners = new ArrayList();
            }
            this.nodeListeners.add(nodeChangeListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (preferenceChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.preferenceListeners == null) {
                this.preferenceListeners = new ArrayList();
            }
            this.preferenceListeners.add(preferenceChangeListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (nodeChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.nodeListeners != null) {
                this.nodeListeners.remove(nodeChangeListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (preferenceChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.preferenceListeners != null) {
                this.preferenceListeners.remove(preferenceChangeListener);
            }
            return;
        }
    }

    private final void fire(final PreferenceChangeEvent preferenceChangeEvent) {
        Iterator iterator = this.preferenceListeners.iterator();
        while (iterator.hasNext()) {
            final PreferenceChangeListener preferenceChangeListener = (PreferenceChangeListener)iterator.next();
            EventDispatcher.dispatch(new Runnable(){

                public final void run() {
                    preferenceChangeListener.preferenceChange(preferenceChangeEvent);
                }
            });
        }
    }

    private final void fire(final NodeChangeEvent nodeChangeEvent, final boolean bl) {
        Iterator iterator = this.nodeListeners.iterator();
        while (iterator.hasNext()) {
            final NodeChangeListener nodeChangeListener = (NodeChangeListener)iterator.next();
            EventDispatcher.dispatch(new Runnable(){

                public final void run() {
                    if (bl) {
                        nodeChangeListener.childAdded(nodeChangeEvent);
                    } else {
                        nodeChangeListener.childRemoved(nodeChangeEvent);
                    }
                }
            });
        }
    }

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    protected abstract AbstractPreferences childSpi(String var1);

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String getSpi(String var1);

    protected abstract void putSpi(String var1, String var2);

    protected abstract void removeSpi(String var1);

    protected abstract void flushSpi() throws BackingStoreException;

    protected abstract void syncSpi() throws BackingStoreException;

    protected abstract void removeNodeSpi() throws BackingStoreException;

    private final /* synthetic */ void this() {
        this.lock = new Object();
        this.newNode = false;
        this.removed = false;
        this.childCache = new HashMap();
    }

    protected AbstractPreferences(AbstractPreferences abstractPreferences, String string) {
        this.this();
        if (string == null || string.length() > 80 || abstractPreferences == null && string.length() != 0 || abstractPreferences != null && string.length() == 0 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Illegal name argument '" + string + "' (parent is " + (abstractPreferences == null ? "" : "not ") + "null)");
        }
        this.parent = abstractPreferences;
        this.name = string;
    }
}

