/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalToggleButtonUI
extends BasicToggleButtonUI {
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalToggleButtonUI();
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled() && abstractButton.isOpaque()) {
            Color color = graphics.getColor();
            Rectangle rectangle = SwingUtilities.getLocalBounds(abstractButton);
            graphics.setColor(this.selectColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(jComponent.getFont());
        if (jComponent.isEnabled()) {
            graphics.setColor(jComponent.getForeground());
        } else {
            graphics.setColor(this.disabledTextColor);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(jComponent.getFont());
        int n = fontMetrics.getAscent();
        graphics.drawString(string, rectangle.x, rectangle.y + n);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (!abstractButton.hasFocus()) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(this.focusColor);
        Rectangle rectangle4 = rectangle3.union(rectangle2);
        graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
        graphics.setColor(color);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque() && UIManager.get(this.getPropertyPrefix() + "gradient") != null) {
            MetalUtils.paintGradient(graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), 1, this.getPropertyPrefix() + "gradient");
            this.paint(graphics, jComponent);
        } else {
            super.update(graphics, jComponent);
        }
    }
}

