/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    protected Object lock;

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        return n > 0 ? cArray[0] : -1;
    }

    public abstract void close() throws IOException;

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public boolean ready() throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = l > 1024L ? 1024 : (int)l;
        char[] cArray = new char[n];
        long l2 = l;
        Object object = this.lock;
        synchronized (object) {
            int n2;
            while (l2 > 0L && (n2 = this.read(cArray, 0, (long)n > l2 ? (int)l2 : n)) > 0) {
                l2 -= (long)n2;
            }
            return l - l2;
        }
    }

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object object) {
        this.lock = object;
    }
}

