/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ALNumberField
extends ALAbstractField {
    private static final long serialVersionUID = 1154944827686497611L;
    protected boolean limitValue = false;
    protected long minValue = Long.MIN_VALUE;
    protected long maxValue = Long.MAX_VALUE;
    protected String value = null;

    public ALNumberField() {
    }

    public ALNumberField(long value) {
        this.setValue(value);
    }

    public ALNumberField(String str) {
        this.setValue(str);
    }

    public void setValue(long value) {
        this.value = Long.toString(value);
    }

    @Override
    public void setValue(String str) {
        if (str == null) {
            this.value = null;
            return;
        }
        this.value = str.trim();
    }

    public long getValue() {
        long longValue = 0L;
        if (this.isNumberValue()) {
            try {
                longValue = Long.valueOf(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return longValue;
    }

    public int getValueWithInt() {
        int value = 0;
        if (this.isNumberValue()) {
            try {
                value = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public String getValueAsString() {
        return this.value;
    }

    public boolean isLimitValue() {
        return this.limitValue;
    }

    public void limitValue(long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException();
        }
        this.minValue = min;
        this.maxValue = max;
        this.limitValue = true;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void limitMinValue(long min) {
        if (this.getMaxValue() < min) {
            throw new IllegalArgumentException();
        }
        this.minValue = min;
        this.limitValue = true;
    }

    public void limitMaxValue(long max) {
        if (max < this.getMinValue()) {
            throw new IllegalArgumentException();
        }
        this.maxValue = max;
        this.limitValue = true;
    }

    public boolean validate(List<String> msgList) {
        if (msgList == null) {
            msgList = new ArrayList<String>();
        }
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NAME_SPAN", this.fieldName));
                return false;
            }
        } else {
            if (!this.isNumberValue()) {
                msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_CORRECT_NUMBER_CAUTION_SPAN", this.fieldName));
                return false;
            }
            if (this.isLimitValue()) {
                long longValue = this.getValue();
                if (longValue < this.getMinValue()) {
                    msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NUMBER_CAUTION_LESS", this.fieldName, this.getMinValue()));
                    return false;
                }
                if (longValue > this.getMaxValue()) {
                    msgList.add(ALLocalizationUtils.getl10nFormat("COMMONS_FIELD_INPUT_NUMBER_CAUTION_OVER", this.fieldName, this.getMaxValue()));
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isNotNullValue() {
        return this.value != null && this.value.trim().length() > 0;
    }

    protected boolean isNumberValue() {
        if (this.value == null) {
            return false;
        }
        try {
            int len = this.value.length();
            for (int i = 0; i < len; ++i) {
                byte[] chars = Character.valueOf(this.value.charAt(i)).toString().getBytes("shift_jis");
                if (chars.length <= 1) continue;
                return false;
            }
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        try {
            Long.valueOf(this.value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public String toString() {
        return ALStringUtil.sanitizing(this.value);
    }
}

