/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.utils;

import com.aimluck.eip.util.ALLocalizationUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ALDateUtil {
    protected static final String DEFAULT_DATE_FORMAT = "yyyy'/'M'/'d";

    public static Calendar dateToCalendar(String strDate) {
        return ALDateUtil.dateToCalendar(strDate.substring(0, 4), strDate.substring(4, 6), strDate.substring(6, 8), false);
    }

    public static Calendar dateToCalendar(String strYear, String strMonth, String strDay, boolean b) {
        int day;
        int month;
        int year;
        try {
            year = Integer.parseInt(strYear);
            month = Integer.parseInt(strMonth) - 1;
            day = Integer.parseInt(strDay);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setLenient(b);
        cal.set(year, month, day, 0, 0, 0);
        cal.set(14, 0);
        return cal;
    }

    public static String formatDate(int year, int month, int day) {
        return ALDateUtil.formatDate(String.valueOf(year), String.valueOf(month), String.valueOf(day));
    }

    public static String formatDate(String strYear, String strMonth, String strDay) {
        Calendar cal = ALDateUtil.dateToCalendar(strYear, strMonth, strDay, false);
        if (cal == null) {
            return null;
        }
        try {
            cal.getTime();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return ALDateUtil.formatCalendarDate(cal);
    }

    public static String formatCalendarDate(Calendar cal) {
        return ALDateUtil.getStringYear(cal) + ALDateUtil.getStringMonth(cal) + ALDateUtil.getStringDay(cal);
    }

    public static String getStringYear(Calendar cal) {
        Object[] args = new Object[]{cal.get(1)};
        return MessageFormat.format("{0,number,0000}", args);
    }

    public static String getStringMonth(Calendar cal) {
        return ALDateUtil.getStringMonth(cal.get(2));
    }

    public static String getStringMonth(int month) {
        switch (month) {
            case 0: {
                return "01";
            }
            case 1: {
                return "02";
            }
            case 2: {
                return "03";
            }
            case 3: {
                return "04";
            }
            case 4: {
                return "05";
            }
            case 5: {
                return "06";
            }
            case 6: {
                return "07";
            }
            case 7: {
                return "08";
            }
            case 8: {
                return "09";
            }
            case 9: {
                return "10";
            }
            case 10: {
                return "11";
            }
            case 11: {
                return "12";
            }
        }
        return null;
    }

    public static String getStringDay(Calendar cal) {
        Object[] args = new Object[]{cal.get(5)};
        return MessageFormat.format("{0,number,00}", args);
    }

    public static String getDayOfWeek(Calendar cal) {
        String res = "";
        switch (cal.get(7)) {
            case 1: {
                res = ALLocalizationUtils.getl10n("COMMONS_UTILS_SUNDAY_CELL");
                break;
            }
            case 2: {
                res = ALLocalizationUtils.getl10n("COMMONS_UTILS_MONDAY_CELL");
                break;
            }
            case 3: {
                res = ALLocalizationUtils.getl10n("COMMONS_UTILS_TUSEDAY_CELL");
                break;
            }
            case 4: {
                res = ALLocalizationUtils.getl10n("COMMONS_UTILS_WEDNESDAY_CELL");
                break;
            }
            case 5: {
                res = ALLocalizationUtils.getl10n("COMMONS_UTILS_THURSDAY_CELL");
                break;
            }
            case 6: {
                res = ALLocalizationUtils.getl10n("COMMONS_UTILS_FRIDAY_CELL");
                break;
            }
            case 7: {
                res = ALLocalizationUtils.getl10n("COMMONS_UTILS_SATURDAY_CELL");
                break;
            }
            default: {
                return null;
            }
        }
        return res;
    }

    public static String format(Date date) {
        return ALDateUtil.format(date, null);
    }

    public static String format(Date date, String strFormat) {
        int day;
        int month;
        int year;
        String formatStr = null;
        if (date == null) {
            return "";
        }
        if (strFormat == null) {
            strFormat = DEFAULT_DATE_FORMAT;
        }
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            year = calendar.get(1);
            month = calendar.get(2) + 1;
            day = calendar.get(5);
        }
        catch (Throwable ex) {
            year = 0;
            month = 0;
            day = 0;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(strFormat);
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
        try {
            calendar.setLenient(false);
            formatStr = formatter.format(calendar.getTime());
        }
        catch (Exception ex) {
            formatStr = "";
        }
        return formatStr;
    }
}

