/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALHoliday;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class ALEipHolidaysManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEipHolidaysManager.class.getName());
    protected static final String KEY_ENCODING = "content.defaultencoding";
    private static ALEipHolidaysManager manager = new ALEipHolidaysManager();
    private final String FILE_HOLI_DAYS_DEFAULT = JetspeedResources.getString((String)"aipo.home", (String)"").equals("") ? "" : JetspeedResources.getString((String)"aipo.home", (String)"") + File.separator + "conf" + File.separator + "holidays_default.properties";
    private final String FILE_HOLI_DAYS_USER = JetspeedResources.getString((String)"aipo.home", (String)"").equals("") ? "" : JetspeedResources.getString((String)"aipo.home", (String)"") + File.separator + "conf" + File.separator + "holidays_user.properties";
    private Map<String, ALHoliday> defaultHolidays = new HashMap<String, ALHoliday>();
    private Map<String, ALHoliday> userHolidays = new HashMap<String, ALHoliday>();

    private ALEipHolidaysManager() {
        this.loadHolidays();
    }

    public static ALEipHolidaysManager getInstance() {
        return manager;
    }

    public ALHoliday isHoliday(Date date) {
        if (date == null) {
            return null;
        }
        ALHoliday holiDay = null;
        holiDay = this.isHoliday(this.userHolidays, date);
        if (holiDay == null) {
            holiDay = this.isHoliday(this.defaultHolidays, date);
        }
        return holiDay;
    }

    private ALHoliday isHoliday(Map<String, ALHoliday> list, Date date) {
        String key = new SimpleDateFormat("yyyy-MM-dd").format(date);
        return list.get(key);
    }

    private void loadHolidays() {
        File defaultFile = new File(this.FILE_HOLI_DAYS_DEFAULT);
        File userFile = new File(this.FILE_HOLI_DAYS_USER);
        this.defaultHolidays.clear();
        this.userHolidays.clear();
        BufferedReader reader = null;
        try {
            if (defaultFile.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(defaultFile), ALEipConstants.DEF_CONTENT_ENCODING));
                this.loadHoliday(reader, this.defaultHolidays);
            }
            if (userFile.exists()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(userFile), ALEipConstants.DEF_CONTENT_ENCODING));
                this.loadHoliday(reader, this.userHolidays);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipHolidaysManager.loadHolidays", (Throwable)ex);
            return;
        }
    }

    private void loadHoliday(BufferedReader reader, Map<String, ALHoliday> list) throws Exception {
        if (reader == null) {
            return;
        }
        ArrayList<String> dummyList = new ArrayList<String>();
        StringTokenizer st = null;
        ALHoliday holiDay = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            String dayStr;
            String nameStr;
            if (line.startsWith("#") || (st = new StringTokenizer(line, ",")).countTokens() != 2 || !(holiDay = new ALHoliday(nameStr = st.nextToken(), dayStr = st.nextToken())).getDay().validate(dummyList)) continue;
            String key = new SimpleDateFormat("yyyy-MM-dd").format(holiDay.getDay().getValue().getDate());
            list.put(key, holiDay);
        }
    }

    protected Comparator<ALHoliday> getHolidaysComparator() {
        Comparator<ALHoliday> com = new Comparator<ALHoliday>(){

            @Override
            public int compare(ALHoliday obj0, ALHoliday obj1) {
                int ret = 0;
                try {
                    Date day0 = obj0.getDay().getValue().getDate();
                    Date day1 = obj1.getDay().getValue().getDate();
                    ret = day0.compareTo(day1);
                    if (ret == 0) {
                        String name0 = obj0.getName().getValue();
                        String name1 = obj1.getName().getValue();
                        ret = name0.compareTo(name1);
                    }
                }
                catch (RuntimeException ex) {
                    logger.error((Object)"ALEipHolidaysManager.getHolidaysComparator", (Throwable)ex);
                    return -1;
                }
                catch (Exception ex) {
                    logger.error((Object)"ALEipHolidaysManager.getHolidaysComparator", (Throwable)ex);
                    return -1;
                }
                return ret;
            }
        };
        return com;
    }
}

