/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.filter;

import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.http.HttpServletResponseLocator;
import com.aimluck.eip.http.ServletContextLocator;
import com.aimluck.eip.orm.Database;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.ServletUtil;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALBaseFilter
implements Filter {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALBaseFilter.class.getName());
    private FilterConfig filterConfig;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ServletContext prevServletContext = ServletContextLocator.get();
        HttpServletRequest prevHttpServletRequest = HttpServletRequestLocator.get();
        HttpServletResponse prevHttpServletResponse = HttpServletResponseLocator.get();
        try {
            DataContext dataContext = null;
            try {
                dataContext = Database.createDataContext(this.getCurrentOrgId((HttpServletRequest)request, (HttpServletResponse)response));
            }
            catch (Exception e) {
                logger.error((Object)"ALBaseFilter.doFilter", (Throwable)e);
            }
            ServletContextLocator.set(this.filterConfig.getServletContext());
            HttpServletRequestLocator.set((HttpServletRequest)request);
            HttpServletResponseLocator.set((HttpServletResponse)response);
            DataContext.bindThreadDataContext((DataContext)dataContext);
            filterChain.doFilter(request, response);
        }
        finally {
            ServletContextLocator.set(prevServletContext);
            HttpServletRequestLocator.set(prevHttpServletRequest);
            HttpServletResponseLocator.set(prevHttpServletResponse);
            Database.tearDown();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        Configuration.configureCommonLogging(null);
        ServletUtil.initializeSharedConfiguration((ServletContext)filterConfig.getServletContext());
        Database.initialize(filterConfig.getServletContext());
    }

    protected String getCurrentOrgId(HttpServletRequest request, HttpServletResponse response) {
        return "org001";
    }
}

