/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.parameters;

import com.aimluck.eip.modules.parameters.VelocityParameterPresentationStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletInfoEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class RegistryEntryListBox
extends VelocityParameterPresentationStyle {
    public static final String OPTION_REGISTRY = "registry";
    public static final String OPTION_SORT = "sort";
    public static final String OPTION_SELECT_HIDDEN = "select-hidden";
    public static final String OPTION_NULL_IF_EMPTY = "null-if-empty";
    public static final String OPTION_SET_LABEL = "set-label";
    public static final String OPTION_DISABLED_IF_WML = "disabled-if-wml";
    public static final String OPTION_SELECT_IF_SIMPLE = "select-if-simple";

    @Override
    public void buildContext(RunData data, String name, String value, Map parms, Context context) {
        JetspeedRunData jdata = (JetspeedRunData)data;
        String mediaType = jdata.getProfile().getMediaType();
        String regName = (String)this.getParm(OPTION_REGISTRY, Registry.PORTLET);
        boolean sort = Boolean.valueOf((String)this.getParm(OPTION_SORT, "true"));
        boolean selectHidden = Boolean.valueOf((String)this.getParm(OPTION_SELECT_HIDDEN, "false"));
        String nullIfEmpty = (String)this.getParm(OPTION_NULL_IF_EMPTY, "true");
        boolean setLabel = Boolean.valueOf((String)this.getParm(OPTION_SET_LABEL, "false"));
        boolean disabledIfWML = Boolean.valueOf((String)this.getParm(OPTION_DISABLED_IF_WML, "false"));
        boolean selectIfSimple = Boolean.valueOf((String)this.getParm(OPTION_SELECT_IF_SIMPLE, "false"));
        Object defaultEntry = null;
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        Iterator i = Registry.get((String)regName).listEntryNames();
        while (i.hasNext()) {
            RegistryEntry entry = Registry.getEntry((String)regName, (String)((String)i.next()));
            boolean selected = false;
            selected = JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource(entry), (String)"customize");
            if (selected && !selectHidden) {
                boolean bl = selected = !entry.isHidden();
            }
            if (selected && entry instanceof PortletInfoEntry) {
                selected = ((PortletInfoEntry)entry).hasMediaType(mediaType);
            }
            if (selected && selectIfSimple) {
                Parameter simpleParam = ((PortletInfoEntry)entry).getParameter("simple");
                selected = simpleParam != null ? Boolean.valueOf(simpleParam.getValue()) : false;
            }
            if (!selected) continue;
            list.add(entry);
        }
        if (sort) {
            Collections.sort(list, new Comparator<RegistryEntry>(){

                @Override
                public int compare(RegistryEntry o1, RegistryEntry o2) {
                    String t1 = o1.getTitle() != null ? o1.getTitle() : o1.getName();
                    String t2 = o2.getTitle() != null ? o2.getTitle() : o2.getName();
                    return t1.compareTo(t2);
                }
            });
        }
        String label = null;
        label = regName.equals(Registry.PORTLET) ? Localization.getString((RunData)data, (String)"CUSTOMIZER_PORTLET") : (regName.equals(Registry.SECURITY) ? Localization.getString((RunData)data, (String)"CUSTOMIZER_SECURITY_REF") : (regName.equals(Registry.MEDIA_TYPE) ? Localization.getString((RunData)data, (String)"CUSTOMIZER_MEDIATYPE") : (regName.equals(Registry.PORTLET_CONTROLLER) ? Localization.getString((RunData)data, (String)"CUSTOMIZER_LAYOUT") : (regName.equals(Registry.PORTLET_CONTROL) ? Localization.getString((RunData)data, (String)"CUSTOMIZER_DECORATION") : (regName.equals(Registry.CLIENT) ? "Client" : "")))));
        context.put("entries", list);
        context.put("nullIfEmpty", (Object)nullIfEmpty);
        if (setLabel) {
            context.put("label", (Object)label);
        }
        if (disabledIfWML && mediaType.equalsIgnoreCase("wml")) {
            context.put("disabled", (Object)"disabled");
        }
        context.put("defaultEntry", defaultEntry);
    }
}

