/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.portal.controls;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.common.ALEipInformation;
import com.aimluck.eip.common.ALFunction;
import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.BasePortletSet;
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.controls.AbstractPortletControl;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.jetspeed.util.template.JetspeedTool;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.context.Context;

public class ALVelocityPortletControl
extends AbstractPortletControl {
    private static final long serialVersionUID = 5276591650472642917L;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALVelocityPortletControl.class.getName());

    public boolean isCacheable() {
        return false;
    }

    private List<Entry> getPortletList(RunData rundata) throws NullPointerException {
        Entry[] currentPortletEntries;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Profile profile = jdata.getProfile();
        ArrayList<Entry> portletList = new ArrayList<Entry>();
        String pid = rundata.getParameters().get("js_pane");
        Portlets tabPortlets = profile.getDocument().getPortletsById(pid);
        for (Entry entry : currentPortletEntries = tabPortlets.getEntriesArray()) {
            portletList.add(entry);
        }
        return portletList;
    }

    public ConcreteElement getContent(RunData rundata) {
        PortletWrapper wrapper;
        Portlet portlet = this.getPortlet();
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        if (portlet instanceof PortletWrapper && !(wrapper = (PortletWrapper)portlet).getAllowView(rundata) && JetspeedResources.getBoolean((String)"defaultportletcontrol.hide.decorator", (boolean)true)) {
            return new StringElement("");
        }
        Context context = TurbineVelocity.getContext();
        ALOrgUtilsService.assignCommonContext(context);
        context.put("data", (Object)rundata);
        context.put("actions", this.buildActionList(rundata, portlet, context));
        context.put("functions", this.buildFunctionList(rundata, portlet));
        context.put("conf", (Object)this.getConfig());
        context.put("skin", (Object)portlet.getPortletConfig().getPortletSkin());
        context.put("utils", (Object)new ALCommonUtils());
        try {
            context.put("runs", this.getPortletList(rundata));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, 16);
        context.put("secid", rundata.getUser().getTemp("secid"));
        String showDelete = "false";
        if (hasAuthority) {
            showDelete = "true";
        }
        context.put("accessControl", (Object)showDelete);
        if (Boolean.parseBoolean((String)rundata.getSession().getAttribute("changeToPc"))) {
            context.put("client", (Object)ALEipUtils.getClient(rundata));
        }
        context.put("clientVer", (Object)ALEipUtils.getClientVersion(rundata));
        TurbinePull.populateContext((Context)context, (RunData)rundata);
        if (jdata.getCustomized() != null && portlet.getName().equals(jdata.getCustomized().getName()) && !portlet.providesCustomization()) {
            context.put("portlet", (Object)JetspeedTool.getCustomizer((Portlet)portlet));
            context.put("portlet_instance", (Object)JetspeedTool.getCustomizer((Portlet)portlet));
        } else {
            context.put("portlet", (Object)portlet);
            if (PersistenceManager.getInstance((Portlet)portlet, (RunData)jdata) == null) {
                context.put("portlet_instance", (Object)portlet);
            } else {
                context.put("portlet_instance", (Object)PersistenceManager.getInstance((Portlet)portlet, (RunData)jdata));
            }
        }
        this.buildContext(rundata, context);
        String showTab = rundata.getParameters().getString("showTab");
        if (showTab == null || showTab.equals("") || !showTab.equals("false")) {
            showTab = "true";
        }
        context.put("showTab", (Object)showTab);
        context.put("alias", (Object)ALOrgUtilsService.getAlias());
        ALEipInformation information = ALEipInformation.getInstance();
        String informationCookie = "";
        String informationText = "";
        if (information != null) {
            informationCookie = information.getInformationCookie();
            informationText = information.getInformationText();
            if (informationCookie != null && !"".equals(informationCookie)) {
                String auiInfoDispCookieValue = null;
                if (rundata.getRequest().getCookies() != null) {
                    auiInfoDispCookieValue = rundata.getCookies().getString(informationCookie, "");
                }
                if (auiInfoDispCookieValue != null && !"".equals(auiInfoDispCookieValue)) {
                    context.put("information_display", (Object)Boolean.valueOf(auiInfoDispCookieValue));
                } else {
                    context.put("information_display", (Object)true);
                }
            } else {
                context.put("information_display", (Object)false);
            }
        } else {
            context.put("information_display", (Object)false);
        }
        context.put("information_cookie_name", (Object)informationCookie);
        context.put("information_text", (Object)informationText);
        context.put("information_title", (Object)ALEipInformation.INFORMATION_TITLE);
        try {
            boolean customized = jdata.getMode() == 1;
            boolean maximized = customized || jdata.getMode() == 2;
            Portlets portletsForTimeline = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            int timelineCount = 0;
            for (Portlets p : portletsForTimeline.getPortletsArray()) {
                for (Entry e : p.getEntriesArray()) {
                    if (!"Timeline".equals(e.getParent())) continue;
                    ++timelineCount;
                }
            }
            context.put("timelineCount", (Object)timelineCount);
            if (maximized && "true".equals(showTab)) {
                Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
                Collection<PortletTab> tabs = this.getTabs(PortalToolkit.getSet((Portlets)portlets), rundata, context);
                Iterator<PortletTab> i = tabs.iterator();
                while (i.hasNext()) {
                    PortletTab tab = i.next();
                    if (tab.getTitle().toString().equals("\u500b\u4eba\u8a2d\u5b9a")) {
                        i.remove();
                    }
                    if (!tab.getTitle().toString().equals("\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406")) continue;
                    i.remove();
                }
                context.put("tabs", tabs);
                List<PortletTab> menues = this.getMenus(portlets, rundata, context);
                context.put("menus", menues);
                int gadgetCounts = 0;
                for (PortletTab tab : menues) {
                    if (!"GadgetsTemplate".equals(tab.getName().toString())) continue;
                    ++gadgetCounts;
                }
                context.put("gadgetCounts", (Object)gadgetCounts);
                context.put("accountMenues", this.getAccountMenues(menues));
                context.put("systemMenus", this.getSystemMenus(menues));
                String mypageId = "";
                for (Portlets p : portlets.getPortletsArray()) {
                    if (!"\u30de\u30a4\u30da\u30fc\u30b8".equals(p.getTitle())) continue;
                    mypageId = p.getId();
                }
                context.put("mypageId", (Object)mypageId);
                context.put("globalPortlets", ALEipUtils.getGlobalPortlets(rundata));
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALVelocityPortletControl.getContent", (Throwable)e);
        }
        String theme = this.getConfig().getInitParameter("theme", "default.vm");
        String s = "";
        try {
            String template = TemplateLocator.locateControlTemplate((RunData)rundata, (String)theme);
            TurbineVelocity.handleRequest((Context)context, (String)template, (Writer)rundata.getOut());
        }
        catch (Exception e) {
            logger.error((Object)"Exception while creating content ", (Throwable)e);
            s = e.toString();
        }
        TurbineVelocity.requestFinished((Context)context);
        return new StringElement(s);
    }

    public void buildContext(RunData rundata, Context context) {
    }

    protected List<PortletAction> buildActionList(RunData rundata, Portlet portlet, Context context) {
        Vector<PortletAction> actions = new Vector<PortletAction>();
        JetspeedLink jsLink = null;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        if (JetspeedSecurity.areActionsDisabledForAllUsers()) {
            return actions;
        }
        JetspeedUser user = jdata.getJetspeedUser();
        if (JetspeedSecurity.areActionsDisabledForAnon() && !user.hasLoggedIn()) {
            return actions;
        }
        if (portlet instanceof PortletState) {
            PortletState state = (PortletState)portlet;
            boolean customized = jdata.getMode() == 1;
            boolean maximized = customized || jdata.getMode() == 2;
            context.put("isMaximized", (Object)maximized);
            boolean infoAdded = false;
            if (state.allowCustomize(rundata)) {
                actions.add(new PortletAction("customize", "\u30ab\u30b9\u30bf\u30de\u30a4\u30ba"));
            } else if (state.allowInfo(rundata)) {
                actions.add(new PortletAction("info", "Information"));
                infoAdded = true;
            }
            if (!customized && state.allowPrintFriendly(rundata)) {
                actions.add(new PortletAction("print", "Print Friendly Format"));
            }
            if (!customized && state.allowInfo(rundata) && !infoAdded) {
                actions.add(new PortletAction("info", "Information"));
            }
            if (!customized && !maximized && state.allowClose(rundata)) {
                actions.add(new PortletAction("close", "Close"));
            }
            if (!state.isMinimized(rundata) && !maximized) {
                if (state.allowMinimize(rundata)) {
                    actions.add(new PortletAction("minimize", "Minimize"));
                }
                if (state.allowMaximize(rundata)) {
                    actions.add(new PortletAction("maximize", "Maximize"));
                }
            }
        } else {
            if (portlet.getAllowEdit(rundata)) {
                actions.add(new PortletAction("info", "Information"));
            }
            if (portlet.getAllowMaximize(rundata)) {
                actions.add(new PortletAction("maximize", "Maximize"));
            }
        }
        for (PortletAction action : actions) {
            try {
                jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
            }
            catch (Exception e) {
                logger.error((Object)"ALVelocityPortletControl.buildActionList", (Throwable)e);
            }
            if ("customize".equals(action.getName()) && portlet.getClass() != BasePortletSet.class) {
                action.setLink(jsLink.setAction(ALVelocityPortletControl.getAction("maximize"), portlet).addQueryData("template", "PortletCustomizeFormScreen").toString());
            } else {
                action.setLink(jsLink.setAction(ALVelocityPortletControl.getAction(action.getName()), portlet).toString());
            }
            JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
            jsLink = null;
        }
        return actions;
    }

    protected List<ALFunction> buildFunctionList(RunData rundata, Portlet portlet) {
        ArrayList<ALFunction> functions = new ArrayList<ALFunction>();
        try {
            int i = 1;
            Map map = portlet.getPortletConfig().getInitParameters();
            while (map.containsKey("function_mode" + i)) {
                ALFunction function = new ALFunction();
                function.setMode(portlet.getPortletConfig().getInitParameter("function_mode" + i));
                function.setImage(portlet.getPortletConfig().getInitParameter("function_image" + i));
                function.setCaption(portlet.getPortletConfig().getInitParameter("function_caption" + i));
                if (map.containsKey("function_screen" + i)) {
                    function.setScreen(true);
                }
                if (map.containsKey("function_before_function" + i)) {
                    function.setBeforeFunction(portlet.getPortletConfig().getInitParameter("function_before_function" + i));
                }
                if (map.containsKey("function_after_function" + i)) {
                    function.setAfterFunction(portlet.getPortletConfig().getInitParameter("function_after_function" + i));
                }
                functions.add(function);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALVelocityPortletControl.buildFunctionList", (Throwable)e);
        }
        return functions;
    }

    protected static String getAction(String name) {
        StringBuffer buffer = new StringBuffer("controls.");
        buffer.append(name.substring(0, 1).toUpperCase());
        buffer.append(name.substring(1, name.length()));
        return buffer.toString();
    }

    private List<PortletTab> getSystemMenus(List<PortletTab> tabs) {
        PortletTab[] systemMenues = new PortletTab[11];
        ArrayList<PortletTab> arrayList = new ArrayList<PortletTab>();
        for (PortletTab tab : tabs) {
            if (tab.getName().toString().contains("SysInfo")) {
                systemMenues[0] = tab;
                continue;
            }
            if (tab.getName().toString().contains("FileIO")) {
                systemMenues[1] = tab;
                continue;
            }
            if (tab.getName().toString().contains("Account")) {
                if (tab.getName().toString().equals("AccountPerson")) continue;
                systemMenues[2] = tab;
                continue;
            }
            if (tab.getName().toString().equals("Post")) {
                systemMenues[3] = tab;
                continue;
            }
            if (tab.getName().toString().equals("Position")) {
                systemMenues[4] = tab;
                continue;
            }
            if (tab.getName().toString().equals("Facilities")) {
                systemMenues[5] = tab;
                continue;
            }
            if (tab.getName().toString().contains("GadgetsAdmin")) {
                systemMenues[6] = tab;
                continue;
            }
            if (tab.getName().toString().equals("WorkflowCategory")) {
                systemMenues[7] = tab;
                continue;
            }
            if (tab.getName().toString().equals("ExtTimecardSystem")) {
                systemMenues[8] = tab;
                continue;
            }
            if (tab.getName().toString().equals("AccessControl")) {
                systemMenues[9] = tab;
                continue;
            }
            if (!tab.getName().toString().equals("Eventlog")) continue;
            systemMenues[10] = tab;
        }
        for (PortletTab menues : systemMenues) {
            if (menues == null) continue;
            arrayList.add(menues);
        }
        return arrayList;
    }

    private List<PortletTab> getAccountMenues(List<PortletTab> tabs) {
        PortletTab[] accountMenues = new PortletTab[2];
        for (PortletTab tab : tabs) {
            if (tab.getName().toString().equals("AccountPerson")) {
                accountMenues[0] = tab;
                continue;
            }
            if (!tab.getName().toString().equals("MyGroup")) continue;
            accountMenues[1] = tab;
        }
        return Arrays.asList(accountMenues);
    }

    private List<PortletTab> getMenus(Portlets portlets, RunData rundata, Context context) {
        ArrayList<PortletTab> tabs = new ArrayList<PortletTab>();
        ResultList<ALApplication> apps = ALApplicationService.getList(new ALApplicationGetRequest().withStatus(ALApplicationGetRequest.Status.ACTIVE));
        boolean count = false;
        ArrayList<ALStringField> appTabIds = new ArrayList<ALStringField>();
        Iterator en = portlets.getPortletsIterator();
        while (en.hasNext()) {
            Portlets p = (Portlets)en.next();
            String pane = p.getId();
            Collection<PortletTab> atabs = this.getTabs(PortalToolkit.getSet((Portlets)p), rundata, context);
            Iterator<PortletTab> iterator = atabs.iterator();
            while (iterator.hasNext()) {
                PortletTab tab = iterator.next();
                try {
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", pane).addPathInfo("js_peid", tab.getId()).addQueryData("action", "controls.Maximize");
                    tab.setMaximizeLink(duri.toString());
                    if ("GadgetsTemplate".equals(tab.getName().toString())) {
                        for (ALApplication app : apps) {
                            if (!app.getTitle().toString().equals(tab.getTitle().toString())) continue;
                            if (appTabIds.indexOf(app.getAppId()) < 0) {
                                appTabIds.add(app.getAppId());
                            } else {
                                iterator.remove();
                            }
                            ALApplication gadgetApp = ALApplicationService.get(new ALApplicationGetRequest().withAppId(app.getAppId().getValue()));
                            tab.setIcon(gadgetApp.getIcon().getValue());
                            break;
                        }
                    }
                    if (!"SaaSMessage".equals(tab.getName().toString())) continue;
                    HttpServletRequestLocator.get().setAttribute("SaaSMessageActionUrl", (Object)duri.toString());
                }
                catch (Exception e) {
                    logger.warn((Object)"[ALVelocityPortletControl]", (Throwable)e);
                }
            }
            tabs.addAll(atabs);
        }
        return tabs;
    }

    private Collection<PortletTab> getTabs(PortletSet portlets, RunData rundata, Context context) {
        TreeSet<PortletTab> tabs = new TreeSet<PortletTab>(new PortletTabComparator());
        PanedPortletController controller = null;
        if (portlets.getController() instanceof PanedPortletController) {
            controller = (PanedPortletController)portlets.getController();
        }
        boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, 1);
        context.put("secid", rundata.getUser().getTemp("secid"));
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        int count = 0;
        Enumeration en = portlets.getPortlets();
        while (en.hasMoreElements()) {
            Portlet p = (Portlet)en.nextElement();
            PortalResource portalResource = new PortalResource(p);
            if (!"Activity".equals(p.getName()) && !"Message".equals(p.getName()) || !portlets.getController().getConfig().getName().equals("TabController")) {
                String mstate;
                try {
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    portalResource.setOwner(jsLink.getUserName());
                    JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                }
                catch (Exception e) {
                    logger.warn((Object)"[ALVelocityPortletControl]", (Throwable)e);
                    portalResource.setOwner(null);
                }
                boolean hasView = JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)jdata.getUser()), (PortalResource)portalResource, (String)"view");
                if (!(!hasView || p instanceof PortletState && ((PortletState)p).isClosed(rundata) || (mstate = p.getAttribute("_menustate", "open", rundata)).equals("closed"))) {
                    PortletTab tab = new PortletTab();
                    tab.setId(p.getID());
                    String title = null;
                    PortletInstance pi = PersistenceManager.getInstance((Portlet)p, (RunData)rundata);
                    if (pi != null && (title = pi.getTitle()) == null) {
                        title = p.getTitle() != null ? p.getTitle() : p.getName();
                    }
                    tab.setTitle(title);
                    tab.setName(p.getName());
                    tab.setPosition(p.getPortletConfig().getPosition());
                    if (tabs.contains(tab)) {
                        PortletTab lastTab = tabs.last();
                        int nextPos = lastTab.getPosition() + 1;
                        tab.setPosition(nextPos);
                    }
                    if (controller != null) {
                        boolean isSelected = false;
                        if (jdata.getMode() == 1) {
                            PortletSet set = (PortletSet)jdata.getCustomized();
                            if (this.isTab(rundata, set.getID())) {
                                if (p.getID().equals(set.getID())) {
                                    isSelected = true;
                                    controller.savePaneID(rundata, p.getID());
                                }
                            } else {
                                isSelected = controller.isSelected(p, rundata);
                            }
                        } else if (jdata.getMode() == 2) {
                            isSelected = this.containsPeid(rundata, (PortletSet)p, (String)jdata.getUser().getTemp("js_peid"));
                        }
                        tab.setSelected(isSelected);
                        if (this.getPortlet() == null) {
                            tab.setLink(controller.getPortletURI(p, rundata).toString() + "?action=controls.Restore");
                        } else {
                            try {
                                JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                                DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                                tab.setMaximizeLink(controller.getPortletURI(p, rundata).addQueryData("action", "controls.Maximize").toString());
                                isSelected = this.containsPeid(rundata, (PortletSet)p, this.getPortlet().getID());
                                if (isSelected) {
                                    duri = duri.addPathInfo("js_pane", this.getPortlet().getID()).addQueryData("action", "controls.Restore");
                                    tab.setLink(duri.toString());
                                } else {
                                    tab.setLink(controller.getPortletURI(p, rundata).addQueryData("action", "controls.Restore").toString());
                                }
                            }
                            catch (TurbineException e) {
                                tab.setLink(controller.getPortletURI(p, rundata).addQueryData("action", "controls.Restore").toString());
                                tab.setMaximizeLink(controller.getPortletURI(p, rundata).addQueryData("action", "controls.Maximize").toString());
                            }
                        }
                    }
                    tab.setActions(this.buildActionList(rundata, p, context));
                    tab.setAuthority(hasAuthority);
                    tabs.add(tab);
                }
            }
            ++count;
        }
        return tabs;
    }

    private boolean containsPeid(RunData rundata, PortletSet portlets, String selectedPeid) {
        int count = 0;
        Enumeration en = portlets.getPortlets();
        while (en.hasMoreElements()) {
            Portlet p = (Portlet)en.nextElement();
            if (p.getID().equals(selectedPeid)) {
                SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(portlets.getID());
                state.setAttribute("js_pane", (Object)portlets.getID());
                return true;
            }
            ++count;
        }
        return false;
    }

    private boolean isTab(RunData rundata, String peid) {
        if (peid == null || peid.equals("")) {
            return false;
        }
        Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
        Portlets[] tabList = portlets.getPortletsArray();
        int length = tabList.length;
        for (int i = 0; i < length; ++i) {
            if (!tabList[i].getId().equals(peid)) continue;
            return true;
        }
        return false;
    }

    protected String retrievePaneIDFromSession(RunData rundata, PortletSet portlets) {
        SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(portlets.getID());
        String pane = (String)state.getAttribute("js_pane");
        if (pane == null && portlets.size() > 0) {
            pane = portlets.getPortletAt(0).getID();
        }
        return pane;
    }

    public static class PortletTabComparator
    implements Comparator<PortletTab>,
    Serializable {
        @Override
        public int compare(PortletTab o1, PortletTab o2) {
            try {
                PortletTab pt1 = o1;
                PortletTab pt2 = o2;
                int pos1 = pt1.getPosition();
                int pos2 = pt2.getPosition();
                if (pos1 < pos2) {
                    return -1;
                }
                if (pos1 > pos2) {
                    return 1;
                }
                return 0;
            }
            catch (ClassCastException e) {
                logger.error((Object)"ALVelocityPortletControl.compare", (Throwable)e);
                return 0;
            }
        }
    }

    public static class PortletTab {
        private final ALStringField title = new ALStringField();
        private final ALStringField name = new ALStringField();
        private boolean selected = false;
        private String link = null;
        private String maximize_link = null;
        private List<PortletAction> actions = null;
        private int position = -1;
        private String id = null;
        private final ALStringField icon = new ALStringField();
        private boolean authority = true;

        public ALStringField getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title.setValue(title);
        }

        public ALStringField getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name.setValue(name);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getMaximizeLink() {
            return this.maximize_link;
        }

        public void setMaximizeLink(String link) {
            this.maximize_link = link;
        }

        public List<PortletAction> getActions() {
            return this.actions == null ? new Vector() : this.actions;
        }

        public void setActions(List<PortletAction> actions) {
            this.actions = actions;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int pos) {
            this.position = pos;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String tabId) {
            this.id = tabId;
        }

        public boolean getAuthority() {
            return this.authority;
        }

        public void setAuthority(boolean flg) {
            this.authority = flg;
        }

        public ALStringField getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon.setValue(icon);
        }
    }

    public static class PortletAction {
        String name = null;
        String link = null;
        String alt = null;

        protected PortletAction(String name, String alt) {
            this.name = name;
            this.alt = alt;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getAlt() {
            return this.alt;
        }
    }
}

