/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.eip.services.portal.ALPortalApplicationService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.File;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.upload.TurbineUpload;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;

public class ALCommonUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALCommonUtils.class.getName());
    public static final String DEF_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final int DEF_RANDOM_LENGTH = 16;
    private static SecureRandom random = ALCommonUtils.getSecureRandom();
    private static String CACHE_BUST = null;

    public static String escapeXML(String string) {
        return StringEscapeUtils.escapeXml((String)string);
    }

    public static String escapeXML(DynamicURI uri) {
        return StringEscapeUtils.escapeXml((String)uri.toString());
    }

    public static String replaceToAutoCRString(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer res = new StringBuffer("");
        int step = 4;
        int size = str.length();
        int count = size / step;
        for (int i = 0; i < count; ++i) {
            int j = i * step;
            res.append(str.substring(j, j + step)).append("<wbr/>");
        }
        if (count * step < size) {
            res.append(str.substring(count * step));
        }
        return res.toString();
    }

    public static int getMaxFileSize() {
        return ALCommonUtils.getMaxFileSize("MB");
    }

    public static int getMaxFileSize(String unit) {
        int size = TurbineUpload.getSizeMax();
        if (unit.equals("MB")) {
            size = size / 1024 / 1024;
        } else if (unit.equals("KB")) {
            size /= 1024;
        }
        return size;
    }

    public static String replaceToAutoCRChild(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer res = null;
        int findex = str.indexOf("&");
        int lindex = str.indexOf(";");
        if (findex == -1 && lindex == -1) {
            return ALCommonUtils.replaceToAutoCRString(str);
        }
        if (lindex != -1 && (findex == -1 || findex > lindex)) {
            String head = str.substring(0, lindex);
            String body = str.substring(lindex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRString(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else if (findex != -1 && lindex == -1) {
            String head = str.substring(0, findex);
            String body = str.substring(findex, findex + 1);
            String tail = str.substring(findex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRString(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else {
            String head = str.substring(0, findex);
            String body = str.substring(findex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRString(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        }
        return res.toString();
    }

    public static String replaceToAutoCR(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer res = null;
        int findex = str.indexOf("<");
        int lindex = str.indexOf(">");
        if (findex == -1 && lindex == -1) {
            return ALCommonUtils.replaceToAutoCRChild(str);
        }
        if (findex == -1 || findex > lindex) {
            String head = str.substring(0, lindex);
            String body = str.substring(lindex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRChild(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else if (lindex == -1) {
            String head = str.substring(0, findex);
            String body = str.substring(findex, findex + 1);
            String tail = str.substring(findex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRChild(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else {
            String head = str.substring(0, findex);
            String body = str.substring(findex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRChild(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        }
        return res.toString();
    }

    public static String compressString(String src, int length) {
        String subject;
        if (src == null || src.length() == 0 || length <= 0) {
            return src;
        }
        if (src.length() > length) {
            subject = src.substring(0, length);
            subject = subject + "\u30fb\u30fb\u30fb";
        } else {
            subject = src;
        }
        return subject;
    }

    public static String getSecureRandomString() {
        String res = null;
        try {
            if (null == random) {
                return null;
            }
            byte[] b = new byte[16];
            random.nextBytes(b);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(b);
            StringBuffer sb = new StringBuffer();
            for (byte _b : b) {
                sb.append(String.format("%02x", _b));
            }
            res = sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)"ALCommonUtils.getSecureRandomString", (Throwable)e);
            return null;
        }
        return res;
    }

    public static SecureRandom getSecureRandom() {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance(DEF_RANDOM_ALGORITHM);
            byte[] seed = random.generateSeed(16);
            random.setSeed(seed);
        }
        catch (Exception e) {
            logger.error((Object)"ALCommonUtils.getSecureRandom", (Throwable)e);
            return null;
        }
        return random;
    }

    public int getImageRandomNumber() {
        SecureRandom random = new SecureRandom();
        return random.nextInt() * 100;
    }

    public static String normalizeURL(String url) {
        String res = url;
        if (!res.contains("://")) {
            res = "http://" + res;
        }
        return res;
    }

    public static DynamicURI getPortletURIinPersonalConfigPane(RunData rundata, String portletEntryName) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId() + "," + entries[j].getId()).addQueryData("action", "controls.Restore");
                    return duri;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALCommonUtils.getPortletURIinPersonalConfigPane", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static DynamicURI getPortletURIinPersonalConfigPeid(RunData rundata, String portletEntryName) {
        try {
            Profile profile = ((JetspeedRunData)rundata).getProfile();
            if (profile == null) {
                return null;
            }
            Portlets portlets = profile.getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_peid", entries[j].getId());
                    return duri;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALCommonUtils.getPortletURIinPersonalConfigPeid", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getCacheBust() {
        if (CACHE_BUST == null) {
            File file = new File(JetspeedResources.getString((String)"aipo.cached.file"));
            long lastModified = file.lastModified();
            CACHE_BUST = String.valueOf(lastModified);
        }
        return CACHE_BUST;
    }

    public static boolean isAndroidBrowser(RunData rundata) {
        return ALEipUtils.isAndroidBrowser(rundata);
    }

    public static boolean isAndroid2Browser(RunData rundata) {
        return ALEipUtils.isAndroid2Browser(rundata);
    }

    public static boolean isActive(String portletName) {
        return ALPortalApplicationService.isActive(portletName);
    }

    public static String getl10nFormat1(String key, Object values) {
        return ALLocalizationUtils.getl10nFormat(key, values);
    }

    public static String replaceToTelLink(String tel) {
        if (!StringUtils.isEmpty((String)tel)) {
            return tel.replaceAll("-", "");
        }
        return "";
    }

    public static long getCurrentTime() {
        return new Date().getTime();
    }

    public static boolean isFileUploadable(RunData rundata) {
        return ALEipUtils.isFileUploadable(rundata);
    }
}

