/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.ExternalTransaction;
import org.apache.cayenne.access.InternalTransaction;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.TransactionDelegate;
import org.apache.log4j.Level;

public abstract class Transaction {
    static final ThreadLocal currentTransaction = new ThreadLocal();
    private static final Transaction NO_TRANSACTION = new Transaction(){

        @Override
        public void begin() {
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }
    };
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_COMMITTING = 2;
    public static final int STATUS_COMMITTED = 3;
    public static final int STATUS_ROLLEDBACK = 4;
    public static final int STATUS_ROLLING_BACK = 5;
    public static final int STATUS_NO_TRANSACTION = 6;
    public static final int STATUS_MARKED_ROLLEDBACK = 7;
    protected Map connections;
    protected int status = 6;
    protected TransactionDelegate delegate;
    @Deprecated
    protected Level logLevel;

    static String decodeStatus(int status) {
        switch (status) {
            case 1: {
                return "STATUS_ACTIVE";
            }
            case 2: {
                return "STATUS_COMMITTING";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_ROLLING_BACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_MARKED_ROLLEDBACK";
            }
        }
        return "Unknown Status - " + status;
    }

    public static void bindThreadTransaction(Transaction transaction) {
        currentTransaction.set(transaction);
    }

    public static Transaction getThreadTransaction() {
        return (Transaction)currentTransaction.get();
    }

    public static Transaction internalTransaction(TransactionDelegate delegate) {
        return new InternalTransaction(delegate);
    }

    public static Transaction externalTransaction(TransactionDelegate delegate) {
        return new ExternalTransaction(delegate);
    }

    public static Transaction noTransaction() {
        return NO_TRANSACTION;
    }

    protected Transaction() {
    }

    @Deprecated
    public void performQueries(QueryEngine engine, Collection queries, OperationObserver observer) throws CayenneRuntimeException {
        Transaction old = Transaction.getThreadTransaction();
        Transaction.bindThreadTransaction(this);
        try {
            engine.performQueries(queries, observer);
            if (!observer.isIteratedResult() && this.getStatus() == 1) {
                this.commit();
            }
        }
        catch (Exception ex) {
            this.setRollbackOnly();
            if (ex instanceof CayenneRuntimeException) {
                throw (CayenneRuntimeException)ex;
            }
            throw new CayenneRuntimeException((Throwable)ex);
        }
        finally {
            Transaction.bindThreadTransaction(old);
            if (this.getStatus() == 7) {
                try {
                    this.rollback();
                }
                catch (Exception rollbackEx) {}
            }
        }
    }

    @Deprecated
    public Level getLogLevel() {
        return this.logLevel != null ? this.logLevel : Level.INFO;
    }

    @Deprecated
    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public TransactionDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(TransactionDelegate delegate) {
        this.delegate = delegate;
    }

    public int getStatus() {
        return this.status;
    }

    public synchronized void setRollbackOnly() {
        this.setStatus(7);
    }

    public synchronized void setStatus(int status) {
        if (this.delegate != null && status == 7 && !this.delegate.willMarkAsRollbackOnly(this)) {
            return;
        }
        this.status = status;
    }

    public abstract void begin();

    @Deprecated
    public void addConnection(Connection connection) throws IllegalStateException, SQLException, CayenneException {
        this.addConnection("x" + System.currentTimeMillis(), connection);
    }

    public abstract void commit() throws IllegalStateException, SQLException, CayenneException;

    public abstract void rollback() throws IllegalStateException, SQLException, CayenneException;

    public Connection getConnection(String name) {
        return this.connections != null ? (Connection)this.connections.get(name) : null;
    }

    public boolean addConnection(String name, Connection connection) throws SQLException {
        if (this.delegate != null && !this.delegate.willAddConnection(this, connection)) {
            return false;
        }
        if (this.connections == null) {
            this.connections = new HashMap();
        }
        return this.connections.put(name, connection) != connection;
    }
}

