/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.category.util;

import com.aimluck.eip.category.beans.CommonCategoryLiteBean;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CommonCategoryUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CommonCategoryUtils.class.getName());

    public static EipTCommonCategory getEipTCommonCategory(Long category_id) {
        try {
            EipTCommonCategory result = (EipTCommonCategory)Database.get(EipTCommonCategory.class, (Object)category_id);
            if (result == null) {
                logger.debug((Object)"[CommonCategoryUtils] Not found ID...");
                return null;
            }
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)"CommonCategoryUtils.getEipTCommonCategory", (Throwable)ex);
            return null;
        }
    }

    public static EipTCommonCategory getEipTCommonCategory(RunData rundata, Context context) {
        String category_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (category_id == null || Integer.valueOf(category_id) == null) {
                logger.debug((Object)"[CommonCategoryUtils] Empty ID...");
                return null;
            }
            return CommonCategoryUtils.getEipTCommonCategory(Long.valueOf(category_id));
        }
        catch (Exception ex) {
            logger.error((Object)"CommonCategoryUtils.getEipTCommonCategory", (Throwable)ex);
            return null;
        }
    }

    public static List<CommonCategoryLiteBean> getCommonCategoryLiteBeans(RunData rundata) {
        ArrayList<CommonCategoryLiteBean> list = new ArrayList<CommonCategoryLiteBean>();
        try {
            SelectQuery query = Database.query(EipTCommonCategory.class);
            Expression exp = ExpressionFactory.noMatchDbExp((String)"COMMON_CATEGORY_ID", (Object)1);
            query.setQualifier(exp).orderAscending("name");
            List commoncategory_list = query.fetchList();
            for (EipTCommonCategory record : commoncategory_list) {
                CommonCategoryLiteBean bean = new CommonCategoryLiteBean();
                bean.initField();
                bean.setCategoryId(record.getCommonCategoryId().longValue());
                bean.setCategoryName(record.getName());
                list.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"CommonCategoryUtils.getCommonCategoryLiteBeans", (Throwable)ex);
        }
        return list;
    }

    public static boolean checkPermission(RunData rundata, Context context, int defineAclType, String pfeature) {
        if (defineAclType == 0) {
            return true;
        }
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        return hasAuthority;
    }

    public static void setDefaultCommonCategoryToSchedule(EipTCommonCategory category) {
        Expression exp;
        SelectQuery query = Database.query(EipTScheduleMap.class);
        List schedulemap_list = query.andQualifier(exp = ExpressionFactory.matchExp((String)"commonCategoryId", (Object)category.getCommonCategoryId())).fetchList();
        if (schedulemap_list != null) {
            EipTCommonCategory tmpCategory = CommonCategoryUtils.getEipTCommonCategory(1L);
            for (EipTScheduleMap record : schedulemap_list) {
                record.setEipTCommonCategory(tmpCategory);
            }
        }
    }
}

