/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystemMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.exttimecard.ExtTimecardListResultData;
import com.aimluck.eip.exttimecard.ExtTimecardResultData;
import com.aimluck.eip.exttimecard.ExtTimecardSummaryResultData;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardSummaryListSelectData
extends ALAbstractSelectData<EipTExtTimecard, EipTExtTimecard>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardSummaryListSelectData.class.getName());
    private String target_group_name;
    private String target_user_id;
    private List<ALEipGroup> myGroupList = null;
    private List<ALEipUser> userList = null;
    private List<Object> list;
    private String userid;
    private final String TARGET_GROUP_NAME = "target_group_name";
    private final String TARGET_USER_ID = "target_user_id";
    private String nowtime;
    private Map<Integer, List<ExtTimecardResultData>> usermap;
    private Map<Integer, ExtTimecardSummaryResultData> datemap;
    private String aclPortletFeature = null;
    private boolean hasAclSummaryOther;
    private boolean hasAclUpdate;
    private boolean hasAclInsert;
    private boolean hasAclXlsExport;
    private ALDateTimeField viewMonth;
    private ALDateTimeField prevMonth;
    private ALDateTimeField nextMonth;
    private ALDateTimeField currentMonth;
    private ALDateTimeField today;
    private ALDateTimeField viewStart;
    private ALDateTimeField viewEnd;
    private ALDateTimeField viewEndCrt;
    private final String MODE = "summary";
    protected int viewTodo;
    private int startDay;

    public void initField() {
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        Calendar cal;
        int userid;
        EipTExtTimecardSystemMap rd;
        Date now;
        EipTExtTimecardSystem system;
        ResultList map_list;
        Expression exp;
        SelectQuery default_query;
        block29: {
            super.init(action, rundata, context);
            this.initField();
            this.viewMonth = new ALDateTimeField("yyyy-MM");
            this.viewMonth.setNotNull(true);
            this.prevMonth = new ALDateTimeField("yyyy-MM");
            this.nextMonth = new ALDateTimeField("yyyy-MM");
            this.currentMonth = new ALDateTimeField("yyyy-MM");
            this.viewStart = new ALDateTimeField("yyyy-MM-dd");
            this.viewEnd = new ALDateTimeField("yyyy-MM-dd");
            this.viewEndCrt = new ALDateTimeField("yyyy-MM-dd");
            this.startDay = 1;
            if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_month")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_month", (String)rundata.getParameters().getString("view_month"));
            }
            this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList<ALEipGroup>();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add((ALEipGroup)myGroups.get(i));
            }
            try {
                String userFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
                if (userFilter != null && !userFilter.equals("")) {
                    int paramId = -1;
                    try {
                        paramId = Integer.parseInt(userFilter);
                        if (paramId <= 3) break block29;
                        ALEipUser user = ALEipUtils.getALEipUser((int)paramId);
                        if (user != null) {
                            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userFilter);
                            break block29;
                        }
                        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
                    }
                    catch (NumberFormatException e) {}
                    break block29;
                }
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
            }
            catch (Exception ex) {
                logger.error((Object)"exttimecard", (Throwable)ex);
            }
        }
        this.aclPortletFeature = this.target_user_id == null || "".equals(this.target_user_id) || this.userid.equals(this.target_user_id) ? "timecard_timecard_self" : "timecard_timecard_other";
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclSummaryOther = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 1);
        this.hasAclUpdate = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 8);
        this.hasAclInsert = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 4);
        this.hasAclXlsExport = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 32);
        if (!this.hasAclSummaryOther) {
            this.target_group_name = "only";
            this.aclPortletFeature = "timecard_timecard_self";
            this.hasAclXlsExport = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_self", 32);
        }
        this.datemap = new LinkedHashMap<Integer, ExtTimecardSummaryResultData>();
        this.usermap = new LinkedHashMap<Integer, List<ExtTimecardResultData>>();
        if (this.target_user_id != null && !this.target_user_id.isEmpty()) {
            default_query = Database.query(EipTExtTimecardSystemMap.class);
            exp = ExpressionFactory.matchExp((String)"userId", (Object)this.target_user_id);
            default_query.setQualifier(exp);
            map_list = default_query.getResultList();
            if (!map_list.isEmpty()) {
                this.startDay = ((EipTExtTimecardSystemMap)map_list.get(0)).getEipTExtTimecardSystem().getStartDay();
            } else {
                system = (EipTExtTimecardSystem)Database.get(EipTExtTimecardSystem.class, (Object)1);
                if (system != null) {
                    try {
                        now = new Date();
                        rd = new EipTExtTimecardSystemMap();
                        rd.setEipTExtTimecardSystem(system);
                        userid = Integer.parseInt(this.target_user_id);
                        rd.setUserId(Integer.valueOf(userid));
                        rd.setCreateDate(now);
                        rd.setUpdateDate(now);
                        Database.commit();
                        this.startDay = system.getStartDay();
                    }
                    catch (Exception ex) {
                        Database.rollback();
                        logger.error((Object)"exttimecard", (Throwable)ex);
                    }
                }
            }
        } else if (this.userid != null && !this.userid.isEmpty()) {
            default_query = Database.query(EipTExtTimecardSystemMap.class);
            exp = ExpressionFactory.matchExp((String)"userId", (Object)this.userid);
            default_query.setQualifier(exp);
            map_list = default_query.getResultList();
            if (!map_list.isEmpty()) {
                this.startDay = ((EipTExtTimecardSystemMap)map_list.get(0)).getEipTExtTimecardSystem().getStartDay();
            } else {
                system = (EipTExtTimecardSystem)Database.get(EipTExtTimecardSystem.class, (Object)1);
                if (system != null) {
                    try {
                        now = new Date();
                        rd = new EipTExtTimecardSystemMap();
                        rd.setEipTExtTimecardSystem(system);
                        userid = Integer.parseInt(this.target_user_id);
                        rd.setUserId(Integer.valueOf(userid));
                        rd.setCreateDate(now);
                        rd.setUpdateDate(now);
                        Database.commit();
                        this.startDay = system.getStartDay();
                    }
                    catch (Exception ex) {
                        Database.rollback();
                        logger.error((Object)"exttimecard", (Throwable)ex);
                    }
                }
            }
        }
        this.today = new ALDateTimeField("yyyy-MM-dd");
        Calendar to = Calendar.getInstance();
        to.set(11, 0);
        to.set(12, 0);
        this.today.setValue(to.getTime());
        boolean isBeforeThanStartDay = Integer.parseInt(this.today.getDay().toString()) < this.startDay;
        String tmpViewMonth = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_month");
        if (tmpViewMonth == null || tmpViewMonth.equals("")) {
            cal = Calendar.getInstance();
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            if (isBeforeThanStartDay) {
                cal.add(2, -1);
            }
            this.viewMonth.setValue(cal.getTime());
        } else {
            this.viewMonth.setValue(tmpViewMonth);
            if (!this.viewMonth.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_month");
                throw new ALPageNotFoundException();
            }
        }
        if (!isBeforeThanStartDay && Integer.parseInt(this.today.getMonth()) == Integer.parseInt(this.viewMonth.getMonth().toString())) {
            this.currentMonth.setValue(to.getTime());
        } else {
            Calendar tmp_cal = Calendar.getInstance();
            tmp_cal.set(5, 1);
            tmp_cal.set(11, 0);
            tmp_cal.set(12, 0);
            if (isBeforeThanStartDay) {
                tmp_cal.add(2, -1);
            }
            this.currentMonth.setValue(tmp_cal.getTime());
        }
        cal = Calendar.getInstance();
        cal.set(2, Integer.parseInt(this.viewMonth.getMonth()) - 1);
        cal.set(5, this.startDay);
        Date startDate = cal.getTime();
        this.viewStart.setValue(startDate);
        cal.add(2, 1);
        cal.add(5, -1);
        Date endDate = cal.getTime();
        this.viewEnd.setValue(endDate);
        this.viewEndCrt.setValue(endDate);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewMonth.getValue());
        cal2.add(2, 1);
        this.nextMonth.setValue(cal2.getTime());
        cal2.add(2, -2);
        this.prevMonth.setValue(cal2.getTime());
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewStart.toString() + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewStart.toString() + "-00-00"));
        this.setupLists(rundata, context);
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            action.setMode("list");
            for (int i = 0; i < this.userList.size(); ++i) {
                ALEipUser eipUser = this.userList.get(i);
                List<EipTExtTimecard> aList = this.selectList(rundata, context, eipUser.getUserId().getValueAsString());
                if (aList == null) continue;
                this.list = new ArrayList<Object>();
                Object obj = null;
                int size = aList.size();
                for (int j = 0; j < size; ++j) {
                    obj = this.getResultData(aList.get(j));
                    if (obj == null) continue;
                    this.list.add(obj);
                }
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
            return this.list != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected List<EipTExtTimecard> selectList(RunData rundata, Context context, String target_user_id) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.setupLists(rundata, context);
            if (!"".equals(target_user_id)) {
                SelectQuery<EipTExtTimecard> query = this.getSelectQuery(rundata, context, target_user_id);
                this.buildSelectQueryForListView(query);
                query.orderAscending("punchDate");
                return query.getResultList();
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    protected ResultList<EipTExtTimecard> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.setupLists(rundata, context);
            if (!"".equals(this.target_user_id)) {
                SelectQuery<EipTExtTimecard> query = this.getSelectQuery(rundata, context, this.target_user_id);
                this.buildSelectQueryForListView(query);
                query.orderAscending("punchDate");
                return query.getResultList();
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    protected EipTExtTimecard selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultData(EipTExtTimecard record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int user_id = record.getUserId();
            ExtTimecardResultData rd = new ExtTimecardResultData();
            rd.initField();
            rd.setPunchDate(record.getPunchDate());
            rd.setRefixFlag(record.getCreateDate(), record.getUpdateDate());
            rd.setClockInTime(record.getClockInTime());
            rd.setClockOutTime(record.getClockOutTime());
            for (int i = 1; i <= 5; ++i) {
                rd.setOutgoingTime(record.getOutgoingTime(i), i);
                rd.setComebackTime(record.getComebackTime(i), i);
            }
            rd.setType(record.getType());
            if (this.usermap.containsKey(user_id)) {
                List<ExtTimecardResultData> list = this.usermap.get(user_id);
                list.add(rd);
                this.usermap.put(user_id, list);
            } else {
                ArrayList<ExtTimecardResultData> list = new ArrayList<ExtTimecardResultData>();
                list.add(rd);
                this.usermap.put(user_id, list);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
        return null;
    }

    protected Object getResultDataDetail(EipTExtTimecard obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    private List<ALEipUser> getUserList(int userid) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        ALEipUser user = new ALEipUser();
        try {
            user = ALEipUtils.getALEipUser((int)userid);
        }
        catch (NumberFormatException e1) {
        }
        catch (ALDBErrorException e1) {
            // empty catch block
        }
        list.add(user);
        return list;
    }

    private void setupLists(RunData rundata, Context context) {
        this.target_group_name = this.getTargetGroupName(rundata, context);
        this.userList = this.target_group_name != null ? (!(this.target_group_name.equals("") || this.target_group_name.equals("all") || this.target_group_name.equals("only")) ? ALEipUtils.getUsers((String)this.target_group_name) : (this.target_group_name.equals("all") || this.target_group_name.equals("only") ? this.getUserList(Integer.parseInt(this.userid)) : ALEipUtils.getUsers((String)"LoginUser"))) : ALEipUtils.getUsers((String)"LoginUser");
        if (this.userList == null || this.userList.size() == 0) {
            this.target_user_id = "";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
            return;
        }
        this.target_user_id = this.getTargetUserId(rundata, context);
    }

    private String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_group_name");
        }
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_group_name");
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)"only");
            target_group_name = "only";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    private String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_user_id");
        }
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
            target_user_id = this.userid;
        } else if (idParam != null) {
            if (idParam.equals("none")) {
                ALEipUser eipUser = null;
                boolean found = false;
                int length = this.userList.size();
                for (int i = 0; i < length; ++i) {
                    eipUser = this.userList.get(i);
                    String eipUserId = eipUser.getUserId().getValueAsString();
                    if (!this.userid.equals(eipUserId)) continue;
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
                    target_user_id = this.userid;
                    found = true;
                    break;
                }
                if (!found) {
                    eipUser = this.userList.get(0);
                    String userId = eipUser.getUserId().getValueAsString();
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userId);
                    target_user_id = userId;
                }
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)idParam);
                target_user_id = idParam;
            }
        }
        return target_user_id;
    }

    private SelectQuery<EipTExtTimecard> getSelectQuery(RunData rundata, Context context, String target_user_id) {
        SelectQuery query = Database.query(EipTExtTimecard.class);
        this.startDay = 1;
        SelectQuery default_query = Database.query(EipTExtTimecardSystemMap.class);
        Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)target_user_id);
        default_query.setQualifier(exp);
        ResultList map_list = default_query.getResultList();
        if (!map_list.isEmpty()) {
            this.startDay = ((EipTExtTimecardSystemMap)map_list.get(0)).getEipTExtTimecardSystem().getStartDay();
        } else {
            EipTExtTimecardSystem system = (EipTExtTimecardSystem)Database.get(EipTExtTimecardSystem.class, (Object)1);
            if (system != null) {
                try {
                    Date now = new Date();
                    EipTExtTimecardSystemMap rd = new EipTExtTimecardSystemMap();
                    rd.setEipTExtTimecardSystem(system);
                    int userid = Integer.parseInt(target_user_id);
                    rd.setUserId(Integer.valueOf(userid));
                    rd.setCreateDate(now);
                    rd.setUpdateDate(now);
                    Database.commit();
                    this.startDay = system.getStartDay();
                }
                catch (Exception ex) {
                    Database.rollback();
                    logger.error((Object)"exttiemcard", (Throwable)ex);
                }
            }
        }
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(target_user_id));
        query.setQualifier(exp1);
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(this.viewMonth.getYear()));
        cal.set(2, Integer.parseInt(this.viewMonth.getMonth()) - 1);
        cal.set(5, this.startDay);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"punchDate", (Object)date);
        cal.add(2, 1);
        cal.add(14, -1);
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"punchDate", (Object)cal.getTime());
        query.andQualifier(exp11.andExp(exp12));
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public List<ExtTimecardSummaryResultData> getUserExtTimecards() {
        ArrayList<ExtTimecardSummaryResultData> list = new ArrayList<ExtTimecardSummaryResultData>();
        Set<Integer> userset = this.usermap.keySet();
        for (Integer user_id : userset) {
            List<ExtTimecardResultData> userlist = this.usermap.get(user_id);
            ExtTimecardSummaryResultData summary_rd = new ExtTimecardSummaryResultData();
            int work_day = 0;
            int overtime_day = 0;
            int off_day = 0;
            float work_hour = 0.0f;
            float overtime_hour = 0.0f;
            float off_hour = 0.0f;
            int late_coming_day = 0;
            int early_leaving_day = 0;
            int absent_day = 0;
            int paid_holiday = 0;
            int compensatory_holiday = 0;
            int other_day = 0;
            int no_input = 0;
            summary_rd.initField();
            EipTExtTimecardSystem timecard_system = ExtTimecardUtils.getEipTExtTimecardSystemByUserId(user_id);
            Iterator<ExtTimecardResultData> iterator = userlist.iterator();
            while (iterator.hasNext()) {
                ExtTimecardResultData obj;
                ExtTimecardResultData rd = obj = iterator.next();
                ExtTimecardListResultData lrd = new ExtTimecardListResultData();
                lrd.setRd(rd);
                lrd.setTimecardSystem(timecard_system);
                String type = rd.getType().getValue();
                if (type.equals("P")) {
                    if (lrd.getWorkHour() != -1.0f) {
                        ++work_day;
                        work_hour += lrd.getWorkHourWithoutRestHour();
                    }
                    if (lrd.getOvertimeHour() != -1.0f) {
                        ++overtime_day;
                        overtime_hour += lrd.getOvertimeHourWithoutRestHour();
                    }
                    if (lrd.getOffHour() != -1.0f) {
                        ++off_day;
                        off_hour += lrd.getOffHour();
                    }
                    if (lrd.isLateComing()) {
                        ++late_coming_day;
                    }
                    if (!lrd.isEarlyLeaving()) continue;
                    ++early_leaving_day;
                    continue;
                }
                if (type.equals("A")) {
                    ++absent_day;
                    continue;
                }
                if (type.equals("H")) {
                    ++paid_holiday;
                    continue;
                }
                if (type.equals("C")) {
                    ++compensatory_holiday;
                    continue;
                }
                if (!type.equals("E")) continue;
                ++other_day;
            }
            work_hour = ExtTimecardUtils.roundHour(work_hour);
            overtime_hour = ExtTimecardUtils.roundHour(overtime_hour);
            off_hour = ExtTimecardUtils.roundHour(off_hour);
            summary_rd.setWorkDayHour(work_day, work_hour);
            summary_rd.setOvertimeDayHour(overtime_day, overtime_hour);
            summary_rd.setOffDayHour(off_day, off_hour);
            summary_rd.setLateComingDay(late_coming_day);
            summary_rd.setEarlyLeavingDay(early_leaving_day);
            summary_rd.setAbsentDay(absent_day);
            summary_rd.setPaidHoliday(paid_holiday);
            summary_rd.setCompensatoryHoliday(compensatory_holiday);
            summary_rd.setOtherDay(other_day);
            summary_rd.setNoInput(no_input);
            list.add(summary_rd);
        }
        return list;
    }

    public List<ExtTimecardSummaryResultData> getGroupExtTimecards() {
        ArrayList<ExtTimecardSummaryResultData> list = new ArrayList<ExtTimecardSummaryResultData>();
        for (int i = 0; i < this.userList.size(); ++i) {
            ALEipUser eipUser = this.userList.get(i);
            int user_id = Integer.parseInt(eipUser.getUserId().getValueAsString());
            List<ExtTimecardResultData> userlist = this.usermap.get(user_id);
            ExtTimecardSummaryResultData summary_rd = new ExtTimecardSummaryResultData();
            int work_day = 0;
            int overtime_day = 0;
            int off_day = 0;
            float work_hour = 0.0f;
            float overtime_hour = 0.0f;
            float off_hour = 0.0f;
            int late_coming_day = 0;
            int early_leaving_day = 0;
            int absent_day = 0;
            int paid_holiday = 0;
            int compensatory_holiday = 0;
            int other_day = 0;
            int no_input = 0;
            summary_rd.initField();
            EipTExtTimecardSystem timecard_system = ExtTimecardUtils.getEipTExtTimecardSystemByUserId(user_id);
            if (userlist != null) {
                for (ExtTimecardResultData rd : userlist) {
                    ExtTimecardListResultData lrd = new ExtTimecardListResultData();
                    lrd.initField();
                    lrd.setDate(rd.getPunchDate().getValue());
                    lrd.setRd(rd);
                    lrd.setTimecardSystem(timecard_system);
                    String type = rd.getType().getValue();
                    if (type.equals("P")) {
                        if (lrd.getWorkHour() != -1.0f) {
                            ++work_day;
                            work_hour += lrd.getWorkHourWithoutRestHour();
                        }
                        if (lrd.getOvertimeHour() > 0.0f) {
                            ++overtime_day;
                            overtime_hour += lrd.getOvertimeHourWithoutRestHour();
                        }
                        if (lrd.getOffHour() != -1.0f) {
                            ++off_day;
                            off_hour += lrd.getOffHour();
                        }
                        if (lrd.isLateComing()) {
                            ++late_coming_day;
                        }
                        if (!lrd.isEarlyLeaving()) continue;
                        ++early_leaving_day;
                        continue;
                    }
                    if (type.equals("A")) {
                        ++absent_day;
                        continue;
                    }
                    if (type.equals("H")) {
                        ++paid_holiday;
                        continue;
                    }
                    if (type.equals("C")) {
                        ++compensatory_holiday;
                        continue;
                    }
                    if (!type.equals("E")) continue;
                    ++other_day;
                }
            } else {
                userlist = new ArrayList<ExtTimecardResultData>();
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getViewMonth().getValue());
            no_input = cal.getActualMaximum(5) - userlist.size();
            work_hour = ExtTimecardUtils.roundHour(work_hour);
            overtime_hour = ExtTimecardUtils.roundHour(overtime_hour);
            off_hour = ExtTimecardUtils.roundHour(off_hour);
            summary_rd.setUserName(eipUser.getAliasName().getValue());
            summary_rd.setSystemName(timecard_system.getSystemName());
            summary_rd.setWorkDayHour(work_day, work_hour);
            summary_rd.setOvertimeDayHour(overtime_day, overtime_hour);
            summary_rd.setOffDayHour(off_day, off_hour);
            summary_rd.setLateComingDay(late_coming_day);
            summary_rd.setEarlyLeavingDay(early_leaving_day);
            summary_rd.setAbsentDay(absent_day);
            summary_rd.setPaidHoliday(paid_holiday);
            summary_rd.setCompensatoryHoliday(compensatory_holiday);
            summary_rd.setOtherDay(other_day);
            summary_rd.setNoInput(no_input);
            summary_rd.setOwnerId(eipUser.getUserId().getValue());
            list.add(summary_rd);
        }
        return list;
    }

    private boolean sameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        return date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    public void setuserList(String target_group_name) {
        this.target_group_name = target_group_name;
        this.userList = this.target_group_name != null ? (!(this.target_group_name.equals("") || this.target_group_name.equals("all") || this.target_group_name.equals("only")) ? ALEipUtils.getUsers((String)target_group_name) : (this.target_group_name.equals("all") || this.target_group_name.equals("only") ? this.getUserList(Integer.parseInt(this.userid)) : ALEipUtils.getUsers((String)"LoginUser"))) : ALEipUtils.getUsers((String)"LoginUser");
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List<ALEipUser> getUsers() {
        if (this.hasAclSummaryOther) {
            return this.userList;
        }
        try {
            ArrayList<ALEipUser> users = new ArrayList<ALEipUser>();
            users.add(ALEipUtils.getALEipUser((int)Integer.parseInt(this.userid)));
            return users;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        if (this.hasAclSummaryOther) {
            return ALEipManager.getInstance().getPostMap();
        }
        return null;
    }

    public List<ALEipGroup> getMyGroupList() {
        if (this.hasAclSummaryOther) {
            return this.myGroupList;
        }
        return null;
    }

    public String getUserId() {
        return this.userid;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getNowTime() {
        return this.nowtime;
    }

    private String minuteToHour(long minute) {
        BigDecimal decimal = new BigDecimal((double)minute / 60.0);
        DecimalFormat dformat = new DecimalFormat("##.#");
        String str = dformat.format(decimal.setScale(1, 3).doubleValue());
        return str;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public ALDateTimeField getViewStart() {
        return this.viewStart;
    }

    public ALDateTimeField getViewEnd() {
        return this.viewEnd;
    }

    public ALDateTimeField getViewEndCrt() {
        return this.viewEndCrt;
    }

    public ALDateTimeField getPrevMonth() {
        return this.prevMonth;
    }

    public ALDateTimeField getNextMonth() {
        return this.nextMonth;
    }

    public ALDateTimeField getCurrentMonth() {
        return this.currentMonth;
    }

    public ALDateTimeField getViewMonth() {
        return this.viewMonth;
    }

    public String getViewMonthYearMonthText() {
        return ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_YEAR_MONTH_FORMAT", (Object[])new Object[]{this.viewMonth.getYear().toString(), this.viewMonth.getMonth().toString()});
    }

    public ALDateTimeField getToday() {
        return this.today;
    }

    public boolean hasAclUpdate() {
        return this.hasAclUpdate;
    }

    public boolean hasAclInsert() {
        return this.hasAclInsert;
    }

    public boolean hasAclXlsExport() {
        return this.hasAclXlsExport;
    }

    public String getMode() {
        return "summary";
    }

    public String getLoginUserName() {
        try {
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(this.userid));
            return user.getAliasName().toString();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public String getScreenName() {
        return "ExtTimecardSummarySelectData";
    }
}

