/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.orm.query.Where;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilityGroupFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilityGroupFormData.class.getName());
    private ALStringField facility_group_name;
    private String facilitygroupid;
    private List<Object> facilityList;
    private List<FacilityResultData> facilityAllList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.facilityAllList = new ArrayList<FacilityResultData>();
        this.facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());
        this.facilitygroupid = rundata.getParameters().getString("entityid", "");
    }

    public void initField() {
        this.facility_group_name = new ALStringField();
        this.facility_group_name.getFieldName();
        this.facility_group_name.setFieldName(ALLocalizationUtils.getl10n((String)"FACILITIES_FACILITYGROUP_NAME"));
        this.facility_group_name.setTrim(true);
        this.facilityList = new ArrayList<Object>();
    }

    protected void setValidator() {
        this.facility_group_name.setNotNull(true);
        this.facility_group_name.limitMaxLength(50);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            Object[] facilityIds;
            if (res && (facilityIds = rundata.getParameters().getStrings("facility_to")) != null && facilityIds.length > 0) {
                SelectQuery fquery = Database.query(EipMFacility.class);
                Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", (Object[])facilityIds);
                fquery.setQualifier(fexp);
                List facilities = fquery.fetchList();
                for (EipMFacility facility : facilities) {
                    FacilityResultData rd = new FacilityResultData();
                    rd.initField();
                    rd.setFacilityId(facility.getFacilityId().longValue());
                    rd.setFacilityName(facility.getFacilityName());
                    this.facilityList.add(rd);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipMFacilityGroup.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"groupName", (Object)this.facility_group_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"groupName", (Object)this.facility_group_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(this.facilitygroupid));
                query.andQualifier(exp2);
            }
            if (query.fetchList().size() != 0) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"FACILITIES_FACILITYGROUP_IS_ALREADY_ADDED", (Object[])new Object[]{this.facility_group_name.toString()}));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        this.facility_group_name.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMFacilityGroup facility = FacilitiesUtils.getEipMFacilityGroup(rundata, context);
            if (facility == null) {
                return false;
            }
            this.facility_group_name.setValue(facility.getGroupName());
            SelectQuery mapquery = Database.query(EipMFacilityGroupMap.class);
            Expression mapexp = ExpressionFactory.matchExp((String)"GroupId", (Object)facility.getGroupId());
            mapquery.setQualifier(mapexp);
            List FacilityMaps = mapquery.fetchList();
            ArrayList<Integer> facilityIds = new ArrayList<Integer>();
            for (EipMFacilityGroupMap map : FacilityMaps) {
                facilityIds.add(map.getEipMFacilityFacilityId().getFacilityId());
            }
            if (facilityIds.size() > 0) {
                SelectQuery fquery = Database.query(EipMFacility.class);
                Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIds);
                fquery.setQualifier(fexp);
                this.facilityList.addAll(FacilitiesUtils.getFacilitiesFromSelectQuery((SelectQuery<EipMFacility>)fquery));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMFacilityGroup facility = FacilitiesUtils.getEipMFacilityGroup(rundata, context);
            if (facility == null) {
                return false;
            }
            SelectQuery fmaps = Database.query(EipMFacilityGroupMap.class);
            Expression fexp = ExpressionFactory.matchExp((String)"GroupId", (Object)facility.getGroupId());
            fmaps.setQualifier(fexp);
            fmaps.deleteAll();
            Database.delete((Persistent)facility);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(facility.getGroupId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_DELETED_FACILITYGROUP_WITH_NAME", (Object[])new Object[]{facility.getGroupName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMFacilityGroup facilitygroup = (EipMFacilityGroup)Database.create(EipMFacilityGroup.class);
            rundata.getParameters().setProperties((Object)facilitygroup);
            facilitygroup.setGroupName(this.facility_group_name.getValue());
            for (Object record : this.facilityList) {
                FacilityResultData frd = (FacilityResultData)record;
                EipMFacilityGroupMap map = (EipMFacilityGroupMap)Database.create(EipMFacilityGroupMap.class);
                map.setFacilityId(Integer.valueOf((int)frd.getFacilityId().getValue()));
                map.setEipMFacilityGroupId(facilitygroup);
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(facilitygroup.getGroupId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_ADDED_FACILITYGROUP_WITH_NAME", (Object[])new Object[]{facilitygroup.getGroupName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMFacilityGroup facilityGroup = FacilitiesUtils.getEipMFacilityGroup(rundata, context);
            if (facilityGroup == null) {
                return false;
            }
            SelectQuery fmaps = Database.query(EipMFacilityGroupMap.class);
            Expression fexp = ExpressionFactory.matchExp((String)"GroupId", (Object)facilityGroup.getGroupId());
            fmaps.setQualifier(fexp);
            List oldMapList = fmaps.fetchList();
            ArrayList<EipMFacilityGroupMap> newMapList = new ArrayList<EipMFacilityGroupMap>();
            for (Object object : this.facilityList) {
                FacilityResultData frd = (FacilityResultData)object;
                EipMFacilityGroupMap map = new EipMFacilityGroupMap();
                map.setFacilityId(Integer.valueOf((int)frd.getFacilityId().getValue()));
                map.setGroupId(facilityGroup.getGroupId());
                newMapList.add(map);
            }
            ArrayList<Integer> oldMapIdList = new ArrayList<Integer>();
            if (oldMapList.size() > 0) {
                for (EipMFacilityGroupMap map : oldMapList) {
                    oldMapIdList.add(map.getId());
                }
                SelectQuery selectQuery = Database.query(EipMFacilityGroupMap.class);
                selectQuery.where(Operations.and((Where[])new Where[]{Operations.eq((String)"GroupId", (Object)facilityGroup.getGroupId()), Operations.in((String)"FacilityId", oldMapIdList)}));
                selectQuery.deleteAll();
            }
            for (EipMFacilityGroupMap map : newMapList) {
                EipMFacilityGroupMap insert = (EipMFacilityGroupMap)Database.create(EipMFacilityGroupMap.class);
                insert.setFacilityId(map.getFacilityId());
                insert.setGroupId(facilityGroup.getGroupId());
            }
            facilityGroup.setGroupName(this.facility_group_name.getValue());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(facilityGroup.getGroupId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_UPDATED_FACILITYGROUP_WITH_NAME", (Object[])new Object[]{facilityGroup.getGroupName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getFacilityGroupName() {
        return this.facility_group_name;
    }

    public String getFacilityGroupId() {
        return this.facilitygroupid;
    }

    public List<FacilityResultData> getFacilityList() {
        ArrayList<FacilityResultData> _facilityList = new ArrayList<FacilityResultData>();
        for (Object facility : this.facilityList) {
            _facilityList.add((FacilityResultData)facility);
        }
        return _facilityList;
    }
}

