/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LoggingInputStream
extends FilterInputStream {
    private OutputStream logOutput;

    public LoggingInputStream(InputStream inputStream, OutputStream outputStream) {
        super(inputStream);
        this.logOutput = outputStream;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        this.logOutput.write(n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        this.logOutput.write(byArray, n, n3);
        return n3;
    }

    public void close() throws IOException {
        this.logOutput.flush();
        this.in.close();
    }
}

