/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.text;

import com.sk_jp.text.AbstractTextFormatter;
import com.sk_jp.text.EntityRefEncoder;
import com.sk_jp.text.Translator;
import com.sk_jp.text.formatter.FormatCommand;
import com.sk_jp.text.formatter.ParseException;
import com.sk_jp.text.formatter.TextFormatterParser;
import com.sk_jp.text.formatter.User_UCode_UCodeESC_CharStream;
import com.sk_jp.text.html.TagReformatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TextFormatter
extends AbstractTextFormatter {
    private List list;
    private static final Translator T = new TagReformatter(6);
    private Translator translator = T;

    public TextFormatter() {
    }

    public TextFormatter(String string) throws IOException {
        this.setSourceFromFile(string);
    }

    public TextFormatter(String string, String string2) throws IOException {
        this.setSourceFromFile(string, string2);
    }

    public TextFormatter(URL uRL) throws IOException {
        this.setSource(uRL);
    }

    public TextFormatter(URL uRL, String string) throws IOException {
        this.setSource(uRL, string);
    }

    public TextFormatter(InputStream inputStream) throws IOException {
        this.setSource(inputStream);
    }

    public TextFormatter(InputStream inputStream, String string) throws IOException {
        this.setSource(inputStream, string);
    }

    public TextFormatter(Reader reader) throws IOException {
        this.setSource(reader);
    }

    public void setSource(Reader reader) throws IOException {
        TextFormatterParser textFormatterParser = new TextFormatterParser(new User_UCode_UCodeESC_CharStream(reader, 0, 0));
        try {
            textFormatterParser.parse();
        }
        catch (ParseException parseException) {
            throw new WrappedParseException(parseException);
        }
        this.list = textFormatterParser.getList();
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    public String format(Map map, boolean bl) {
        StringWriter stringWriter = new StringWriter(2048);
        try {
            this.format(map, stringWriter, bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void format(Map map, Writer writer) throws IOException {
        this.format(map, writer, false);
    }

    public void format(Map map, Writer writer, boolean bl) throws IOException {
        if (bl) {
            this.format(this.list, map, map, writer);
        } else {
            this.format(this.list, null, map, writer);
        }
    }

    private void format(List list, Map map, Map map2, Writer writer) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        block9: while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                writer.write((String)e);
                writer.flush();
                continue;
            }
            FormatCommand formatCommand = (FormatCommand)e;
            switch (formatCommand.kind) {
                case 1: {
                    String string;
                    boolean bl;
                    if (formatCommand.key.startsWith("normalized")) {
                        bl = true;
                        string = formatCommand.key.substring("normalized".length());
                    } else {
                        bl = false;
                        string = formatCommand.key;
                    }
                    Object v = map2.get(string);
                    if (v != null) {
                        if (bl) {
                            writer.write(EntityRefEncoder.encode(v.toString()));
                            continue block9;
                        }
                        writer.write(v.toString());
                        continue block9;
                    }
                    if (map == null || (v = map.get(string)) == null) continue block9;
                    if (bl) {
                        writer.write(EntityRefEncoder.encode(v.toString()));
                        continue block9;
                    }
                    writer.write(v.toString());
                    continue block9;
                }
                case 2: {
                    Object v = map2.get(formatCommand.key);
                    if (v != null) {
                        writer.write(EntityRefEncoder.encode(v.toString()));
                        continue block9;
                    }
                    if (map == null || (v = map.get(formatCommand.key)) == null) continue block9;
                    writer.write(EntityRefEncoder.encode(v.toString()));
                    continue block9;
                }
                case 3: {
                    Object v = map2.get(formatCommand.key);
                    if (v != null) {
                        this.translator.translate(new StringReader(v.toString()), writer);
                        continue block9;
                    }
                    if (map == null || (v = map.get(formatCommand.key)) == null) continue block9;
                    this.translator.translate(new StringReader(v.toString()), writer);
                    continue block9;
                }
                case 4: {
                    Object v = map2.get(formatCommand.key);
                    if (v != null) {
                        this.format(formatCommand.child, map, map2, writer);
                        continue block9;
                    }
                    this.format(formatCommand.childelse, map, map2, writer);
                    continue block9;
                }
                case 5: 
                case 6: {
                    boolean bl;
                    Object v = map2.get(formatCommand.key);
                    if (formatCommand.value.equals(v)) {
                        bl = formatCommand.kind == 5;
                    } else {
                        boolean bl2 = bl = formatCommand.kind == 6;
                    }
                    if (bl) {
                        this.format(formatCommand.child, map, map2, writer);
                        continue block9;
                    }
                    this.format(formatCommand.childelse, map, map2, writer);
                    continue block9;
                }
                case 7: {
                    Object object;
                    Object v = map2.get(formatCommand.key);
                    if (v == null) continue block9;
                    if (v instanceof Map[]) {
                        object = (Map[])v;
                        for (int i = 0; i < ((Object[])object).length; ++i) {
                            this.format(formatCommand.child, map, (Map)object[i], writer);
                        }
                        continue block9;
                    }
                    if (v instanceof List) {
                        object = ((List)v).iterator();
                        while (object.hasNext()) {
                            Map map3 = (Map)object.next();
                            this.format(formatCommand.child, map, map3, writer);
                        }
                        continue block9;
                    }
                    if (v instanceof String) {
                        // empty if block
                    }
                    throw new FormatException("Map value of key [" + formatCommand.key + "] was " + v.getClass() + ".\nIt must be Map[] or List of Map.\n" + "Because this context is WHILE.");
                }
                case 8: {
                    Object object;
                    Object v = map2.get(formatCommand.key);
                    if (v == null) continue block9;
                    if (v instanceof Object[]) {
                        object = (Object[])v;
                        for (int i = 0; i < ((Object[])object).length; ++i) {
                            map2.put(formatCommand.key, object[i]);
                            this.format(formatCommand.child, map, map2, writer);
                        }
                        map2.put(formatCommand.key, v);
                        continue block9;
                    }
                    if (v instanceof Collection) {
                        object = ((Collection)v).iterator();
                        while (object.hasNext()) {
                            map2.put(formatCommand.key, object.next());
                            this.format(formatCommand.child, map, map2, writer);
                        }
                        map2.put(formatCommand.key, v);
                        continue block9;
                    }
                    if (v instanceof Map) {
                        object = (Map)v;
                        Iterator iterator2 = object.keySet().iterator();
                        while (iterator2.hasNext()) {
                            Object k = iterator2.next();
                            map2.put(formatCommand.key, k);
                            map2.put(formatCommand.key + ".value", object.get(k));
                            this.format(formatCommand.child, map, map2, writer);
                        }
                        map2.put(formatCommand.key, v);
                        continue block9;
                    }
                    throw new FormatException("Map value of key[" + formatCommand.key + "] is " + v.getClass() + ".\n" + "It must be the Object[] " + "or the Collection.\n" + "Because this context is FOREACH.");
                }
            }
            throw new RuntimeException("Unsupported command");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 11; ++i) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("loop", "\u306a\u3093\u3070\u30fc" + i);
            arrayList.add(hashMap2);
        }
        Object[] objectArray = new Object[]{"\u3072\u3068\u3064\u3081\u3060", new Date(), "\u307f\u3063\u3064\u3081"};
        hashMap.put("array", objectArray);
        hashMap.put("\u3042", "\u3042\u3044\u3046\u3048\u304a");
        hashMap.put("key1", "\u6728\u4e0b\u4fe1");
        hashMap.put("key2", "\u6728\u4e0b\u4fe11]");
        hashMap.put("\u3042\u3044\u3046\u3048\u304a", arrayList);
        hashMap.put("if", "\u6728\u4e0b\u4fe13]");
        TextFormatter textFormatter = new TextFormatter(inputStreamReader);
        PrintWriter printWriter = new PrintWriter(System.out);
        textFormatter.format(hashMap, printWriter);
        printWriter.flush();
    }

    private static class FormatException
    extends RuntimeException {
        public FormatException(String string) {
            super(string);
        }
    }

    private static class WrappedParseException
    extends RuntimeException {
        public final ParseException source;

        public WrappedParseException(ParseException parseException) {
            this.source = parseException;
        }

        public String getMessage() {
            return this.source.getMessage();
        }

        public void printStackTrace() {
            this.source.printStackTrace();
        }
    }
}

