/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbookuser.util;

import com.aimluck.eip.addressbookuser.beans.AddressBookUserEmailLiteBean;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserGroupLiteBean;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserLiteBean;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class AddressBookUserUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookUserUtils.class.getName());

    public static List<AddressBookUserLiteBean> getAddressBookUserLiteBeansFromGroup(String groupid, int loginuserid) {
        ArrayList<AddressBookUserLiteBean> list = new ArrayList<AddressBookUserLiteBean>();
        try {
            SelectQuery<EipMAddressbook> query = AddressBookUserUtils.getSelectQueryForAddressBook(groupid, loginuserid);
            List addressbook_list = query.fetchList();
            for (EipMAddressbook record : addressbook_list) {
                AddressBookUserLiteBean address = new AddressBookUserLiteBean();
                address.initField();
                address.setAddressId(record.getAddressId());
                address.setFullName(record.getLastName(), record.getFirstName());
                list.add(address);
            }
        }
        catch (Exception e) {
            logger.error((Object)"AddressBookUserUtils.getAddressBookUserLiteBeansFromGroup", (Throwable)e);
        }
        return list;
    }

    public static List<AddressBookUserGroupLiteBean> getAddressBookUserGroupLiteBeans(RunData rundata) {
        ArrayList<AddressBookUserGroupLiteBean> list = new ArrayList<AddressBookUserGroupLiteBean>();
        try {
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp).orderAscending("groupName");
            List addressgroup_list = query.fetchList();
            for (EipMAddressGroup record : addressgroup_list) {
                AddressBookUserGroupLiteBean bean = new AddressBookUserGroupLiteBean();
                bean.initField();
                bean.setGroupId(record.getGroupId());
                bean.setName(record.getGroupName());
                list.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)"AddressBookUserUtils.getAddressBookUserGroupLiteBeans", (Throwable)e);
        }
        return list;
    }

    public static List<AddressBookUserEmailLiteBean> getAddressBookUserEmailLiteBeansFromGroup(String groupid, int loginuserid) {
        ArrayList<AddressBookUserEmailLiteBean> list = new ArrayList<AddressBookUserEmailLiteBean>();
        try {
            SelectQuery<EipMAddressbook> query = AddressBookUserUtils.getSelectQueryForAddressBook(groupid, loginuserid);
            List addressbook_list = query.fetchList();
            for (EipMAddressbook record : addressbook_list) {
                AddressBookUserEmailLiteBean bean = new AddressBookUserEmailLiteBean();
                bean.initField();
                bean.setAddressId(record.getAddressId());
                bean.setFullName(record.getLastName(), record.getFirstName());
                bean.setEmail(record.getEmail());
                list.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)"AddressBookUserUtils.getAddressBookUserEmailLiteBeansFromGroup", (Throwable)e);
        }
        return list;
    }

    private static SelectQuery<EipMAddressbook> getSelectQueryForAddressBook(String groupid, int loginuserid) {
        SelectQuery query = Database.query(EipMAddressbook.class);
        Expression exp21 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        Expression exp22 = ExpressionFactory.matchExp((String)"ownerId", (Object)loginuserid);
        Expression exp23 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
        query.setQualifier(exp21.orExp(exp22.andExp(exp23)));
        if (groupid != null && !"".equals(groupid) && !"all".equals(groupid)) {
            Expression exp31 = ExpressionFactory.matchDbExp((String)"eipTAddressbookGroupMap.eipTAddressGroup.GROUP_ID", (Object)groupid);
            query.andQualifier(exp31);
        }
        return query;
    }
}

