/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.modules.screens.ALJSONScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.gadgets.ALGadgetContext;
import com.aimluck.eip.services.social.gadgets.ALGadgetSpec;
import com.aimluck.eip.util.ALEipUtils;
import com.google.inject.internal.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GadgetsSecurityTokenUpdateJSONScreen
extends ALJSONScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GadgetsSecurityTokenUpdateJSONScreen.class.getName());

    protected String getJSONString(RunData rundata, Context context) throws Exception {
        JSONArray result = new JSONArray();
        try {
            String view = rundata.getParameters().getString("view");
            if (!("home".equals(view) || "canvas".equals(view) || "popup".equals(view) || "default".equals(view))) {
                view = "home";
            }
            String update = rundata.getParameters().getString("update");
            boolean isUpdate = "1".equals(update);
            String payload = this.getPayload(rundata);
            JSONArray jsonArray = JSONArray.fromObject((Object)payload);
            if (jsonArray != null) {
                ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
                String orgId = Database.getDomainName();
                String viewer = orgId + ":" + user.getName().getValue();
                Object[] array = jsonArray.toArray();
                ArrayList urls = Lists.newArrayList();
                for (Object obj : array) {
                    JSONObject jsonObject = JSONObject.fromObject((Object)obj);
                    String specUrl = jsonObject.getString("specUrl");
                    urls.add(specUrl);
                }
                Map metaData = ALApplicationService.getMetaData((List)urls, (String)view, (boolean)false, (boolean)false);
                for (Object obj : array) {
                    JSONObject jsonObject = JSONObject.fromObject((Object)obj);
                    Long mid = jsonObject.getLong("id");
                    String appId = jsonObject.getString("appId");
                    String portletId = jsonObject.getString("portletId");
                    String specUrl = jsonObject.getString("specUrl");
                    String activeUrl = jsonObject.getString("activeUrl");
                    ALGadgetSpec spec = (ALGadgetSpec)metaData.get(specUrl);
                    ALGadgetContext gadgetContext = null;
                    if (isUpdate) {
                        gadgetContext = new ALGadgetContext(rundata, viewer, appId, specUrl, mid.longValue(), activeUrl);
                    }
                    JSONObject resultObj = new JSONObject();
                    resultObj.put((Object)"id", (Object)mid);
                    resultObj.put((Object)"appId", (Object)appId);
                    resultObj.put((Object)"portletId", (Object)portletId);
                    resultObj.put((Object)"specUrl", (Object)specUrl);
                    resultObj.put((Object)"secureToken", (Object)(isUpdate ? gadgetContext.getSecureToken() : null));
                    resultObj.put((Object)"activeUrl", (Object)activeUrl);
                    resultObj.put((Object)"height", (Object)(spec == null ? 200 : spec.getHeight()));
                    resultObj.put((Object)"scrolling", (Object)(spec == null ? false : spec.isScrolling()));
                    resultObj.put((Object)"views", spec == null ? null : spec.get((Object)"views"));
                    result.add((Object)resultObj);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"[GadgetsSecurityTokenUpdateJSONScreen]", (Throwable)e);
        }
        return result.toString();
    }

    protected String getPrefix() {
        return "";
    }

    protected String getSuffix() {
        return "";
    }
}

