/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timeline;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.timeline.TimelineLikeResultData;
import com.aimluck.eip.timeline.TimelineUrlResultData;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimelineResultData
implements ALData {
    private ALNumberField timeline_id;
    private ALNumberField parent_id;
    private ALNumberField owner_id;
    private String timeline_type;
    private String app_id;
    private boolean is_public;
    private boolean new_topic;
    private ALStringField note;
    private ALNumberField reply_count;
    private ALStringField create_user;
    private ALDateTimeField create_date;
    private ALDateTimeField update_date;
    private List<TimelineResultData> coTopicList;
    private List<TimelineResultData> coActivityList;
    private List<TimelineLikeResultData> likeList;
    private List<TimelineUrlResultData> urlList;
    private boolean like;
    private List<FileuploadBean> attachmentFileList = null;
    private ALStringField params;
    private String portletId;
    private int likeCount;
    private ALEipUser user = null;
    private static final int PRE_NOTE_LENGTH = 500;

    public void initField() {
        this.timeline_id = new ALNumberField();
        this.parent_id = new ALNumberField();
        this.owner_id = new ALNumberField();
        this.params = new ALStringField();
        this.note = new ALStringField();
        this.note.setTrim(false);
        this.reply_count = new ALNumberField();
        this.create_user = new ALStringField();
        this.create_date = new ALDateTimeField();
        this.update_date = new ALDateTimeField();
        this.is_public = true;
        this.new_topic = false;
        this.like = false;
        this.attachmentFileList = new ArrayList<FileuploadBean>();
        this.likeCount = 0;
    }

    public ALNumberField getTimelineId() {
        return this.timeline_id;
    }

    public void setTimelineId(long i) {
        this.timeline_id.setValue(i);
    }

    public void setParentId(long i) {
        this.parent_id.setValue(i);
    }

    public ALNumberField getParentId() {
        return this.parent_id;
    }

    public void setOwnerId(long i) {
        this.owner_id.setValue(i);
    }

    public ALNumberField getOwnerId() {
        return this.owner_id;
    }

    public ALStringField getOwnerName() {
        ALStringField field = new ALStringField();
        ALEipUser user = this.getUser();
        if (user != null) {
            field.setValue(user.getAliasName().getValue());
        }
        return field;
    }

    public String getNote() {
        return ALEipUtils.getMessageList((String)this.note.getValue());
    }

    public boolean isLongNote() {
        return this.note.getValue().length() > 500;
    }

    private boolean isLastWordAddress(String sub) {
        String nextSub;
        if (sub.indexOf("http") != -1 && sub.lastIndexOf("http") > sub.lastIndexOf(" ") && sub.lastIndexOf("http") > sub.lastIndexOf("\n")) {
            return true;
        }
        return sub.indexOf("h") != -1 && sub.lastIndexOf("h") > sub.lastIndexOf(" ") && sub.lastIndexOf("h") > sub.lastIndexOf("\n") && (nextSub = this.note.getValue().substring(sub.lastIndexOf("h"), sub.lastIndexOf("h") + 4)).equals("http");
    }

    public String getPreviewNote() {
        if (this.isLongNote()) {
            try {
                int i;
                String subnote = ALEipUtils.getMessageList((String)this.note.getValue().substring(0, 500));
                String sub = this.note.getValue().substring(0, 500);
                if (!this.isLastWordAddress(sub)) {
                    return subnote;
                }
                sub = this.note.getValue();
                for (i = 500; i < sub.length() && sub.charAt(i) != ' ' && sub.charAt(i) != '\n'; ++i) {
                }
                subnote = ALEipUtils.getMessageList((String)this.note.getValue().substring(0, i));
                return subnote;
            }
            catch (Exception ex) {
                return this.getNote();
            }
        }
        if ("A".equals(this.timeline_type)) {
            return this.note.toString();
        }
        return this.getNote();
    }

    public String getDetailNote() {
        if (this.isLongNote()) {
            int i;
            String subnote = ALEipUtils.getMessageList((String)this.note.getValue().substring(500));
            String sub = this.note.getValue().substring(0, 500);
            if (!this.isLastWordAddress(sub)) {
                return subnote;
            }
            sub = this.note.getValue();
            for (i = 500; i < sub.length() && sub.charAt(i) != ' ' && sub.charAt(i) != '\n'; ++i) {
            }
            subnote = ALEipUtils.getMessageList((String)this.note.getValue().substring(i));
            return subnote;
        }
        return null;
    }

    public boolean isDetailNote() {
        return this.getDetailNote() != null && !"".equals(this.getDetailNote());
    }

    public void setNote(String string) {
        this.note.setValue(string);
    }

    public ALDateTimeField getCreateDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.create_date);
    }

    public ALDateTimeField getUpdateDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.update_date);
    }

    public void setCreateDate(Date date) {
        this.create_date.setValue(date);
    }

    public void setUpdateDate(Date date) {
        if (date == null) {
            return;
        }
        this.update_date.setValue(date);
    }

    public ALStringField getCreateUser() {
        return this.create_user;
    }

    public void setCreateUser(String str) {
        this.create_user.setValue(str);
    }

    public String getReplyCountText() {
        return ALLocalizationUtils.getl10nFormat((String)"TIMELINE_REPLAY_COUNT_TEXT", (Object[])new Object[]{this.reply_count.toString()});
    }

    public String getLikeCountText() {
        return ALLocalizationUtils.getl10nFormat((String)"TIMELINE_LIKE_COUNT_TEXT", (Object[])new Object[]{this.likeCount});
    }

    public boolean isPublic() {
        return this.is_public;
    }

    public void setPublicFlag(boolean bool) {
        this.is_public = bool;
    }

    public boolean isNew() {
        return this.new_topic;
    }

    public void setNewTopicFlag(boolean bool) {
        this.new_topic = bool;
    }

    public void setReplyCount(long count) {
        this.reply_count.setValue(count);
    }

    public ALNumberField getReplyCount() {
        return this.reply_count;
    }

    public List<TimelineResultData> getCoTopicList() {
        return this.coTopicList;
    }

    public void setCoTopicList(List<TimelineResultData> coTopicList) {
        this.coTopicList = coTopicList == null ? new ArrayList(0) : coTopicList;
    }

    public List<TimelineResultData> getCoActivityList() {
        return this.coActivityList;
    }

    public void setCoActivityList(List<TimelineResultData> coActivityList) {
        this.coActivityList = coActivityList == null ? new ArrayList(0) : coActivityList;
    }

    public List<TimelineLikeResultData> getLikeList() {
        return this.likeList;
    }

    public void setLikeList(List<TimelineLikeResultData> likeList) {
        this.likeList = likeList;
    }

    public List<TimelineUrlResultData> getUrlList() {
        return this.urlList;
    }

    public void setUrlList(List<TimelineUrlResultData> urlList) {
        this.urlList = urlList;
    }

    public Integer getReplyCountInteger() {
        return (int)this.reply_count.getValue();
    }

    public boolean hasPhoto() {
        ALEipUser user = this.getUser();
        if (user != null) {
            return user.hasPhoto();
        }
        return false;
    }

    public List<FileuploadBean> getAttachmentFileList() {
        return this.attachmentFileList;
    }

    public void setAttachmentFileList(List<FileuploadBean> attachmentFileList) {
        this.attachmentFileList = attachmentFileList == null ? new ArrayList(0) : attachmentFileList;
    }

    public boolean isLike() {
        return this.like;
    }

    public void setLike(boolean like) {
        this.like = like;
    }

    public void setTimelineType(String timeline_type) {
        this.timeline_type = timeline_type;
    }

    public String getTimelineType() {
        return this.timeline_type;
    }

    public void setAppId(String app_id) {
        this.app_id = app_id;
    }

    public String getAppId() {
        return this.app_id;
    }

    public boolean isNotActivityParent() {
        if (this.app_id == null) {
            return true;
        }
        if (this.app_id.isEmpty()) {
            return true;
        }
        return !this.app_id.equals("ACTIVITY_PARENT");
    }

    public void setParams(String params) {
        this.params.setValue(params);
    }

    public ALStringField getParams() {
        return this.params;
    }

    public String getPopupUrl() {
        String portletParams = this.getParams().getValue();
        if (portletParams != null && portletParams.length() > 0) {
            StringBuilder b = new StringBuilder(portletParams);
            return b.toString();
        }
        return "";
    }

    public int getLikeCount() {
        return this.likeCount;
    }

    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }

    public long getPhotoModified() {
        ALEipUser user = this.getUser();
        if (user != null) {
            return user.getPhotoModified();
        }
        return 0L;
    }

    public ALEipUser getUser() {
        if (this.user == null) {
            this.user = ALEipManager.getInstance().getUser(Integer.valueOf((int)this.owner_id.getValue()));
        }
        return this.user;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }

    public String getPortletId() {
        return this.portletId;
    }
}

