/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.social.Activity;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.workflow.WorkflowCategoryResultData;
import com.aimluck.eip.workflow.WorkflowResultData;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowAllSelectData
extends ALAbstractSelectData<EipTWorkflowRequest, EipTWorkflowRequest>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowAllSelectData.class.getName());
    public static final String TAB_UNFINISHED = "unfinished";
    public static final String TAB_FINISHED = "finished";
    public static final String TAB_ALLDISPLAY = "alldisplay";
    private String currentTab;
    private List<WorkflowCategoryResultData> categoryList;
    private List<WorkflowRouteResultData> routeList;
    private int requestSum;
    private ALEipUser login_user;
    private String aclPortletFeature;
    private ALNumberField previous_id;
    private ALStringField target_keyword;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        int uid;
        Integer entityId;
        int aimUserId;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sorttype = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        if ("create_date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && (sorttype == null || "".equals(sorttype))) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        String allTabParam = rundata.getParameters().getString("alltab");
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            this.currentTab = null;
        } else if (tabParam != null) {
            this.currentTab = tabParam;
        }
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"alltab", (String)allTabParam);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)this.currentTab);
        try {
            VelocityPortlet portlet;
            String categoryId;
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            if (filter == null && (categoryId = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-category")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)categoryId);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"category");
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Exception", (Throwable)ex);
        }
        this.target_keyword = new ALStringField();
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        super.init(action, rundata, context);
        String entityId_Str = rundata.getParameters().getString("entityid");
        this.aclPortletFeature = entityId_Str == null || "".equals(entityId_Str) ? "workflow_request_other" : ((aimUserId = this.getUserId(rundata, context, entityId = Integer.valueOf(Integer.parseInt(entityId_Str)))) != (uid = ALEipUtils.getUserId((RunData)rundata)) ? "workflow_request_other" : "workflow_request_self");
        try {
            this.previous_id = new ALNumberField();
            String previd = rundata.getParameters().getString("prvid");
            if (previd == null) {
                previd = rundata.getParameters().getString("entityid");
            }
            this.previous_id.setValue(previd);
        }
        catch (Exception e) {
            this.previous_id = null;
        }
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = WorkflowUtils.loadCategoryList(rundata, context);
    }

    public void loadRouteList(RunData rundata, Context context) {
        this.routeList = WorkflowUtils.loadRouteList(rundata, context);
    }

    public ResultList<EipTWorkflowRequest> selectList(RunData rundata, Context context) {
        try {
            if (WorkflowUtils.hasResetFlag(rundata, context)) {
                WorkflowUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
            } else {
                this.target_keyword.setValue(WorkflowUtils.getTargetKeyword(rundata, context));
            }
            SelectQuery<EipTWorkflowRequest> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.requestSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTWorkflowRequest> getSelectQuery(RunData rundata, Context context) {
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR, (String)this.target_keyword.getValue());
        } else {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR);
        }
        SelectQuery query = Database.query(EipTWorkflowRequest.class);
        if (this.currentTab != null) {
            if (TAB_UNFINISHED.equals(this.currentTab)) {
                Expression exp1 = ExpressionFactory.noMatchExp((String)"progress", (Object)"A");
                query.setQualifier(exp1);
            } else if (TAB_FINISHED.equals(this.currentTab)) {
                Expression exp1 = ExpressionFactory.matchExp((String)"progress", (Object)"A");
                query.setQualifier(exp1);
            }
        }
        return this.buildSelectQueryForFilter((SelectQuery<EipTWorkflowRequest>)query, rundata, context);
    }

    protected SelectQuery<EipTWorkflowRequest> buildSelectQueryForFilter(SelectQuery<EipTWorkflowRequest> query, RunData rundata, Context context) {
        String search;
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter_type != null) {
            crt_key = map.getValue(filter_type);
        }
        if (filter != null && filter_type != null && !filter.equals("") && crt_key != null) {
            Expression exp = ExpressionFactory.matchDbExp((String)crt_key, (Object)filter);
            query.andQualifier(exp);
            this.current_filter = filter;
            this.current_filter_type = filter_type;
        }
        if ((search = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR)) != null && !search.equals("")) {
            this.current_search = search;
            Expression ex1 = ExpressionFactory.likeExp((String)"note", (Object)("%" + search + "%"));
            Expression ex11 = ExpressionFactory.likeExp((String)"note", (Object)("%" + search + "%"));
            Expression ex2 = ExpressionFactory.likeExp((String)"requestName", (Object)("%" + search + "%"));
            Expression ex3 = ExpressionFactory.likeExp((String)"eipTWorkflowCategory.categoryName", (Object)("%" + search + "%"));
            SelectQuery q = Database.query(EipTWorkflowRequest.class);
            SelectQuery qm = Database.query(EipTWorkflowRequestMap.class);
            q.andQualifier(ex1.orExp(ex2).orExp(ex3));
            qm.andQualifier(ex11);
            List queryList = q.fetchList();
            List queryListMap = qm.fetchList();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (EipTWorkflowRequest item : queryList) {
                if (item.getParentId() != 0 && !resultid.contains(item.getParentId())) {
                    resultid.add(item.getParentId());
                    continue;
                }
                if (resultid.contains(item.getRequestId())) continue;
                resultid.add(item.getRequestId());
            }
            for (EipTWorkflowRequest item : queryListMap) {
                if (item.getEipTWorkflowRequest().getParentId() != 0 && !resultid.contains(item.getEipTWorkflowRequest().getParentId())) {
                    resultid.add(item.getEipTWorkflowRequest().getParentId());
                    continue;
                }
                if (resultid.contains(item.getEipTWorkflowRequest().getRequestId())) continue;
                resultid.add(item.getEipTWorkflowRequest().getRequestId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex = ExpressionFactory.inDbExp((String)"REQUEST_ID", resultid);
            query.andQualifier(ex);
        }
        return query;
    }

    protected Object getResultData(EipTWorkflowRequest record) {
        try {
            WorkflowResultData rd = new WorkflowResultData();
            rd.initField();
            rd.setRequestId(record.getRequestId().intValue());
            rd.setCategoryId(record.getEipTWorkflowCategory().getCategoryId().longValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)record.getEipTWorkflowCategory().getCategoryName(), (int)this.getStrLength()));
            rd.setRequestName(ALCommonUtils.compressString((String)record.getRequestName(), (int)this.getStrLength()));
            rd.setPriority(record.getPriority().intValue());
            rd.setPriorityImage(WorkflowUtils.getPriorityImage(record.getPriority().intValue()));
            rd.setPriorityString(WorkflowUtils.getPriorityString(record.getPriority().intValue()));
            rd.setProgress(record.getProgress());
            rd.setPrice(record.getPrice());
            Expression exp2 = ExpressionFactory.matchExp((String)"externalId", (Object)rd.getRequestId());
            Expression exp3 = ExpressionFactory.matchExp((String)"appId", (Object)"Workflow");
            Expression exp4 = exp2.andExp(exp3);
            List list = Database.query(Activity.class, (Expression)exp4).fetchList();
            for (Activity activity : list) {
                rd.setActivityId(activity.getId());
            }
            ALEipUser LastUpdateUser = new ALEipUser();
            EipTWorkflowRequestMap map = null;
            List<EipTWorkflowRequestMap> maps = WorkflowUtils.getEipTWorkflowRequestMap(record);
            int size = maps.size();
            if ("A".equals(record.getProgress())) {
                map = maps.get(size - 1);
                LastUpdateUser = ALEipUtils.getALEipUser((int)map.getUserId());
            } else {
                for (int i = 0; i < size; ++i) {
                    map = maps.get(i);
                    if (!"C".equals(map.getStatus())) continue;
                    LastUpdateUser = ALEipUtils.getALEipUser((int)map.getUserId());
                    break;
                }
            }
            ALEipUser clientUser = ALEipUtils.getALEipUser((TurbineUser)record.getTurbineUser());
            rd.setClientUser(clientUser);
            String state = "";
            state = "A".equals(record.getProgress()) ? ALLocalizationUtils.getl10n((String)"WORKFLOW_COMPLETION") : ("W".equals(record.getProgress()) ? ALLocalizationUtils.getl10n((String)"WORKFLOW_PROGRESS") : ALLocalizationUtils.getl10n((String)"WORKFLOW_DENIAL"));
            rd.setStateString(state);
            rd.setLastUpdateUser(LastUpdateUser);
            rd.setCreateDateTime(record.getCreateDate());
            rd.setCreateDate(WorkflowUtils.translateDate(record.getCreateDate(), ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY_HOUR_MINIT")));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    private int getUserId(RunData rundata, Context context, Integer entityId) {
        Expression exp = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)entityId);
        SelectQuery query = Database.query(EipTWorkflowRequest.class, (Expression)exp);
        List record = query.fetchList();
        if (record.size() > 0) {
            return ((EipTWorkflowRequest)record.get(0)).getUserId();
        }
        return -1;
    }

    public EipTWorkflowRequest selectDetail(RunData rundata, Context context) {
        return WorkflowUtils.getEipTWorkflowRequestAll(rundata, context);
    }

    protected Object getResultDataDetail(EipTWorkflowRequest obj) {
        return WorkflowUtils.getResultDataDetail(obj, this.login_user);
    }

    public List<WorkflowCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    public List<WorkflowRouteResultData> getRouteList() {
        return this.routeList;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public int getRequestSum() {
        return this.requestSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("request_name", "requestName");
        map.putValue("priority", "priority");
        map.putValue("price", "price");
        map.putValue("create_date", "createDate");
        map.putValue("progress", "progress");
        map.putValue("category", "CATEGORY_ID");
        map.putValue("user_name", "turbineUser.lastNameKana");
        return map;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public ALNumberField getPreviousID() {
        return this.previous_id;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean hasAuthorityOther() {
        return this.hasAuthority;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }
}

