/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbRecordSelectData;
import com.aimluck.eip.gpdb.GpdbResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbItemSelectData
extends ALAbstractSelectData<EipTGpdbItem, EipTGpdbItem>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbItemSelectData.class.getName());
    private int gpdbSum;
    private List<GpdbResultData> gpdbAllList;
    private String gpdbId;
    private static final String RECORD_LIST_FILTER_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("filter").toString();

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"sort");
        }
        this.gpdbAllList = GpdbUtils.getGpdbAllList();
        super.init(action, rundata, context);
    }

    protected ResultList<EipTGpdbItem> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTGpdbItem> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            query.orderAscending("orderNo");
            ResultList list = query.getResultList();
            this.gpdbSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTGpdbItem> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTGpdbItem.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected EipTGpdbItem selectDetail(RunData rundata, Context context) {
        return GpdbUtils.getEipTGpdbItem(rundata, context);
    }

    protected Object getResultData(EipTGpdbItem record) {
        return GpdbUtils.getGpdbItemResultData(record);
    }

    protected Object getResultDataDetail(EipTGpdbItem record) {
        return GpdbUtils.getGpdbItemResultData(record);
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("gpdb_id", "gpdb");
        return map;
    }

    public int getGpdbSum() {
        return this.gpdbSum;
    }

    public List<GpdbResultData> getGpdbAllList() {
        return this.gpdbAllList;
    }

    public boolean displayField(String field, String type) {
        return GpdbUtils.dipslayField(field, type);
    }

    public void setGpdbId(Context context, RunData rundata) {
        String gpdbId = rundata.getParameters().getString("filter", "");
        String reset = rundata.getParameters().getString("reset_keyword_params", "");
        if ("true".equals(reset)) {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        }
        String sesGpdbId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)RECORD_LIST_FILTER_STR);
        String itemGpdbId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        if ("".equals(gpdbId)) {
            String string = gpdbId = null == itemGpdbId ? "" : itemGpdbId;
        }
        if ("".equals(gpdbId)) {
            gpdbId = null == sesGpdbId ? "" : sesGpdbId;
        }
        String filterType = rundata.getParameters().getString("filtertype", "");
        List<GpdbResultData> gpdbAllList = GpdbUtils.getGpdbAllList();
        if (gpdbId != null && !"".equals(gpdbId) && ("gpdb_id".equals(filterType) || filterType == null || "".equals(filterType))) {
            for (GpdbResultData gpdb : gpdbAllList) {
                if (!gpdb.getGpdbId().toString().equals(gpdbId)) continue;
                this.gpdbId = gpdbId;
            }
        }
        if (this.gpdbId == null && gpdbAllList.size() > 0) {
            this.gpdbId = gpdbAllList.get((int)0).gpdb_id.toString();
        }
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)this.gpdbId);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"gpdb_id");
    }
}

