/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubun;
import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubunValue;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbKubunValueResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbKubunChangeTurnFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbKubunChangeTurnFormData.class.getName());
    private ALStringField positions;
    private String[] gpdbKubunValueIds = null;
    private List<GpdbKubunValueResultData> gpdbKubunValueList = null;
    private List<EipMGpdbKubunValue> rawGpdbKubunValueList = null;
    private Integer kubunId = null;
    private EipMGpdbKubun kubun = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.gpdbKubunValueList = new ArrayList<GpdbKubunValueResultData>();
        this.rawGpdbKubunValueList = new ArrayList<EipMGpdbKubunValue>();
        this.kubunId = rundata.getParameters().getInteger("gpdb_kubun_id");
        this.kubun = GpdbUtils.getEipMGpdbKubun(this.kubunId);
    }

    public void initField() {
        this.positions = new ALStringField();
        this.positions.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_VALUE_LIST"));
        this.positions.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = true;
        try {
            res = super.setFormData(rundata, context, msgList);
            if (res) {
                if (this.positions.getValue() == null || this.positions.getValue().equals("")) {
                    SelectQuery query = Database.query(EipMGpdbKubunValue.class);
                    query.andQualifier(ExpressionFactory.matchExp((String)"gpdbKubun", (Object)this.kubun));
                    query.orderAscending("orderNo");
                    this.gpdbKubunValueList = GpdbUtils.getGpdbKubunValueResultList(query.fetchList());
                } else {
                    StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
                    this.gpdbKubunValueIds = new String[st.countTokens()];
                    int count = 0;
                    while (st.hasMoreTokens()) {
                        this.gpdbKubunValueIds[count] = st.nextToken();
                        ++count;
                    }
                    SelectQuery query = Database.query(EipMGpdbKubunValue.class);
                    List list = query.fetchList();
                    for (int i = 0; i < this.gpdbKubunValueIds.length; ++i) {
                        EipMGpdbKubunValue gpdbKubunValue = this.getEipTGpdbKubunValueFromKubunValueId(list, this.gpdbKubunValueIds[i]);
                        this.gpdbKubunValueList.add(GpdbUtils.getGpdbKubunValueResultData(gpdbKubunValue));
                        this.rawGpdbKubunValueList.add(gpdbKubunValue);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            int newPosition = 1;
            for (EipMGpdbKubunValue gpdbKubunValue : this.rawGpdbKubunValueList) {
                gpdbKubunValue.setOrderNo(Integer.valueOf(newPosition));
                ++newPosition;
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    private EipMGpdbKubunValue getEipTGpdbKubunValueFromKubunValueId(List<EipMGpdbKubunValue> gpdbKubunValueList, String kubunValueId) {
        for (int i = 0; i < gpdbKubunValueList.size(); ++i) {
            EipMGpdbKubunValue gpdbItem = gpdbKubunValueList.get(i);
            if (!gpdbItem.getGpdbKubunValueId().toString().equals(kubunValueId)) continue;
            return gpdbItem;
        }
        return null;
    }

    public List<GpdbKubunValueResultData> getGpdbKubunValueList() {
        return this.gpdbKubunValueList;
    }

    public Integer getGpdbKubunId() {
        return this.kubunId;
    }
}

